/*
 * Configurate
 * Copyright (C) zml and Configurate contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.spongepowered.configurate.transformation;

import org.spongepowered.configurate.ConfigurationNode;

/**
 * Strategy to use when moving a node from one path to another.
 *
 * @since 4.0.0
 */
public enum MoveStrategy {

    /**
     * Moves nodes using {@link ConfigurationNode#mergeFrom(ConfigurationNode)}.
     *
     * @since 4.0.0
     */
    MERGE {
        @Override
        public <T extends ConfigurationNode> void move(final T source, final T target) {
            target.mergeFrom(source);
        }
    },

    /**
     * Moves nodes using {@link ConfigurationNode#set(Object)}.
     *
     * @since 4.0.0
     */
    OVERWRITE {
        @Override
        public <T extends ConfigurationNode> void move(final T source, final T target) {
            target.from(source);
        }
    };

    /**
     * Moves <code>source</code> to <code>target</code>.
     *
     * @param <T> the type of node being processed
     * @param source the source node
     * @param target the target node
     * @since 4.0.0
     */
    public abstract <T extends ConfigurationNode> void move(T source, T target);

}
