/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.serialize.ArraySerializer;
import org.spongepowered.configurate.serialize.ConfigurationNodeSerializer;
import org.spongepowered.configurate.serialize.FileSerializer;
import org.spongepowered.configurate.serialize.ListSerializer;
import org.spongepowered.configurate.serialize.MapSerializer;
import org.spongepowered.configurate.serialize.PathSerializer;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.Scalars;
import org.spongepowered.configurate.serialize.SetSerializer;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.Types;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class TypeSerializerCollection {
    private static final TypeSerializerCollection DEFAULTS = TypeSerializerCollection.builder().registerExact(Scalars.STRING).registerExact(Scalars.BOOLEAN).register(MapSerializer.TYPE, new MapSerializer()).register(ListSerializer.TYPE, new ListSerializer()).registerExact(Scalars.BYTE).registerExact(Scalars.SHORT).registerExact(Scalars.INTEGER).registerExact(Scalars.LONG).registerExact(Scalars.FLOAT).registerExact(Scalars.DOUBLE).registerAnnotatedObjects(ObjectMapper.factory()).register(Scalars.ENUM).registerExact(Scalars.CHAR).registerExact(Scalars.URI).registerExact(Scalars.URL).registerExact(Scalars.UUID).registerExact(Scalars.PATTERN).register(ArraySerializer.Objects::accepts, new ArraySerializer.Objects()).registerExact(ArraySerializer.Booleans.TYPE, new ArraySerializer.Booleans()).registerExact(ArraySerializer.Bytes.TYPE, new ArraySerializer.Bytes()).registerExact(ArraySerializer.Chars.TYPE, new ArraySerializer.Chars()).registerExact(ArraySerializer.Shorts.TYPE, new ArraySerializer.Shorts()).registerExact(ArraySerializer.Ints.TYPE, new ArraySerializer.Ints()).registerExact(ArraySerializer.Longs.TYPE, new ArraySerializer.Longs()).registerExact(ArraySerializer.Floats.TYPE, new ArraySerializer.Floats()).registerExact(ArraySerializer.Doubles.TYPE, new ArraySerializer.Doubles()).register(SetSerializer.TYPE, new SetSerializer()).register(ConfigurationNodeSerializer.TYPE, new ConfigurationNodeSerializer()).register(PathSerializer.TYPE, PathSerializer.INSTANCE).registerExact(FileSerializer.TYPE, FileSerializer.INSTANCE).build();
    private final @Nullable TypeSerializerCollection parent;
    private final List<RegisteredSerializer> serializers;
    private final Map<Type, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();

    private TypeSerializerCollection(@Nullable TypeSerializerCollection parent, List<RegisteredSerializer> serializers) {
        this.parent = parent;
        this.serializers = UnmodifiableCollections.copyOf(serializers);
    }

    public <T> @Nullable TypeSerializer<T> get(TypeToken<T> token) {
        Objects.requireNonNull(token, "type");
        return this.get(token.getType());
    }

    public <T> @Nullable TypeSerializer<T> get(Class<T> token) {
        Objects.requireNonNull(token, "type");
        Types.requireCompleteParameters(token);
        return this.get((Type)token);
    }

    public @Nullable TypeSerializer<?> get(Type type) {
        @Nullable TypeSerializer<?> serial = this.typeMatches.computeIfAbsent(type = GenericTypeReflector.toCanonicalBoxed((AnnotatedType)GenericTypeReflector.annotate((Type)Objects.requireNonNull(type, "type"))).getType(), param -> {
            for (RegisteredSerializer ent : this.serializers) {
                if (!ent.predicate.test(param)) continue;
                return ent.serializer;
            }
            return null;
        });
        if (serial == null && this.parent != null) {
            serial = this.parent.get(type);
        }
        return serial;
    }

    public Builder childBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "TypeSerializerCollection{parent=" + this.parent + ", serializers=" + this.serializers + '}';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeSerializerCollection)) {
            return false;
        }
        TypeSerializerCollection that = (TypeSerializerCollection)other;
        return Objects.equals(this.parent, that.parent) && this.serializers.equals(that.serializers);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.serializers);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static TypeSerializerCollection defaults() {
        return DEFAULTS;
    }

    private static final class RegisteredSerializer {
        private final Predicate<Type> predicate;
        private final TypeSerializer<?> serializer;

        private RegisteredSerializer(Predicate<Type> predicate, TypeSerializer<?> serializer) {
            this.predicate = predicate;
            this.serializer = serializer;
        }
    }

    public static class Builder {
        private final @Nullable TypeSerializerCollection parent;
        private final List<RegisteredSerializer> serializers = new ArrayList<RegisteredSerializer>();

        Builder(@Nullable TypeSerializerCollection parent) {
            this.parent = parent;
        }

        public <T> Builder register(TypeToken<T> type, TypeSerializer<? super T> serializer) {
            return this.register0(type.getType(), serializer);
        }

        public <T> Builder register(Class<T> type, TypeSerializer<? super T> serializer) {
            return this.register0(type, serializer);
        }

        public <T> Builder register(Predicate<Type> test, TypeSerializer<? super T> serializer) {
            Objects.requireNonNull(test, "test");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test, serializer));
            return this;
        }

        public <T> Builder register(ScalarSerializer<T> serializer) {
            Objects.requireNonNull(serializer, "serializer");
            return this.register(serializer.type(), serializer);
        }

        private Builder register0(Type type, TypeSerializer<?> serializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test -> {
                Type[] upperBounds;
                if (GenericTypeReflector.isSuperType((Type)type, (Type)test)) {
                    return true;
                }
                if (test instanceof WildcardType && (upperBounds = ((WildcardType)test).getUpperBounds()).length == 1) {
                    return GenericTypeReflector.isSuperType((Type)type, (Type)upperBounds[0]);
                }
                return false;
            }, serializer));
            return this;
        }

        public <T> Builder registerExact(TypeToken<T> type, TypeSerializer<? super T> serializer) {
            return this.registerExact0(type.getType(), serializer);
        }

        public <T> Builder registerExact(Class<T> type, TypeSerializer<? super T> serializer) {
            return this.registerExact0(type, serializer);
        }

        public <T> Builder registerExact(ScalarSerializer<T> serializer) {
            Objects.requireNonNull(serializer, "serializer");
            return this.registerExact(serializer.type(), serializer);
        }

        private Builder registerExact0(Type type, TypeSerializer<?> serializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test -> test.equals(type), serializer));
            return this;
        }

        public Builder registerAll(TypeSerializerCollection other) {
            this.serializers.addAll(Objects.requireNonNull(other, "other").serializers);
            return this;
        }

        public Builder registerAnnotatedObjects(ObjectMapper.Factory factory) {
            return this.register(Builder::isAnnotatedTarget, factory.asTypeSerializer());
        }

        static boolean isAnnotatedTarget(Type type) {
            return GenericTypeReflector.annotate((Type)type).isAnnotationPresent(ConfigSerializable.class);
        }

        public TypeSerializerCollection build() {
            return new TypeSerializerCollection(this.parent, this.serializers);
        }
    }
}

