/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.AbstractListChildSerializer;
import org.spongepowered.configurate.serialize.Scalars;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedConsumer;
import org.spongepowered.configurate.util.Types;

abstract class ArraySerializer<T>
extends AbstractListChildSerializer<T> {
    ArraySerializer() {
    }

    @Override
    Type elementType(Type containerType) throws SerializationException {
        Type componentType = GenericTypeReflector.getArrayComponentType((Type)containerType);
        if (componentType == null) {
            throw new SerializationException(containerType, "Must be array type");
        }
        return componentType;
    }

    static class Doubles
    extends ArraySerializer<double[]> {
        static final Class<double[]> TYPE = double[].class;

        Doubles() {
        }

        @Override
        double[] createNew(int length, Type elementType) {
            return new double[length];
        }

        @Override
        void forEachElement(double[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (double b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, double[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0.0 : Scalars.DOUBLE.deserialize(deserialized);
        }
    }

    static class Floats
    extends ArraySerializer<float[]> {
        static final Class<float[]> TYPE = float[].class;

        Floats() {
        }

        @Override
        float[] createNew(int length, Type elementType) {
            return new float[length];
        }

        @Override
        void forEachElement(float[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (float b : collection) {
                action.accept(Float.valueOf(b));
            }
        }

        @Override
        void deserializeSingle(int index, float[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0.0f : Scalars.FLOAT.deserialize(deserialized).floatValue();
        }
    }

    static class Longs
    extends ArraySerializer<long[]> {
        static final Class<long[]> TYPE = long[].class;

        Longs() {
        }

        @Override
        long[] createNew(int length, Type elementType) {
            return new long[length];
        }

        @Override
        void forEachElement(long[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (long b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, long[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0L : Scalars.LONG.deserialize(deserialized);
        }
    }

    static class Ints
    extends ArraySerializer<int[]> {
        static final Class<int[]> TYPE = int[].class;

        Ints() {
        }

        @Override
        int[] createNew(int length, Type elementType) {
            return new int[length];
        }

        @Override
        void forEachElement(int[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (int b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, int[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? 0 : Scalars.INTEGER.deserialize(deserialized);
        }
    }

    static class Shorts
    extends ArraySerializer<short[]> {
        static final Class<short[]> TYPE = short[].class;

        Shorts() {
        }

        @Override
        short[] createNew(int length, Type elementType) {
            return new short[length];
        }

        @Override
        void forEachElement(short[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (short b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, short[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (short)0 : Scalars.INTEGER.deserialize(deserialized).shortValue();
        }
    }

    static class Chars
    extends ArraySerializer<char[]> {
        static final Class<char[]> TYPE = char[].class;

        Chars() {
        }

        @Override
        char[] createNew(int length, Type elementType) {
            return new char[length];
        }

        @Override
        void forEachElement(char[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (char b : collection) {
                action.accept(Character.valueOf(b));
            }
        }

        @Override
        void deserializeSingle(int index, char[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (char)'\u0000' : Scalars.CHAR.deserialize(deserialized).charValue();
        }
    }

    static class Bytes
    extends ArraySerializer<byte[]> {
        static final Class<byte[]> TYPE = byte[].class;

        Bytes() {
        }

        @Override
        byte[] createNew(int length, Type elementType) {
            return new byte[length];
        }

        @Override
        void forEachElement(byte[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (byte b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, byte[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? (byte)0 : Scalars.INTEGER.deserialize(deserialized).byteValue();
        }
    }

    static class Booleans
    extends ArraySerializer<boolean[]> {
        static final Class<boolean[]> TYPE = boolean[].class;

        Booleans() {
        }

        @Override
        boolean[] createNew(int length, Type elementType) {
            return new boolean[length];
        }

        @Override
        void forEachElement(boolean[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (boolean b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, boolean[] collection, @Nullable Object deserialized) throws SerializationException {
            collection[index] = deserialized == null ? false : Scalars.BOOLEAN.deserialize(deserialized);
        }
    }

    static class Objects
    extends ArraySerializer<Object[]> {
        Objects() {
        }

        public static boolean accepts(Type token) {
            if (!Types.isArray(token)) {
                return false;
            }
            Type componentType = GenericTypeReflector.getArrayComponentType((Type)token);
            return componentType.equals(GenericTypeReflector.box((Type)componentType));
        }

        @Override
        Object[] createNew(int length, Type elementType) {
            return (Object[])Array.newInstance(GenericTypeReflector.erase((Type)elementType), length);
        }

        @Override
        void forEachElement(Object[] collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
            for (Object o : collection) {
                action.accept(o);
            }
        }

        @Override
        void deserializeSingle(int index, Object[] collection, @Nullable Object deserialized) {
            collection[index] = deserialized;
        }
    }
}

