package org.bukkit;

/**
 * Tree and organic structure types.
 */
public enum TreeType {

    /**
     * Regular tree, no branches
     */
    TREE,
    /**
     * Regular tree, extra tall with branches
     */
    BIG_TREE,
    /**
     * Redwood tree, shaped like a pine tree
     */
    REDWOOD,
    /**
     * Tall redwood tree with just a few leaves at the top
     */
    TALL_REDWOOD,
    /**
     * Birch tree
     */
    BIRCH,
    /**
     * Standard jungle tree; 4 blocks wide and tall
     */
    JUNGLE,
    /**
     * Smaller jungle tree; 1 block wide
     */
    SMALL_JUNGLE,
    /**
     * Jungle tree with cocoa plants; 1 block wide
     */
    COCOA_TREE,
    /**
     * Small bush that grows in the jungle
     */
    JUNGLE_BUSH,
    /**
     * Big red mushroom; short and fat
     */
    RED_MUSHROOM,
    /**
     * Big brown mushroom; tall and umbrella-like
     */
    BROWN_MUSHROOM,
    /**
     * Swamp tree (regular with vines on the side)
     */
    SWAMP,
    /**
     * Acacia tree.
     */
    ACACIA,
    /**
     * Dark Oak tree.
     */
    DARK_OAK,
    /**
     * Mega redwood tree; 4 blocks wide and tall
     */
    MEGA_REDWOOD,
    /**
     * Mega pine tree
     */
    MEGA_PINE,
    /**
     * Tall birch tree
     */
    TALL_BIRCH,
    /**
     * Large plant native to The End
     */
    CHORUS_PLANT,
    /**
     * Large crimson fungus native to the nether
     */
    CRIMSON_FUNGUS,
    /**
     * Large warped fungus native to the nether
     */
    WARPED_FUNGUS,
    /**
     * Tree with large roots which grows above lush caves
     */
    AZALEA,
    /**
     * Mangrove tree
     */
    MANGROVE,
    /**
     * Tall mangrove tree
     */
    TALL_MANGROVE,
    /**
     * Cherry tree
     */
    CHERRY,
    /**
     * Pale oak tree
     */
    PALE_OAK,
    /**
     * Pale oak tree with a creaking heart
     */
    PALE_OAK_CREAKING,
}
