/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.potion;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PotionType implements Keyed
{
    WATER("water"),
    MUNDANE("mundane"),
    THICK("thick"),
    AWKWARD("awkward"),
    NIGHT_VISION("night_vision"),
    LONG_NIGHT_VISION("long_night_vision"),
    INVISIBILITY("invisibility"),
    LONG_INVISIBILITY("long_invisibility"),
    LEAPING("leaping"),
    LONG_LEAPING("long_leaping"),
    STRONG_LEAPING("strong_leaping"),
    FIRE_RESISTANCE("fire_resistance"),
    LONG_FIRE_RESISTANCE("long_fire_resistance"),
    SWIFTNESS("swiftness"),
    LONG_SWIFTNESS("long_swiftness"),
    STRONG_SWIFTNESS("strong_swiftness"),
    SLOWNESS("slowness"),
    LONG_SLOWNESS("long_slowness"),
    STRONG_SLOWNESS("strong_slowness"),
    WATER_BREATHING("water_breathing"),
    LONG_WATER_BREATHING("long_water_breathing"),
    HEALING("healing"),
    STRONG_HEALING("strong_healing"),
    HARMING("harming"),
    STRONG_HARMING("strong_harming"),
    POISON("poison"),
    LONG_POISON("long_poison"),
    STRONG_POISON("strong_poison"),
    REGENERATION("regeneration"),
    LONG_REGENERATION("long_regeneration"),
    STRONG_REGENERATION("strong_regeneration"),
    STRENGTH("strength"),
    LONG_STRENGTH("long_strength"),
    STRONG_STRENGTH("strong_strength"),
    WEAKNESS("weakness"),
    LONG_WEAKNESS("long_weakness"),
    LUCK("luck"),
    TURTLE_MASTER("turtle_master"),
    LONG_TURTLE_MASTER("long_turtle_master"),
    STRONG_TURTLE_MASTER("strong_turtle_master"),
    SLOW_FALLING("slow_falling"),
    LONG_SLOW_FALLING("long_slow_falling"),
    WIND_CHARGED("wind_charged"),
    WEAVING("weaving"),
    OOZING("oozing"),
    INFESTED("infested");

    private final NamespacedKey key;
    private final Supplier<InternalPotionData> internalPotionDataSupplier;

    private PotionType(String key) {
        this.key = NamespacedKey.minecraft(key);
        this.internalPotionDataSupplier = Suppliers.memoize(() -> Bukkit.getUnsafe().getInternalPotionData(this.key));
    }

    @Deprecated(since="1.20.2")
    @Nullable
    public PotionEffectType getEffectType() {
        return this.internalPotionDataSupplier.get().getEffectType();
    }

    @NotNull
    public List<PotionEffect> getPotionEffects() {
        return this.internalPotionDataSupplier.get().getPotionEffects();
    }

    @Deprecated(since="1.20.2")
    public boolean isInstant() {
        return this.internalPotionDataSupplier.get().isInstant();
    }

    public boolean isUpgradeable() {
        return this.internalPotionDataSupplier.get().isUpgradeable();
    }

    public boolean isExtendable() {
        return this.internalPotionDataSupplier.get().isExtendable();
    }

    public int getMaxLevel() {
        return this.internalPotionDataSupplier.get().getMaxLevel();
    }

    @Deprecated(since="1.9")
    @Nullable
    public static PotionType getByEffect(@Nullable PotionEffectType effectType) {
        if (effectType == null) {
            return WATER;
        }
        for (PotionType type : PotionType.values()) {
            if (!effectType.equals(type.getEffectType())) continue;
            return type;
        }
        return null;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated(since="1.20.2")
    @ApiStatus.Internal
    public static interface InternalPotionData {
        public PotionEffectType getEffectType();

        public List<PotionEffect> getPotionEffects();

        public boolean isInstant();

        public boolean isUpgradeable();

        public boolean isExtendable();

        public int getMaxLevel();
    }
}

