/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public interface Attribute
extends OldEnum<Attribute>,
Keyed,
Translatable {
    public static final Attribute MAX_HEALTH = Attribute.getAttribute("max_health");
    public static final Attribute FOLLOW_RANGE = Attribute.getAttribute("follow_range");
    public static final Attribute KNOCKBACK_RESISTANCE = Attribute.getAttribute("knockback_resistance");
    public static final Attribute MOVEMENT_SPEED = Attribute.getAttribute("movement_speed");
    public static final Attribute FLYING_SPEED = Attribute.getAttribute("flying_speed");
    public static final Attribute ATTACK_DAMAGE = Attribute.getAttribute("attack_damage");
    public static final Attribute ATTACK_KNOCKBACK = Attribute.getAttribute("attack_knockback");
    public static final Attribute ATTACK_SPEED = Attribute.getAttribute("attack_speed");
    public static final Attribute ARMOR = Attribute.getAttribute("armor");
    public static final Attribute ARMOR_TOUGHNESS = Attribute.getAttribute("armor_toughness");
    public static final Attribute FALL_DAMAGE_MULTIPLIER = Attribute.getAttribute("fall_damage_multiplier");
    public static final Attribute LUCK = Attribute.getAttribute("luck");
    public static final Attribute MAX_ABSORPTION = Attribute.getAttribute("max_absorption");
    public static final Attribute SAFE_FALL_DISTANCE = Attribute.getAttribute("safe_fall_distance");
    public static final Attribute SCALE = Attribute.getAttribute("scale");
    public static final Attribute STEP_HEIGHT = Attribute.getAttribute("step_height");
    public static final Attribute GRAVITY = Attribute.getAttribute("gravity");
    public static final Attribute JUMP_STRENGTH = Attribute.getAttribute("jump_strength");
    public static final Attribute BURNING_TIME = Attribute.getAttribute("burning_time");
    public static final Attribute EXPLOSION_KNOCKBACK_RESISTANCE = Attribute.getAttribute("explosion_knockback_resistance");
    public static final Attribute MOVEMENT_EFFICIENCY = Attribute.getAttribute("movement_efficiency");
    public static final Attribute OXYGEN_BONUS = Attribute.getAttribute("oxygen_bonus");
    public static final Attribute WATER_MOVEMENT_EFFICIENCY = Attribute.getAttribute("water_movement_efficiency");
    public static final Attribute TEMPT_RANGE = Attribute.getAttribute("tempt_range");
    public static final Attribute BLOCK_INTERACTION_RANGE = Attribute.getAttribute("block_interaction_range");
    public static final Attribute ENTITY_INTERACTION_RANGE = Attribute.getAttribute("entity_interaction_range");
    public static final Attribute BLOCK_BREAK_SPEED = Attribute.getAttribute("block_break_speed");
    public static final Attribute MINING_EFFICIENCY = Attribute.getAttribute("mining_efficiency");
    public static final Attribute SNEAKING_SPEED = Attribute.getAttribute("sneaking_speed");
    public static final Attribute SUBMERGED_MINING_SPEED = Attribute.getAttribute("submerged_mining_speed");
    public static final Attribute SWEEPING_DAMAGE_RATIO = Attribute.getAttribute("sweeping_damage_ratio");
    public static final Attribute SPAWN_REINFORCEMENTS = Attribute.getAttribute("spawn_reinforcements");

    @NotNull
    private static Attribute getAttribute(@NotNull String key) {
        return Registry.ATTRIBUTE.getOrThrow(NamespacedKey.minecraft(key));
    }

    @Deprecated(since="1.21.3")
    @NotNull
    public static Attribute valueOf(@NotNull String name) {
        Attribute attribute = Bukkit.getUnsafe().get(Registry.ATTRIBUTE, NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (String)"No attribute found with the name %s", (Object)name);
        return attribute;
    }

    @Deprecated(since="1.21.3")
    @NotNull
    public static Attribute[] values() {
        return Lists.newArrayList(Registry.ATTRIBUTE).toArray(new Attribute[0]);
    }
}

