/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapCursor {
    private byte x;
    private byte y;
    private byte direction;
    private boolean visible;
    private String caption;
    private Type type;

    @Deprecated(since="1.6.2")
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible) {
        this(x, y, direction, type, visible, null);
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible) {
        this(x, y, direction, type, visible, null);
    }

    @Deprecated(since="1.13")
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setRawType(type);
        this.visible = visible;
        this.caption = caption;
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.type = type;
        this.visible = visible;
        this.caption = caption;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getDirection() {
        return this.direction;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Deprecated(since="1.6.2")
    public byte getRawType() {
        return this.type.getValue();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public void setY(byte y) {
        this.y = y;
    }

    public void setDirection(byte direction) {
        Preconditions.checkArgument((direction >= 0 && direction <= 15 ? 1 : 0) != 0, (String)"direction must be between 0 and 15 but is %s", (int)direction);
        this.direction = direction;
    }

    public void setType(@NotNull Type type) {
        this.type = type;
    }

    @Deprecated(since="1.6.2")
    public void setRawType(byte type) {
        Type enumType = Type.byValue(type);
        Preconditions.checkArgument((enumType != null ? 1 : 0) != 0, (String)"Unknown type by id %s", (int)type);
        this.type = enumType;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Nullable
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(@Nullable String caption) {
        this.caption = caption;
    }

    public static interface Type
    extends OldEnum<Type>,
    Keyed {
        public static final Type PLAYER = Type.getType("player");
        public static final Type FRAME = Type.getType("frame");
        public static final Type RED_MARKER = Type.getType("red_marker");
        public static final Type BLUE_MARKER = Type.getType("blue_marker");
        public static final Type TARGET_X = Type.getType("target_x");
        public static final Type TARGET_POINT = Type.getType("target_point");
        public static final Type PLAYER_OFF_MAP = Type.getType("player_off_map");
        public static final Type PLAYER_OFF_LIMITS = Type.getType("player_off_limits");
        public static final Type MANSION = Type.getType("mansion");
        public static final Type MONUMENT = Type.getType("monument");
        public static final Type BANNER_WHITE = Type.getType("banner_white");
        public static final Type BANNER_ORANGE = Type.getType("banner_orange");
        public static final Type BANNER_MAGENTA = Type.getType("banner_magenta");
        public static final Type BANNER_LIGHT_BLUE = Type.getType("banner_light_blue");
        public static final Type BANNER_YELLOW = Type.getType("banner_yellow");
        public static final Type BANNER_LIME = Type.getType("banner_lime");
        public static final Type BANNER_PINK = Type.getType("banner_pink");
        public static final Type BANNER_GRAY = Type.getType("banner_gray");
        public static final Type BANNER_LIGHT_GRAY = Type.getType("banner_light_gray");
        public static final Type BANNER_CYAN = Type.getType("banner_cyan");
        public static final Type BANNER_PURPLE = Type.getType("banner_purple");
        public static final Type BANNER_BLUE = Type.getType("banner_blue");
        public static final Type BANNER_BROWN = Type.getType("banner_brown");
        public static final Type BANNER_GREEN = Type.getType("banner_green");
        public static final Type BANNER_RED = Type.getType("banner_red");
        public static final Type BANNER_BLACK = Type.getType("banner_black");
        public static final Type RED_X = Type.getType("red_x");
        public static final Type VILLAGE_DESERT = Type.getType("village_desert");
        public static final Type VILLAGE_PLAINS = Type.getType("village_plains");
        public static final Type VILLAGE_SAVANNA = Type.getType("village_savanna");
        public static final Type VILLAGE_SNOWY = Type.getType("village_snowy");
        public static final Type VILLAGE_TAIGA = Type.getType("village_taiga");
        public static final Type JUNGLE_TEMPLE = Type.getType("jungle_temple");
        public static final Type SWAMP_HUT = Type.getType("swamp_hut");
        public static final Type TRIAL_CHAMBERS = Type.getType("trial_chambers");

        @NotNull
        private static Type getType(@NotNull String key) {
            return Registry.MAP_DECORATION_TYPE.getOrThrow(NamespacedKey.minecraft(key));
        }

        @Deprecated(since="1.6.2")
        public byte getValue();

        @Deprecated(since="1.6.2")
        @Nullable
        public static Type byValue(byte value) {
            for (Type t : Type.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            return null;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Type valueOf(@NotNull String name) {
            Type type = Registry.MAP_DECORATION_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No Type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Type[] values() {
            return Lists.newArrayList(Registry.MAP_DECORATION_TYPE).toArray(new Type[0]);
        }
    }
}

