/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.attribute;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeModifier
implements ConfigurationSerializable,
Keyed {
    private final NamespacedKey key;
    private final double amount;
    private final Operation operation;
    private final EquipmentSlotGroup slot;

    @Deprecated
    public AttributeModifier(@NotNull String name, double amount, @NotNull Operation operation) {
        this(UUID.randomUUID(), name, amount, operation);
    }

    @Deprecated
    public AttributeModifier(@NotNull UUID uuid, @NotNull String name, double amount, @NotNull Operation operation) {
        this(uuid, name, amount, operation, (EquipmentSlot)null);
    }

    @Deprecated
    public AttributeModifier(@NotNull UUID uuid, @NotNull String name, double amount, @NotNull Operation operation, @Nullable EquipmentSlot slot) {
        this(uuid, name, amount, operation, slot == null ? EquipmentSlotGroup.ANY : slot.getGroup());
    }

    @Deprecated
    public AttributeModifier(@NotNull UUID uuid, @NotNull String name, double amount, @NotNull Operation operation, @NotNull EquipmentSlotGroup slot) {
        this(NamespacedKey.fromString(uuid.toString()), amount, operation, slot);
    }

    public AttributeModifier(@NotNull NamespacedKey key, double amount, @NotNull Operation operation, @NotNull EquipmentSlotGroup slot) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        Preconditions.checkArgument((operation != null ? 1 : 0) != 0, (Object)"Operation cannot be null");
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"EquipmentSlotGroup cannot be null");
        this.key = key;
        this.amount = amount;
        this.operation = operation;
        this.slot = slot;
    }

    @Deprecated
    @NotNull
    public UUID getUniqueId() {
        return UUID.nameUUIDFromBytes(this.getKey().toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.key.getKey();
    }

    public double getAmount() {
        return this.amount;
    }

    @NotNull
    public Operation getOperation() {
        return this.operation;
    }

    @Deprecated
    @Nullable
    public EquipmentSlot getSlot() {
        return this.slot == EquipmentSlotGroup.ANY ? null : this.slot.getExample();
    }

    @NotNull
    public EquipmentSlotGroup getSlotGroup() {
        return this.slot;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("key", this.key.toString());
        data.put("operation", this.operation.ordinal());
        data.put("amount", this.amount);
        if (this.slot != null && this.slot != EquipmentSlotGroup.ANY) {
            data.put("slot", this.slot.toString());
        }
        return data;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier mod = (AttributeModifier)other;
        boolean slots = this.slot != null ? this.slot == mod.slot : mod.slot == null;
        return this.key.equals(mod.key) && this.amount == mod.amount && this.operation == mod.operation && slots;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.key);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.amount) ^ Double.doubleToLongBits(this.amount) >>> 32);
        hash = 17 * hash + Objects.hashCode((Object)this.operation);
        hash = 17 * hash + Objects.hashCode(this.slot);
        return hash;
    }

    public String toString() {
        return "AttributeModifier{key=" + this.key.toString() + ", operation=" + this.operation.name() + ", amount=" + this.amount + ", slot=" + (this.slot != null ? this.slot.toString() : "") + "}";
    }

    @NotNull
    public static AttributeModifier deserialize(@NotNull Map<String, Object> args) {
        NamespacedKey key = args.containsKey("uuid") ? NamespacedKey.fromString((String)args.get("uuid")) : NamespacedKey.fromString((String)args.get("key"));
        if (args.containsKey("slot")) {
            EquipmentSlotGroup slotGroup = EquipmentSlotGroup.getByName(args.get("slot").toString().toLowerCase(Locale.ROOT));
            if (slotGroup == null) {
                slotGroup = EquipmentSlotGroup.ANY;
                EquipmentSlot slot = EquipmentSlot.valueOf(args.get("slot").toString().toUpperCase(Locale.ROOT));
                if (slot != null) {
                    slotGroup = slot.getGroup();
                }
            }
            return new AttributeModifier(key, NumberConversions.toDouble(args.get("amount")), Operation.values()[NumberConversions.toInt(args.get("operation"))], slotGroup);
        }
        return new AttributeModifier(key, NumberConversions.toDouble(args.get("amount")), Operation.values()[NumberConversions.toInt(args.get("operation"))], EquipmentSlotGroup.ANY);
    }

    public static enum Operation {
        ADD_NUMBER,
        ADD_SCALAR,
        MULTIPLY_SCALAR_1;

    }
}

