/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

import com.google.common.base.Preconditions;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapCursor {
    private byte x;
    private byte y;
    private byte direction;
    private boolean visible;
    private String caption;
    private Type type;

    @Deprecated
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible) {
        this(x, y, direction, type, visible, null);
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible) {
        this(x, y, direction, type, visible, null);
    }

    @Deprecated
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setRawType(type);
        this.visible = visible;
        this.caption = caption;
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.type = type;
        this.visible = visible;
        this.caption = caption;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getDirection() {
        return this.direction;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Deprecated
    public byte getRawType() {
        return this.type.value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public void setY(byte y) {
        this.y = y;
    }

    public void setDirection(byte direction) {
        Preconditions.checkArgument((direction >= 0 && direction <= 15 ? 1 : 0) != 0, (String)"direction must be between 0 and 15 but is %s", (int)direction);
        this.direction = direction;
    }

    public void setType(@NotNull Type type) {
        this.type = type;
    }

    @Deprecated
    public void setRawType(byte type) {
        Type enumType = Type.byValue(type);
        Preconditions.checkArgument((enumType != null ? 1 : 0) != 0, (String)"Unknown type by id %s", (int)type);
        this.type = enumType;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Nullable
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(@Nullable String caption) {
        this.caption = caption;
    }

    public static enum Type implements Keyed
    {
        PLAYER(0, "player"),
        FRAME(1, "frame"),
        RED_MARKER(2, "red_marker"),
        BLUE_MARKER(3, "blue_marker"),
        TARGET_X(4, "target_x"),
        TARGET_POINT(5, "target_point"),
        PLAYER_OFF_MAP(6, "player_off_map"),
        PLAYER_OFF_LIMITS(7, "player_off_limits"),
        MANSION(8, "mansion"),
        MONUMENT(9, "monument"),
        BANNER_WHITE(10, "banner_white"),
        BANNER_ORANGE(11, "banner_orange"),
        BANNER_MAGENTA(12, "banner_magenta"),
        BANNER_LIGHT_BLUE(13, "banner_light_blue"),
        BANNER_YELLOW(14, "banner_yellow"),
        BANNER_LIME(15, "banner_lime"),
        BANNER_PINK(16, "banner_pink"),
        BANNER_GRAY(17, "banner_gray"),
        BANNER_LIGHT_GRAY(18, "banner_light_gray"),
        BANNER_CYAN(19, "banner_cyan"),
        BANNER_PURPLE(20, "banner_purple"),
        BANNER_BLUE(21, "banner_blue"),
        BANNER_BROWN(22, "banner_brown"),
        BANNER_GREEN(23, "banner_green"),
        BANNER_RED(24, "banner_red"),
        BANNER_BLACK(25, "banner_black"),
        RED_X(26, "red_x"),
        VILLAGE_DESERT(27, "village_desert"),
        VILLAGE_PLAINS(28, "village_plains"),
        VILLAGE_SAVANNA(29, "village_savanna"),
        VILLAGE_SNOWY(30, "village_snowy"),
        VILLAGE_TAIGA(31, "village_taiga"),
        JUNGLE_TEMPLE(32, "jungle_temple"),
        SWAMP_HUT(33, "swamp_hut"),
        TRIAL_CHAMBERS(34, "trial_chambers");

        private final byte value;
        private final NamespacedKey key;

        private Type(int value, String key) {
            this.value = (byte)value;
            this.key = NamespacedKey.minecraft(key);
        }

        @Override
        @NotNull
        public NamespacedKey getKey() {
            return this.key;
        }

        @Deprecated
        public byte getValue() {
            return this.value;
        }

        @Deprecated
        @Nullable
        public static Type byValue(byte value) {
            for (Type t : Type.values()) {
                if (t.value != value) continue;
                return t;
            }
            return null;
        }
    }
}

