/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Villager
extends AbstractVillager {
    @NotNull
    public Profession getProfession();

    public void setProfession(@NotNull Profession var1);

    @NotNull
    public Type getVillagerType();

    public void setVillagerType(@NotNull Type var1);

    public int getVillagerLevel();

    public void setVillagerLevel(int var1);

    public int getVillagerExperience();

    public void setVillagerExperience(int var1);

    public boolean sleep(@NotNull Location var1);

    public void wakeup();

    public void shakeHead();

    @Nullable
    public ZombieVillager zombify();

    public static abstract class Profession
    implements OldEnum<Profession>,
    Keyed {
        public static final Profession NONE = Profession.getProfession("none");
        public static final Profession ARMORER = Profession.getProfession("armorer");
        public static final Profession BUTCHER = Profession.getProfession("butcher");
        public static final Profession CARTOGRAPHER = Profession.getProfession("cartographer");
        public static final Profession CLERIC = Profession.getProfession("cleric");
        public static final Profession FARMER = Profession.getProfession("farmer");
        public static final Profession FISHERMAN = Profession.getProfession("fisherman");
        public static final Profession FLETCHER = Profession.getProfession("fletcher");
        public static final Profession LEATHERWORKER = Profession.getProfession("leatherworker");
        public static final Profession LIBRARIAN = Profession.getProfession("librarian");
        public static final Profession MASON = Profession.getProfession("mason");
        public static final Profession NITWIT = Profession.getProfession("nitwit");
        public static final Profession SHEPHERD = Profession.getProfession("shepherd");
        public static final Profession TOOLSMITH = Profession.getProfession("toolsmith");
        public static final Profession WEAPONSMITH = Profession.getProfession("weaponsmith");

        @NotNull
        private static Profession getProfession(@NotNull String key) {
            NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
            Profession profession = Registry.VILLAGER_PROFESSION.get(namespacedKey);
            Preconditions.checkNotNull((Object)profession, (String)"No villager profession found for %s. This is a bug.", (Object)namespacedKey);
            return profession;
        }

        @Deprecated
        @NotNull
        public static Profession valueOf(@NotNull String name) {
            Profession profession = Registry.VILLAGER_PROFESSION.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (String)"No villager profession found with the name %s", (Object)name);
            return profession;
        }

        @Deprecated
        @NotNull
        public static Profession[] values() {
            return Lists.newArrayList(Registry.VILLAGER_PROFESSION).toArray(new Profession[0]);
        }
    }

    public static abstract class Type
    implements OldEnum<Type>,
    Keyed {
        public static final Type DESERT = Type.getType("desert");
        public static final Type JUNGLE = Type.getType("jungle");
        public static final Type PLAINS = Type.getType("plains");
        public static final Type SAVANNA = Type.getType("savanna");
        public static final Type SNOW = Type.getType("snow");
        public static final Type SWAMP = Type.getType("swamp");
        public static final Type TAIGA = Type.getType("taiga");

        @NotNull
        private static Type getType(@NotNull String key) {
            NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
            Type type = Registry.VILLAGER_TYPE.get(namespacedKey);
            Preconditions.checkNotNull((Object)type, (String)"No villager type found for %s. This is a bug.", (Object)namespacedKey);
            return type;
        }

        @Deprecated
        @NotNull
        public static Type valueOf(@NotNull String name) {
            Type type = Registry.VILLAGER_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No villager type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated
        @NotNull
        public static Type[] values() {
            return Lists.newArrayList(Registry.VILLAGER_TYPE).toArray(new Type[0]);
        }
    }
}

