/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.World;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.OminousItemSpawner;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityType
implements OldEnum<EntityType>,
Keyed,
Translatable {
    private static final BiMap<Short, EntityType> ID_MAP = HashBiMap.create();
    public static final Typed<Item> ITEM = (Typed)EntityType.getEntityType("item", 1);
    public static final Typed<ExperienceOrb> EXPERIENCE_ORB = (Typed)EntityType.getEntityType("experience_orb", 2);
    public static final Typed<AreaEffectCloud> AREA_EFFECT_CLOUD = (Typed)EntityType.getEntityType("area_effect_cloud", 3);
    public static final Typed<ElderGuardian> ELDER_GUARDIAN = (Typed)EntityType.getEntityType("elder_guardian", 4);
    public static final Typed<WitherSkeleton> WITHER_SKELETON = (Typed)EntityType.getEntityType("wither_skeleton", 5);
    public static final Typed<Stray> STRAY = (Typed)EntityType.getEntityType("stray", 6);
    public static final Typed<Egg> EGG = (Typed)EntityType.getEntityType("egg", 7);
    public static final Typed<LeashHitch> LEASH_KNOT = (Typed)EntityType.getEntityType("leash_knot", 8);
    public static final Typed<Painting> PAINTING = (Typed)EntityType.getEntityType("painting", 9);
    public static final Typed<Arrow> ARROW = (Typed)EntityType.getEntityType("arrow", 10);
    public static final Typed<Snowball> SNOWBALL = (Typed)EntityType.getEntityType("snowball", 11);
    public static final Typed<LargeFireball> FIREBALL = (Typed)EntityType.getEntityType("fireball", 12);
    public static final Typed<SmallFireball> SMALL_FIREBALL = (Typed)EntityType.getEntityType("small_fireball", 13);
    public static final Typed<EnderPearl> ENDER_PEARL = (Typed)EntityType.getEntityType("ender_pearl", 14);
    public static final Typed<EnderSignal> EYE_OF_ENDER = (Typed)EntityType.getEntityType("eye_of_ender", 15);
    public static final Typed<ThrownPotion> POTION = (Typed)EntityType.getEntityType("potion", 16);
    public static final Typed<ThrownExpBottle> EXPERIENCE_BOTTLE = (Typed)EntityType.getEntityType("experience_bottle", 17);
    public static final Typed<ItemFrame> ITEM_FRAME = (Typed)EntityType.getEntityType("item_frame", 18);
    public static final Typed<WitherSkull> WITHER_SKULL = (Typed)EntityType.getEntityType("wither_skull", 19);
    public static final Typed<TNTPrimed> TNT = (Typed)EntityType.getEntityType("tnt", 20);
    public static final Typed<FallingBlock> FALLING_BLOCK = (Typed)EntityType.getEntityType("falling_block", 21);
    public static final Typed<Firework> FIREWORK_ROCKET = (Typed)EntityType.getEntityType("firework_rocket", 22);
    public static final Typed<Husk> HUSK = (Typed)EntityType.getEntityType("husk", 23);
    public static final Typed<SpectralArrow> SPECTRAL_ARROW = (Typed)EntityType.getEntityType("spectral_arrow", 24);
    public static final Typed<ShulkerBullet> SHULKER_BULLET = (Typed)EntityType.getEntityType("shulker_bullet", 25);
    public static final Typed<DragonFireball> DRAGON_FIREBALL = (Typed)EntityType.getEntityType("dragon_fireball", 26);
    public static final Typed<ZombieVillager> ZOMBIE_VILLAGER = (Typed)EntityType.getEntityType("zombie_villager", 27);
    public static final Typed<SkeletonHorse> SKELETON_HORSE = (Typed)EntityType.getEntityType("skeleton_horse", 28);
    public static final Typed<ZombieHorse> ZOMBIE_HORSE = (Typed)EntityType.getEntityType("zombie_horse", 29);
    public static final Typed<ArmorStand> ARMOR_STAND = (Typed)EntityType.getEntityType("armor_stand", 30);
    public static final Typed<Donkey> DONKEY = (Typed)EntityType.getEntityType("donkey", 31);
    public static final Typed<Mule> MULE = (Typed)EntityType.getEntityType("mule", 32);
    public static final Typed<EvokerFangs> EVOKER_FANGS = (Typed)EntityType.getEntityType("evoker_fangs", 33);
    public static final Typed<Evoker> EVOKER = (Typed)EntityType.getEntityType("evoker", 34);
    public static final Typed<Vex> VEX = (Typed)EntityType.getEntityType("vex", 35);
    public static final Typed<Vindicator> VINDICATOR = (Typed)EntityType.getEntityType("vindicator", 36);
    public static final Typed<Illusioner> ILLUSIONER = (Typed)EntityType.getEntityType("illusioner", 37);
    public static final Typed<CommandMinecart> COMMAND_BLOCK_MINECART = (Typed)EntityType.getEntityType("command_block_minecart", 40);
    public static final Typed<Boat> BOAT = (Typed)EntityType.getEntityType("boat", 41);
    public static final Typed<RideableMinecart> MINECART = (Typed)EntityType.getEntityType("minecart", 42);
    public static final Typed<StorageMinecart> CHEST_MINECART = (Typed)EntityType.getEntityType("chest_minecart", 43);
    public static final Typed<PoweredMinecart> FURNACE_MINECART = (Typed)EntityType.getEntityType("furnace_minecart", 44);
    public static final Typed<ExplosiveMinecart> TNT_MINECART = (Typed)EntityType.getEntityType("tnt_minecart", 45);
    public static final Typed<HopperMinecart> HOPPER_MINECART = (Typed)EntityType.getEntityType("hopper_minecart", 46);
    public static final Typed<SpawnerMinecart> SPAWNER_MINECART = (Typed)EntityType.getEntityType("spawner_minecart", 47);
    public static final Typed<Creeper> CREEPER = (Typed)EntityType.getEntityType("creeper", 50);
    public static final Typed<Skeleton> SKELETON = (Typed)EntityType.getEntityType("skeleton", 51);
    public static final Typed<Spider> SPIDER = (Typed)EntityType.getEntityType("spider", 52);
    public static final Typed<Giant> GIANT = (Typed)EntityType.getEntityType("giant", 53);
    public static final Typed<Zombie> ZOMBIE = (Typed)EntityType.getEntityType("zombie", 54);
    public static final Typed<Slime> SLIME = (Typed)EntityType.getEntityType("slime", 55);
    public static final Typed<Ghast> GHAST = (Typed)EntityType.getEntityType("ghast", 56);
    public static final Typed<PigZombie> ZOMBIFIED_PIGLIN = (Typed)EntityType.getEntityType("zombified_piglin", 57);
    public static final Typed<Enderman> ENDERMAN = (Typed)EntityType.getEntityType("enderman", 58);
    public static final Typed<CaveSpider> CAVE_SPIDER = (Typed)EntityType.getEntityType("cave_spider", 59);
    public static final Typed<Silverfish> SILVERFISH = (Typed)EntityType.getEntityType("silverfish", 60);
    public static final Typed<Blaze> BLAZE = (Typed)EntityType.getEntityType("blaze", 61);
    public static final Typed<MagmaCube> MAGMA_CUBE = (Typed)EntityType.getEntityType("magma_cube", 62);
    public static final Typed<EnderDragon> ENDER_DRAGON = (Typed)EntityType.getEntityType("ender_dragon", 63);
    public static final Typed<Wither> WITHER = (Typed)EntityType.getEntityType("wither", 64);
    public static final Typed<Bat> BAT = (Typed)EntityType.getEntityType("bat", 65);
    public static final Typed<Witch> WITCH = (Typed)EntityType.getEntityType("witch", 66);
    public static final Typed<Endermite> ENDERMITE = (Typed)EntityType.getEntityType("endermite", 67);
    public static final Typed<Guardian> GUARDIAN = (Typed)EntityType.getEntityType("guardian", 68);
    public static final Typed<Shulker> SHULKER = (Typed)EntityType.getEntityType("shulker", 69);
    public static final Typed<Pig> PIG = (Typed)EntityType.getEntityType("pig", 90);
    public static final Typed<Sheep> SHEEP = (Typed)EntityType.getEntityType("sheep", 91);
    public static final Typed<Cow> COW = (Typed)EntityType.getEntityType("cow", 92);
    public static final Typed<Chicken> CHICKEN = (Typed)EntityType.getEntityType("chicken", 93);
    public static final Typed<Squid> SQUID = (Typed)EntityType.getEntityType("squid", 94);
    public static final Typed<Wolf> WOLF = (Typed)EntityType.getEntityType("wolf", 95);
    public static final Typed<MushroomCow> MOOSHROOM = (Typed)EntityType.getEntityType("mooshroom", 96);
    public static final Typed<Snowman> SNOW_GOLEM = (Typed)EntityType.getEntityType("snow_golem", 97);
    public static final Typed<Ocelot> OCELOT = (Typed)EntityType.getEntityType("ocelot", 98);
    public static final Typed<IronGolem> IRON_GOLEM = (Typed)EntityType.getEntityType("iron_golem", 99);
    public static final Typed<Horse> HORSE = (Typed)EntityType.getEntityType("horse", 100);
    public static final Typed<Rabbit> RABBIT = (Typed)EntityType.getEntityType("rabbit", 101);
    public static final Typed<PolarBear> POLAR_BEAR = (Typed)EntityType.getEntityType("polar_bear", 102);
    public static final Typed<Llama> LLAMA = (Typed)EntityType.getEntityType("llama", 103);
    public static final Typed<LlamaSpit> LLAMA_SPIT = (Typed)EntityType.getEntityType("llama_spit", 104);
    public static final Typed<Parrot> PARROT = (Typed)EntityType.getEntityType("parrot", 105);
    public static final Typed<Villager> VILLAGER = (Typed)EntityType.getEntityType("villager", 120);
    public static final Typed<EnderCrystal> END_CRYSTAL = (Typed)EntityType.getEntityType("end_crystal", 200);
    public static final Typed<Turtle> TURTLE = (Typed)EntityType.getEntityType("turtle");
    public static final Typed<Phantom> PHANTOM = (Typed)EntityType.getEntityType("phantom");
    public static final Typed<Trident> TRIDENT = (Typed)EntityType.getEntityType("trident");
    public static final Typed<Cod> COD = (Typed)EntityType.getEntityType("cod");
    public static final Typed<Salmon> SALMON = (Typed)EntityType.getEntityType("salmon");
    public static final Typed<PufferFish> PUFFERFISH = (Typed)EntityType.getEntityType("pufferfish");
    public static final Typed<TropicalFish> TROPICAL_FISH = (Typed)EntityType.getEntityType("tropical_fish");
    public static final Typed<Drowned> DROWNED = (Typed)EntityType.getEntityType("drowned");
    public static final Typed<Dolphin> DOLPHIN = (Typed)EntityType.getEntityType("dolphin");
    public static final Typed<Cat> CAT = (Typed)EntityType.getEntityType("cat");
    public static final Typed<Panda> PANDA = (Typed)EntityType.getEntityType("panda");
    public static final Typed<Pillager> PILLAGER = (Typed)EntityType.getEntityType("pillager");
    public static final Typed<Ravager> RAVAGER = (Typed)EntityType.getEntityType("ravager");
    public static final Typed<TraderLlama> TRADER_LLAMA = (Typed)EntityType.getEntityType("trader_llama");
    public static final Typed<WanderingTrader> WANDERING_TRADER = (Typed)EntityType.getEntityType("wandering_trader");
    public static final Typed<Fox> FOX = (Typed)EntityType.getEntityType("fox");
    public static final Typed<Bee> BEE = (Typed)EntityType.getEntityType("bee");
    public static final Typed<Hoglin> HOGLIN = (Typed)EntityType.getEntityType("hoglin");
    public static final Typed<Piglin> PIGLIN = (Typed)EntityType.getEntityType("piglin");
    public static final Typed<Strider> STRIDER = (Typed)EntityType.getEntityType("strider");
    public static final Typed<Zoglin> ZOGLIN = (Typed)EntityType.getEntityType("zoglin");
    public static final Typed<PiglinBrute> PIGLIN_BRUTE = (Typed)EntityType.getEntityType("piglin_brute");
    public static final Typed<Axolotl> AXOLOTL = (Typed)EntityType.getEntityType("axolotl");
    public static final Typed<GlowItemFrame> GLOW_ITEM_FRAME = (Typed)EntityType.getEntityType("glow_item_frame");
    public static final Typed<GlowSquid> GLOW_SQUID = (Typed)EntityType.getEntityType("glow_squid");
    public static final Typed<Goat> GOAT = (Typed)EntityType.getEntityType("goat");
    public static final Typed<Marker> MARKER = (Typed)EntityType.getEntityType("marker");
    public static final Typed<Allay> ALLAY = (Typed)EntityType.getEntityType("allay");
    public static final Typed<ChestBoat> CHEST_BOAT = (Typed)EntityType.getEntityType("chest_boat");
    public static final Typed<Frog> FROG = (Typed)EntityType.getEntityType("frog");
    public static final Typed<Tadpole> TADPOLE = (Typed)EntityType.getEntityType("tadpole");
    public static final Typed<Warden> WARDEN = (Typed)EntityType.getEntityType("warden");
    public static final Typed<Camel> CAMEL = (Typed)EntityType.getEntityType("camel");
    public static final Typed<BlockDisplay> BLOCK_DISPLAY = (Typed)EntityType.getEntityType("block_display");
    public static final Typed<Interaction> INTERACTION = (Typed)EntityType.getEntityType("interaction");
    public static final Typed<ItemDisplay> ITEM_DISPLAY = (Typed)EntityType.getEntityType("item_display");
    public static final Typed<Sniffer> SNIFFER = (Typed)EntityType.getEntityType("sniffer");
    public static final Typed<TextDisplay> TEXT_DISPLAY = (Typed)EntityType.getEntityType("text_display");
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    @ApiStatus.Experimental
    public static final Typed<Breeze> BREEZE = (Typed)EntityType.getEntityType("breeze");
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    @ApiStatus.Experimental
    public static final Typed<WindCharge> WIND_CHARGE = (Typed)EntityType.getEntityType("wind_charge");
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    @ApiStatus.Experimental
    public static final Typed<BreezeWindCharge> BREEZE_WIND_CHARGE = (Typed)EntityType.getEntityType("breeze_wind_charge");
    public static final Typed<Armadillo> ARMADILLO = (Typed)EntityType.getEntityType("armadillo");
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    @ApiStatus.Experimental
    public static final Typed<Bogged> BOGGED = (Typed)EntityType.getEntityType("bogged");
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    @ApiStatus.Experimental
    public static final Typed<OminousItemSpawner> OMINOUS_ITEM_SPAWNER = (Typed)EntityType.getEntityType("ominous_item_spawner");
    public static final Typed<FishHook> FISHING_BOBBER = (Typed)EntityType.getEntityType("fishing_bobber");
    public static final Typed<LightningStrike> LIGHTNING_BOLT = (Typed)EntityType.getEntityType("lightning_bolt");
    public static final Typed<Player> PLAYER = (Typed)EntityType.getEntityType("player");
    @Deprecated
    public static final EntityType UNKNOWN = Bukkit.getUnsafe().getUnkownEntityType();

    @NotNull
    private static <E extends EntityType> E getEntityType(@NotNull String key) {
        return EntityType.getEntityType(key, -1);
    }

    @NotNull
    private static <E extends EntityType> E getEntityType(@NotNull String key, int typeId) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        EntityType entityType = Registry.ENTITY_TYPE.get(namespacedKey);
        Preconditions.checkNotNull((Object)entityType, (String)"No EntityType found for %s. This is a bug.", (Object)namespacedKey);
        if (typeId > 0) {
            ID_MAP.put((Object)((short)typeId), (Object)entityType);
        }
        return (E)entityType;
    }

    @NotNull
    public abstract <E extends Entity> Typed<E> typed(@NotNull Class<E> var1);

    public abstract boolean isTyped();

    public abstract boolean isSpawnable();

    public abstract boolean isAlive();

    @Nullable
    public abstract Class<? extends Entity> getEntityClass();

    public abstract boolean isEnabledByFeature(@NotNull World var1);

    @Deprecated
    @Nullable
    public abstract String getName();

    @Deprecated
    public short getTypeId() {
        return (Short)ID_MAP.inverse().getOrDefault((Object)this, (Object)-1);
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static EntityType fromName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return Registry.ENTITY_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
    }

    @Deprecated
    @Nullable
    public static EntityType fromId(int id) {
        if (id > Short.MAX_VALUE) {
            return null;
        }
        return (EntityType)ID_MAP.get((Object)((short)id));
    }

    @Deprecated
    @NotNull
    public static EntityType valueOf(@NotNull String name) {
        EntityType entityType = Registry.ENTITY_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (String)"No EntityType found with the name %s", (Object)name);
        return entityType;
    }

    @Deprecated
    @NotNull
    public static EntityType[] values() {
        return Lists.newArrayList(Registry.ENTITY_TYPE).toArray(new EntityType[0]);
    }

    public static abstract class Typed<E extends Entity>
    extends EntityType {
        @NotNull
        public abstract Class<E> getEntityClass();
    }
}

