/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public interface Cat
extends Tameable,
Sittable {
    @NotNull
    public Type getCatType();

    public void setCatType(@NotNull Type var1);

    @NotNull
    public DyeColor getCollarColor();

    public void setCollarColor(@NotNull DyeColor var1);

    public static abstract class Type
    implements OldEnum<Type>,
    Keyed {
        public static final Type TABBY = Type.getType("tabby");
        public static final Type BLACK = Type.getType("black");
        public static final Type RED = Type.getType("red");
        public static final Type SIAMESE = Type.getType("siamese");
        public static final Type BRITISH_SHORTHAIR = Type.getType("british_shorthair");
        public static final Type CALICO = Type.getType("calico");
        public static final Type PERSIAN = Type.getType("persian");
        public static final Type RAGDOLL = Type.getType("ragdoll");
        public static final Type WHITE = Type.getType("white");
        public static final Type JELLIE = Type.getType("jellie");
        public static final Type ALL_BLACK = Type.getType("all_black");

        @NotNull
        private static Type getType(@NotNull String key) {
            NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
            Type type = Registry.CAT_VARIANT.get(namespacedKey);
            Preconditions.checkNotNull((Object)type, (String)"No cat type found for %s. This is a bug.", (Object)namespacedKey);
            return type;
        }

        @Deprecated
        @NotNull
        public static Type valueOf(@NotNull String name) {
            Type type = Registry.CAT_VARIANT.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No cat type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated
        @NotNull
        public static Type[] values() {
            return Lists.newArrayList(Registry.CAT_VARIANT).toArray(new Type[0]);
        }
    }
}

