/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Particle
extends OldEnum<Particle>,
Keyed {
    public static final Particle POOF = Particle.getParticle("poof");
    public static final Particle EXPLOSION = Particle.getParticle("explosion");
    public static final Particle EXPLOSION_EMITTER = Particle.getParticle("explosion_emitter");
    public static final Particle FIREWORK = Particle.getParticle("firework");
    public static final Particle BUBBLE = Particle.getParticle("bubble");
    public static final Particle SPLASH = Particle.getParticle("splash");
    public static final Particle FISHING = Particle.getParticle("fishing");
    public static final Particle UNDERWATER = Particle.getParticle("underwater");
    public static final Particle CRIT = Particle.getParticle("crit");
    public static final Particle ENCHANTED_HIT = Particle.getParticle("enchanted_hit");
    public static final Particle SMOKE = Particle.getParticle("smoke");
    public static final Particle LARGE_SMOKE = Particle.getParticle("large_smoke");
    public static final Particle EFFECT = Particle.getParticle("effect");
    public static final Particle INSTANT_EFFECT = Particle.getParticle("instant_effect");
    public static final Typed<Color> ENTITY_EFFECT = (Typed)Particle.getParticle("entity_effect");
    public static final Particle WITCH = Particle.getParticle("witch");
    public static final Particle DRIPPING_WATER = Particle.getParticle("dripping_water");
    public static final Particle DRIPPING_LAVA = Particle.getParticle("dripping_lava");
    public static final Particle ANGRY_VILLAGER = Particle.getParticle("angry_villager");
    public static final Particle HAPPY_VILLAGER = Particle.getParticle("happy_villager");
    public static final Particle MYCELIUM = Particle.getParticle("mycelium");
    public static final Particle NOTE = Particle.getParticle("note");
    public static final Particle PORTAL = Particle.getParticle("portal");
    public static final Particle ENCHANT = Particle.getParticle("enchant");
    public static final Particle FLAME = Particle.getParticle("flame");
    public static final Particle LAVA = Particle.getParticle("lava");
    public static final Particle CLOUD = Particle.getParticle("cloud");
    public static final Typed<DustOptions> DUST = (Typed)Particle.getParticle("dust");
    public static final Particle ITEM_SNOWBALL = Particle.getParticle("item_snowball");
    public static final Particle ITEM_SLIME = Particle.getParticle("item_slime");
    public static final Particle HEART = Particle.getParticle("heart");
    public static final Typed<ItemStack> ITEM = (Typed)Particle.getParticle("item");
    public static final Typed<BlockData> BLOCK = (Typed)Particle.getParticle("block");
    public static final Particle RAIN = Particle.getParticle("rain");
    public static final Particle ELDER_GUARDIAN = Particle.getParticle("elder_guardian");
    public static final Particle DRAGON_BREATH = Particle.getParticle("dragon_breath");
    public static final Particle END_ROD = Particle.getParticle("end_rod");
    public static final Particle DAMAGE_INDICATOR = Particle.getParticle("damage_indicator");
    public static final Particle SWEEP_ATTACK = Particle.getParticle("sweep_attack");
    public static final Typed<BlockData> FALLING_DUST = (Typed)Particle.getParticle("falling_dust");
    public static final Particle TOTEM_OF_UNDYING = Particle.getParticle("totem_of_undying");
    public static final Particle SPIT = Particle.getParticle("spit");
    public static final Particle SQUID_INK = Particle.getParticle("squid_ink");
    public static final Particle BUBBLE_POP = Particle.getParticle("bubble_pop");
    public static final Particle CURRENT_DOWN = Particle.getParticle("current_down");
    public static final Particle BUBBLE_COLUMN_UP = Particle.getParticle("bubble_column_up");
    public static final Particle NAUTILUS = Particle.getParticle("nautilus");
    public static final Particle DOLPHIN = Particle.getParticle("dolphin");
    public static final Particle SNEEZE = Particle.getParticle("sneeze");
    public static final Particle CAMPFIRE_COSY_SMOKE = Particle.getParticle("campfire_cosy_smoke");
    public static final Particle CAMPFIRE_SIGNAL_SMOKE = Particle.getParticle("campfire_signal_smoke");
    public static final Particle COMPOSTER = Particle.getParticle("composter");
    public static final Particle FLASH = Particle.getParticle("flash");
    public static final Particle FALLING_LAVA = Particle.getParticle("falling_lava");
    public static final Particle LANDING_LAVA = Particle.getParticle("landing_lava");
    public static final Particle FALLING_WATER = Particle.getParticle("falling_water");
    public static final Particle DRIPPING_HONEY = Particle.getParticle("dripping_honey");
    public static final Particle FALLING_HONEY = Particle.getParticle("falling_honey");
    public static final Particle LANDING_HONEY = Particle.getParticle("landing_honey");
    public static final Particle FALLING_NECTAR = Particle.getParticle("falling_nectar");
    public static final Particle SOUL_FIRE_FLAME = Particle.getParticle("soul_fire_flame");
    public static final Particle ASH = Particle.getParticle("ash");
    public static final Particle CRIMSON_SPORE = Particle.getParticle("crimson_spore");
    public static final Particle WARPED_SPORE = Particle.getParticle("warped_spore");
    public static final Particle SOUL = Particle.getParticle("soul");
    public static final Particle DRIPPING_OBSIDIAN_TEAR = Particle.getParticle("dripping_obsidian_tear");
    public static final Particle FALLING_OBSIDIAN_TEAR = Particle.getParticle("falling_obsidian_tear");
    public static final Particle LANDING_OBSIDIAN_TEAR = Particle.getParticle("landing_obsidian_tear");
    public static final Particle REVERSE_PORTAL = Particle.getParticle("reverse_portal");
    public static final Particle WHITE_ASH = Particle.getParticle("white_ash");
    public static final Typed<DustTransition> DUST_COLOR_TRANSITION = (Typed)Particle.getParticle("dust_color_transition");
    public static final Typed<Vibration> VIBRATION = (Typed)Particle.getParticle("vibration");
    public static final Particle FALLING_SPORE_BLOSSOM = Particle.getParticle("falling_spore_blossom");
    public static final Particle SPORE_BLOSSOM_AIR = Particle.getParticle("spore_blossom_air");
    public static final Particle SMALL_FLAME = Particle.getParticle("small_flame");
    public static final Particle SNOWFLAKE = Particle.getParticle("snowflake");
    public static final Particle DRIPPING_DRIPSTONE_LAVA = Particle.getParticle("dripping_dripstone_lava");
    public static final Particle FALLING_DRIPSTONE_LAVA = Particle.getParticle("falling_dripstone_lava");
    public static final Particle DRIPPING_DRIPSTONE_WATER = Particle.getParticle("dripping_dripstone_water");
    public static final Particle FALLING_DRIPSTONE_WATER = Particle.getParticle("falling_dripstone_water");
    public static final Particle GLOW_SQUID_INK = Particle.getParticle("glow_squid_ink");
    public static final Particle GLOW = Particle.getParticle("glow");
    public static final Particle WAX_ON = Particle.getParticle("wax_on");
    public static final Particle WAX_OFF = Particle.getParticle("wax_off");
    public static final Particle ELECTRIC_SPARK = Particle.getParticle("electric_spark");
    public static final Particle SCRAPE = Particle.getParticle("scrape");
    public static final Particle SONIC_BOOM = Particle.getParticle("sonic_boom");
    public static final Particle SCULK_SOUL = Particle.getParticle("sculk_soul");
    public static final Typed<Float> SCULK_CHARGE = (Typed)Particle.getParticle("sculk_charge");
    public static final Particle SCULK_CHARGE_POP = Particle.getParticle("sculk_charge_pop");
    public static final Typed<Integer> SHRIEK = (Typed)Particle.getParticle("shriek");
    public static final Particle CHERRY_LEAVES = Particle.getParticle("cherry_leaves");
    public static final Particle EGG_CRACK = Particle.getParticle("egg_crack");
    public static final Particle DUST_PLUME = Particle.getParticle("dust_plume");
    public static final Particle WHITE_SMOKE = Particle.getParticle("white_smoke");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle GUST = Particle.getParticle("gust");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle SMALL_GUST = Particle.getParticle("small_gust");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle GUST_EMITTER_LARGE = Particle.getParticle("gust_emitter_large");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle GUST_EMITTER_SMALL = Particle.getParticle("gust_emitter_small");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle TRIAL_SPAWNER_DETECTION = Particle.getParticle("trial_spawner_detection");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle TRIAL_SPAWNER_DETECTION_OMINOUS = Particle.getParticle("trial_spawner_detection_ominous");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle VAULT_CONNECTION = Particle.getParticle("vault_connection");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle INFESTED = Particle.getParticle("infested");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle ITEM_COBWEB = Particle.getParticle("item_cobweb");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Typed<BlockData> DUST_PILLAR = (Typed)Particle.getParticle("dust_pillar");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle OMINOUS_SPAWNING = Particle.getParticle("ominous_spawning");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle RAID_OMEN = Particle.getParticle("raid_omen");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.UPDATE_1_21)
    public static final Particle TRIAL_OMEN = Particle.getParticle("trial_omen");
    public static final Typed<BlockData> BLOCK_MARKER = (Typed)Particle.getParticle("block_marker");

    @NotNull
    private static <P extends Particle> P getParticle(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Particle particle = Registry.PARTICLE_TYPE.get(namespacedKey);
        Preconditions.checkNotNull((Object)particle, (String)"No particle found for %s. This is a bug.", (Object)namespacedKey);
        return (P)particle;
    }

    @NotNull
    public <D> Typed<D> typed(@NotNull Class<D> var1);

    public boolean isTyped();

    @NotNull
    public Class<?> getDataType();

    @Deprecated
    @NotNull
    public static Particle valueOf(@NotNull String name) {
        Particle particle = Registry.PARTICLE_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (String)"No particle found with the name %s", (Object)name);
        return particle;
    }

    @Deprecated
    @NotNull
    public static Particle[] values() {
        return Lists.newArrayList(Registry.PARTICLE_TYPE).toArray(new Particle[0]);
    }

    public static interface Typed<D>
    extends Particle {
        @NotNull
        public Class<D> getDataType();
    }

    public static class DustTransition
    extends DustOptions {
        private final Color toColor;

        public DustTransition(@NotNull Color fromColor, @NotNull Color toColor, float size) {
            super(fromColor, size);
            Preconditions.checkArgument((toColor != null ? 1 : 0) != 0, (Object)"toColor");
            this.toColor = toColor;
        }

        @NotNull
        public Color getToColor() {
            return this.toColor;
        }
    }

    public static class DustOptions {
        private final Color color;
        private final float size;

        public DustOptions(@NotNull Color color, float size) {
            Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
            this.color = color;
            this.size = size;
        }

        @NotNull
        public Color getColor() {
            return this.color;
        }

        public float getSize() {
            return this.size;
        }
    }
}

