/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public abstract class Fluid
implements OldEnum<Fluid>,
Keyed {
    public static final Fluid EMPTY = Fluid.getFluid("empty");
    public static final Fluid WATER = Fluid.getFluid("water");
    public static final Fluid FLOWING_WATER = Fluid.getFluid("flowing_water");
    public static final Fluid LAVA = Fluid.getFluid("lava");
    public static final Fluid FLOWING_LAVA = Fluid.getFluid("flowing_lava");

    @NotNull
    private static Fluid getFluid(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Fluid fluid = Registry.FLUID.get(namespacedKey);
        Preconditions.checkNotNull((Object)fluid, (String)"No Fluid found for %s. This is a bug.", (Object)namespacedKey);
        return fluid;
    }

    @Deprecated
    @NotNull
    public static Fluid valueOf(@NotNull String name) {
        Fluid fluid = Registry.FLUID.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((fluid != null ? 1 : 0) != 0, (String)"No Fluid found with the name %s", (Object)name);
        return fluid;
    }

    @Deprecated
    @NotNull
    public static Fluid[] values() {
        return Lists.newArrayList(Registry.FLUID).toArray(new Fluid[0]);
    }
}

