/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Art
implements OldEnum<Art>,
Keyed {
    @Deprecated
    private static final Map<Integer, Art> BY_ID = Maps.newHashMap();
    public static final Art KEBAB = Art.getArt("kebab");
    public static final Art AZTEC = Art.getArt("aztec");
    public static final Art ALBAN = Art.getArt("alban");
    public static final Art AZTEC2 = Art.getArt("aztec2");
    public static final Art BOMB = Art.getArt("bomb");
    public static final Art PLANT = Art.getArt("plant");
    public static final Art WASTELAND = Art.getArt("wasteland");
    public static final Art POOL = Art.getArt("pool");
    public static final Art COURBET = Art.getArt("courbet");
    public static final Art SEA = Art.getArt("sea");
    public static final Art SUNSET = Art.getArt("sunset");
    public static final Art CREEBET = Art.getArt("creebet");
    public static final Art WANDERER = Art.getArt("wanderer");
    public static final Art GRAHAM = Art.getArt("graham");
    public static final Art MATCH = Art.getArt("match");
    public static final Art BUST = Art.getArt("bust");
    public static final Art STAGE = Art.getArt("stage");
    public static final Art VOID = Art.getArt("void");
    public static final Art SKULL_AND_ROSES = Art.getArt("skull_and_roses");
    public static final Art WITHER = Art.getArt("wither");
    public static final Art FIGHTERS = Art.getArt("fighters");
    public static final Art POINTER = Art.getArt("pointer");
    public static final Art PIGSCENE = Art.getArt("pigscene");
    public static final Art BURNING_SKULL = Art.getArt("burning_skull");
    public static final Art SKELETON = Art.getArt("skeleton");
    public static final Art DONKEY_KONG = Art.getArt("donkey_kong");
    public static final Art EARTH = Art.getArt("earth");
    public static final Art WIND = Art.getArt("wind");
    public static final Art WATER = Art.getArt("water");
    public static final Art FIRE = Art.getArt("fire");

    @NotNull
    private static Art getArt(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Art art = Registry.ART.get(namespacedKey);
        Preconditions.checkNotNull((Object)art, (String)"No Art found for %s. This is a bug.", (Object)namespacedKey);
        BY_ID.put(art.ordinal(), art);
        return art;
    }

    @Deprecated
    @Nullable
    public static Art getByName(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null");
        return Registry.ART.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
    }

    public abstract int getBlockWidth();

    public abstract int getBlockHeight();

    @Deprecated
    public abstract int getId();

    @Deprecated
    @Nullable
    public static Art getById(int id) {
        Art art = BY_ID.get(id);
        if (art != null) {
            return art;
        }
        for (Art other : Registry.ART) {
            if (other.getId() != id) continue;
            BY_ID.put(id, other);
            return other;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static Art valueOf(@NotNull String name) {
        Art art = Registry.ART.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((art != null ? 1 : 0) != 0, (String)"No Art found with the name %s", (Object)name);
        return art;
    }

    @Deprecated
    @NotNull
    public static Art[] values() {
        return Lists.newArrayList(Registry.ART).toArray(new Art[0]);
    }
}

