/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Frog
extends Animals {
    @Nullable
    public Entity getTongueTarget();

    public void setTongueTarget(@Nullable Entity var1);

    @NotNull
    public Variant getVariant();

    public void setVariant(@NotNull Variant var1);

    public static abstract class Variant
    extends OldEnum<Variant>
    implements Keyed {
        public static final Variant TEMPERATE = Variant.getVariant("temperate");
        public static final Variant WARM = Variant.getVariant("warm");
        public static final Variant COLD = Variant.getVariant("cold");

        @NotNull
        private static Variant getVariant(@NotNull String key) {
            NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
            Variant variant = Registry.FROG_VARIANT.get(namespacedKey);
            Preconditions.checkNotNull((Object)variant, (String)"No frog variant found for %s. This is a bug.", (Object)namespacedKey);
            return variant;
        }

        @Deprecated
        @NotNull
        public static Variant valueOf(@NotNull String name) {
            Variant variant = Registry.FROG_VARIANT.get(NamespacedKey.fromString(name.toLowerCase()));
            Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (String)"No frog variant found with the name %s", (Object)name);
            return variant;
        }

        @Deprecated
        @NotNull
        public static Variant[] values() {
            return Lists.newArrayList(Registry.FROG_VARIANT).toArray(new Variant[0]);
        }
    }
}

