/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.banner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternType
extends OldEnum<PatternType>
implements Keyed {
    public static final PatternType BASE = PatternType.getPatternType("base");
    public static final PatternType SQUARE_BOTTOM_LEFT = PatternType.getPatternType("square_bottom_left");
    public static final PatternType SQUARE_BOTTOM_RIGHT = PatternType.getPatternType("square_bottom_right");
    public static final PatternType SQUARE_TOP_LEFT = PatternType.getPatternType("square_top_left");
    public static final PatternType SQUARE_TOP_RIGHT = PatternType.getPatternType("square_top_right");
    public static final PatternType STRIPE_BOTTOM = PatternType.getPatternType("stripe_bottom");
    public static final PatternType STRIPE_TOP = PatternType.getPatternType("stripe_top");
    public static final PatternType STRIPE_LEFT = PatternType.getPatternType("stripe_left");
    public static final PatternType STRIPE_RIGHT = PatternType.getPatternType("stripe_right");
    public static final PatternType STRIPE_CENTER = PatternType.getPatternType("stripe_center");
    public static final PatternType STRIPE_MIDDLE = PatternType.getPatternType("stripe_middle");
    public static final PatternType STRIPE_DOWNRIGHT = PatternType.getPatternType("stripe_downright");
    public static final PatternType STRIPE_DOWNLEFT = PatternType.getPatternType("stripe_downleft");
    public static final PatternType SMALL_STRIPES = PatternType.getPatternType("small_stripes");
    public static final PatternType CROSS = PatternType.getPatternType("cross");
    public static final PatternType STRAIGHT_CROSS = PatternType.getPatternType("straight_cross");
    public static final PatternType TRIANGLE_BOTTOM = PatternType.getPatternType("triangle_bottom");
    public static final PatternType TRIANGLE_TOP = PatternType.getPatternType("triangle_top");
    public static final PatternType TRIANGLES_BOTTOM = PatternType.getPatternType("triangles_bottom");
    public static final PatternType TRIANGLES_TOP = PatternType.getPatternType("triangles_top");
    public static final PatternType DIAGONAL_LEFT = PatternType.getPatternType("diagonal_left");
    public static final PatternType DIAGONAL_UP_RIGHT = PatternType.getPatternType("diagonal_up_right");
    public static final PatternType DIAGONAL_UP_LEFT = PatternType.getPatternType("diagonal_up_left");
    public static final PatternType DIAGONAL_RIGHT = PatternType.getPatternType("diagonal_right");
    public static final PatternType CIRCLE = PatternType.getPatternType("circle");
    public static final PatternType RHOMBUS = PatternType.getPatternType("rhombus");
    public static final PatternType HALF_VERTICAL = PatternType.getPatternType("half_vertical");
    public static final PatternType HALF_HORIZONTAL = PatternType.getPatternType("half_horizontal");
    public static final PatternType HALF_VERTICAL_RIGHT = PatternType.getPatternType("half_vertical_right");
    public static final PatternType HALF_HORIZONTAL_BOTTOM = PatternType.getPatternType("half_horizontal_bottom");
    public static final PatternType BORDER = PatternType.getPatternType("border");
    public static final PatternType CURLY_BORDER = PatternType.getPatternType("curly_border");
    public static final PatternType CREEPER = PatternType.getPatternType("creeper");
    public static final PatternType GRADIENT = PatternType.getPatternType("gradient");
    public static final PatternType GRADIENT_UP = PatternType.getPatternType("gradient_up");
    public static final PatternType BRICKS = PatternType.getPatternType("bricks");
    public static final PatternType SKULL = PatternType.getPatternType("skull");
    public static final PatternType FLOWER = PatternType.getPatternType("flower");
    public static final PatternType MOJANG = PatternType.getPatternType("mojang");
    public static final PatternType GLOBE = PatternType.getPatternType("globe");
    public static final PatternType PIGLIN = PatternType.getPatternType("piglin");
    private static final Map<String, PatternType> byString = new HashMap<String, PatternType>();

    @NotNull
    private static PatternType getPatternType(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        PatternType patternType = Registry.BANNER_PATTERN.get(namespacedKey);
        Preconditions.checkNotNull((Object)patternType, (String)"No pattern type found for %s. This is a bug.", (Object)namespacedKey);
        return patternType;
    }

    @Deprecated
    @NotNull
    public abstract String getIdentifier();

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PatternType getByIdentifier(@Nullable String identifier) {
        if (identifier == null) {
            return null;
        }
        PatternType patternType = byString.get(identifier);
        if (patternType != null) {
            return patternType;
        }
        for (PatternType type : Registry.BANNER_PATTERN) {
            if (!identifier.equals(type.getIdentifier())) continue;
            byString.put(identifier, type);
            return type;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static PatternType[] values() {
        return Lists.newArrayList(Registry.BANNER_PATTERN).toArray(new PatternType[0]);
    }
}

