/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public abstract class Attribute
extends OldEnum<Attribute>
implements Keyed {
    public static final Attribute GENERIC_MAX_HEALTH = Attribute.getAttribute("generic.max_health");
    public static final Attribute GENERIC_FOLLOW_RANGE = Attribute.getAttribute("generic.follow_range");
    public static final Attribute GENERIC_KNOCKBACK_RESISTANCE = Attribute.getAttribute("generic.knockback_resistance");
    public static final Attribute GENERIC_MOVEMENT_SPEED = Attribute.getAttribute("generic.movement_speed");
    public static final Attribute GENERIC_FLYING_SPEED = Attribute.getAttribute("generic.flying_speed");
    public static final Attribute GENERIC_ATTACK_DAMAGE = Attribute.getAttribute("generic.attack_damage");
    public static final Attribute GENERIC_ATTACK_KNOCKBACK = Attribute.getAttribute("generic.attack_knockback");
    public static final Attribute GENERIC_ATTACK_SPEED = Attribute.getAttribute("generic.attack_speed");
    public static final Attribute GENERIC_ARMOR = Attribute.getAttribute("generic.armor");
    public static final Attribute GENERIC_ARMOR_TOUGHNESS = Attribute.getAttribute("generic.armor_toughness");
    public static final Attribute GENERIC_LUCK = Attribute.getAttribute("generic.luck");
    public static final Attribute GENERIC_MAX_ABSORPTION = Attribute.getAttribute("generic.max_absorption");
    public static final Attribute HORSE_JUMP_STRENGTH = Attribute.getAttribute("horse.jump_strength");
    public static final Attribute ZOMBIE_SPAWN_REINFORCEMENTS = Attribute.getAttribute("zombie.spawn_reinforcements");

    @NotNull
    private static Attribute getAttribute(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Attribute attribute = Registry.ATTRIBUTE.get(namespacedKey);
        Preconditions.checkNotNull((Object)attribute, (String)"No Attribute found for %s. This is a bug.", (Object)namespacedKey);
        return attribute;
    }

    @Deprecated
    @NotNull
    public static Attribute valueOf(@NotNull String name) {
        Attribute attribute = Registry.ATTRIBUTE.get(NamespacedKey.fromString(name.toLowerCase()));
        if (attribute != null) {
            return attribute;
        }
        try {
            attribute = (Attribute)Attribute.class.getField(name).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            attribute = null;
        }
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (String)"No Attribute found with the name %s", (Object)name);
        return attribute;
    }

    @Deprecated
    @NotNull
    public static Attribute[] values() {
        return Lists.newArrayList(Registry.ATTRIBUTE).toArray(new Attribute[0]);
    }
}

