/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public abstract class Statistic
extends OldEnum<Statistic>
implements Keyed {
    public static final Statistic DAMAGE_DEALT = Statistic.getStatistic("damage_dealt");
    public static final Statistic DAMAGE_TAKEN = Statistic.getStatistic("damage_taken");
    public static final Statistic DEATHS = Statistic.getStatistic("deaths");
    public static final Statistic MOB_KILLS = Statistic.getStatistic("mob_kills");
    public static final Statistic PLAYER_KILLS = Statistic.getStatistic("player_kills");
    public static final Statistic FISH_CAUGHT = Statistic.getStatistic("fish_caught");
    public static final Statistic ANIMALS_BRED = Statistic.getStatistic("animals_bred");
    public static final Statistic LEAVE_GAME = Statistic.getStatistic("leave_game");
    public static final Statistic JUMP = Statistic.getStatistic("jump");
    public static final Statistic DROP_COUNT = Statistic.getStatistic("drop_count");
    public static final Statistic DROP = Statistic.getStatistic("drop");
    public static final Statistic PICKUP = Statistic.getStatistic("pickup");
    public static final Statistic PLAY_ONE_MINUTE = Statistic.getStatistic("play_one_minute");
    public static final Statistic TOTAL_WORLD_TIME = Statistic.getStatistic("total_world_time");
    public static final Statistic WALK_ONE_CM = Statistic.getStatistic("walk_one_cm");
    public static final Statistic WALK_ON_WATER_ONE_CM = Statistic.getStatistic("walk_on_water_one_cm");
    public static final Statistic FALL_ONE_CM = Statistic.getStatistic("fall_one_cm");
    public static final Statistic SNEAK_TIME = Statistic.getStatistic("sneak_time");
    public static final Statistic CLIMB_ONE_CM = Statistic.getStatistic("climb_one_cm");
    public static final Statistic FLY_ONE_CM = Statistic.getStatistic("fly_one_cm");
    public static final Statistic WALK_UNDER_WATER_ONE_CM = Statistic.getStatistic("walk_under_water_one_cm");
    public static final Statistic MINECART_ONE_CM = Statistic.getStatistic("minecart_one_cm");
    public static final Statistic BOAT_ONE_CM = Statistic.getStatistic("boat_one_cm");
    public static final Statistic PIG_ONE_CM = Statistic.getStatistic("pig_one_cm");
    public static final Statistic HORSE_ONE_CM = Statistic.getStatistic("horse_one_cm");
    public static final Statistic SPRINT_ONE_CM = Statistic.getStatistic("sprint_one_cm");
    public static final Statistic CROUCH_ONE_CM = Statistic.getStatistic("crouch_one_cm");
    public static final Statistic AVIATE_ONE_CM = Statistic.getStatistic("aviate_one_cm");
    public static final Statistic MINE_BLOCK = Statistic.getStatistic("mine_block");
    public static final Statistic USE_ITEM = Statistic.getStatistic("use_item");
    public static final Statistic BREAK_ITEM = Statistic.getStatistic("break_item");
    public static final Statistic CRAFT_ITEM = Statistic.getStatistic("craft_item");
    public static final Statistic KILL_ENTITY = Statistic.getStatistic("kill_entity");
    public static final Statistic ENTITY_KILLED_BY = Statistic.getStatistic("entity_killed_by");
    public static final Statistic TIME_SINCE_DEATH = Statistic.getStatistic("time_since_death");
    public static final Statistic TALKED_TO_VILLAGER = Statistic.getStatistic("talked_to_villager");
    public static final Statistic TRADED_WITH_VILLAGER = Statistic.getStatistic("traded_with_villager");
    public static final Statistic CAKE_SLICES_EATEN = Statistic.getStatistic("cake_slices_eaten");
    public static final Statistic CAULDRON_FILLED = Statistic.getStatistic("cauldron_filled");
    public static final Statistic CAULDRON_USED = Statistic.getStatistic("cauldron_used");
    public static final Statistic ARMOR_CLEANED = Statistic.getStatistic("armor_cleaned");
    public static final Statistic BANNER_CLEANED = Statistic.getStatistic("banner_cleaned");
    public static final Statistic BREWINGSTAND_INTERACTION = Statistic.getStatistic("brewingstand_interaction");
    public static final Statistic BEACON_INTERACTION = Statistic.getStatistic("beacon_interaction");
    public static final Statistic DROPPER_INSPECTED = Statistic.getStatistic("dropper_inspected");
    public static final Statistic HOPPER_INSPECTED = Statistic.getStatistic("hopper_inspected");
    public static final Statistic DISPENSER_INSPECTED = Statistic.getStatistic("dispenser_inspected");
    public static final Statistic NOTEBLOCK_PLAYED = Statistic.getStatistic("noteblock_played");
    public static final Statistic NOTEBLOCK_TUNED = Statistic.getStatistic("noteblock_tuned");
    public static final Statistic FLOWER_POTTED = Statistic.getStatistic("flower_potted");
    public static final Statistic TRAPPED_CHEST_TRIGGERED = Statistic.getStatistic("trapped_chest_triggered");
    public static final Statistic ENDERCHEST_OPENED = Statistic.getStatistic("enderchest_opened");
    public static final Statistic ITEM_ENCHANTED = Statistic.getStatistic("item_enchanted");
    public static final Statistic RECORD_PLAYED = Statistic.getStatistic("record_played");
    public static final Statistic FURNACE_INTERACTION = Statistic.getStatistic("furnace_interaction");
    public static final Statistic CRAFTING_TABLE_INTERACTION = Statistic.getStatistic("crafting_table_interaction");
    public static final Statistic CHEST_OPENED = Statistic.getStatistic("chest_opened");
    public static final Statistic SLEEP_IN_BED = Statistic.getStatistic("sleep_in_bed");
    public static final Statistic SHULKER_BOX_OPENED = Statistic.getStatistic("shulker_box_opened");
    public static final Statistic TIME_SINCE_REST = Statistic.getStatistic("time_since_rest");
    public static final Statistic SWIM_ONE_CM = Statistic.getStatistic("swim_one_cm");
    public static final Statistic DAMAGE_DEALT_ABSORBED = Statistic.getStatistic("damage_dealt_absorbed");
    public static final Statistic DAMAGE_DEALT_RESISTED = Statistic.getStatistic("damage_dealt_resisted");
    public static final Statistic DAMAGE_BLOCKED_BY_SHIELD = Statistic.getStatistic("damage_blocked_by_shield");
    public static final Statistic DAMAGE_ABSORBED = Statistic.getStatistic("damage_absorbed");
    public static final Statistic DAMAGE_RESISTED = Statistic.getStatistic("damage_resisted");
    public static final Statistic CLEAN_SHULKER_BOX = Statistic.getStatistic("clean_shulker_box");
    public static final Statistic OPEN_BARREL = Statistic.getStatistic("open_barrel");
    public static final Statistic INTERACT_WITH_BLAST_FURNACE = Statistic.getStatistic("interact_with_blast_furnace");
    public static final Statistic INTERACT_WITH_SMOKER = Statistic.getStatistic("interact_with_smoker");
    public static final Statistic INTERACT_WITH_LECTERN = Statistic.getStatistic("interact_with_lectern");
    public static final Statistic INTERACT_WITH_CAMPFIRE = Statistic.getStatistic("interact_with_campfire");
    public static final Statistic INTERACT_WITH_CARTOGRAPHY_TABLE = Statistic.getStatistic("interact_with_cartography_table");
    public static final Statistic INTERACT_WITH_LOOM = Statistic.getStatistic("interact_with_loom");
    public static final Statistic INTERACT_WITH_STONECUTTER = Statistic.getStatistic("interact_with_stonecutter");
    public static final Statistic BELL_RING = Statistic.getStatistic("bell_ring");
    public static final Statistic RAID_TRIGGER = Statistic.getStatistic("raid_trigger");
    public static final Statistic RAID_WIN = Statistic.getStatistic("raid_win");
    public static final Statistic INTERACT_WITH_ANVIL = Statistic.getStatistic("interact_with_anvil");
    public static final Statistic INTERACT_WITH_GRINDSTONE = Statistic.getStatistic("interact_with_grindstone");
    public static final Statistic TARGET_HIT = Statistic.getStatistic("target_hit");
    public static final Statistic INTERACT_WITH_SMITHING_TABLE = Statistic.getStatistic("interact_with_smithing_table");
    public static final Statistic STRIDER_ONE_CM = Statistic.getStatistic("strider_one_cm");

    @NotNull
    private static Statistic getStatistic(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Statistic statistic = Registry.STATISTIC.get(namespacedKey);
        Preconditions.checkNotNull((Object)statistic, (String)"No Statistic found for %s. This is a bug.", (Object)namespacedKey);
        return statistic;
    }

    @NotNull
    public abstract Type getType();

    public abstract boolean isSubstatistic();

    public abstract boolean isBlock();

    @Deprecated
    @NotNull
    public static Statistic valueOf(@NotNull String name) {
        Statistic statistic = Registry.STATISTIC.get(NamespacedKey.fromString(name.toLowerCase()));
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (String)"No Statistic found with the name %s", (Object)name);
        return statistic;
    }

    @Deprecated
    @NotNull
    public static Statistic[] values() {
        return Lists.newArrayList(Registry.STATISTIC).toArray(new Statistic[0]);
    }

    public static enum Type {
        UNTYPED,
        ITEM,
        BLOCK,
        ENTITY;

    }
}

