/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionType
extends OldEnum<PotionType>
implements Keyed {
    public static final PotionType EMPTY = PotionType.getPotionType("empty");
    public static final PotionType WATER = PotionType.getPotionType("water");
    public static final PotionType MUNDANE = PotionType.getPotionType("mundane");
    public static final PotionType THICK = PotionType.getPotionType("thick");
    public static final PotionType AWKWARD = PotionType.getPotionType("awkward");
    public static final PotionType NIGHT_VISION = PotionType.getPotionType("night_vision");
    public static final PotionType LONG_NIGHT_VISION = PotionType.getPotionType("long_night_vision");
    public static final PotionType INVISIBILITY = PotionType.getPotionType("invisibility");
    public static final PotionType LONG_INVISIBILITY = PotionType.getPotionType("long_invisibility");
    public static final PotionType LEAPING = PotionType.getPotionType("leaping");
    public static final PotionType LONG_LEAPING = PotionType.getPotionType("long_leaping");
    public static final PotionType STRONG_LEAPING = PotionType.getPotionType("strong_leaping");
    public static final PotionType FIRE_RESISTANCE = PotionType.getPotionType("fire_resistance");
    public static final PotionType LONG_FIRE_RESISTANCE = PotionType.getPotionType("long_fire_resistance");
    public static final PotionType SWIFTNESS = PotionType.getPotionType("swiftness");
    public static final PotionType LONG_SWIFTNESS = PotionType.getPotionType("long_swiftness");
    public static final PotionType STRONG_SWIFTNESS = PotionType.getPotionType("strong_swiftness");
    public static final PotionType SLOWNESS = PotionType.getPotionType("slowness");
    public static final PotionType LONG_SLOWNESS = PotionType.getPotionType("long_slowness");
    public static final PotionType STRONG_SLOWNESS = PotionType.getPotionType("strong_slowness");
    public static final PotionType WATER_BREATHING = PotionType.getPotionType("water_breathing");
    public static final PotionType LONG_WATER_BREATHING = PotionType.getPotionType("long_water_breathing");
    public static final PotionType HEALING = PotionType.getPotionType("healing");
    public static final PotionType STRONG_HEALING = PotionType.getPotionType("strong_healing");
    public static final PotionType HARMING = PotionType.getPotionType("harming");
    public static final PotionType STRONG_HARMING = PotionType.getPotionType("strong_harming");
    public static final PotionType POISON = PotionType.getPotionType("poison");
    public static final PotionType LONG_POISON = PotionType.getPotionType("long_poison");
    public static final PotionType STRONG_POISON = PotionType.getPotionType("strong_poison");
    public static final PotionType REGENERATION = PotionType.getPotionType("regeneration");
    public static final PotionType LONG_REGENERATION = PotionType.getPotionType("long_regeneration");
    public static final PotionType STRONG_REGENERATION = PotionType.getPotionType("strong_regeneration");
    public static final PotionType STRENGTH = PotionType.getPotionType("strength");
    public static final PotionType LONG_STRENGTH = PotionType.getPotionType("long_strength");
    public static final PotionType STRONG_STRENGTH = PotionType.getPotionType("strong_strength");
    public static final PotionType WEAKNESS = PotionType.getPotionType("weakness");
    public static final PotionType LONG_WEAKNESS = PotionType.getPotionType("long_weakness");
    public static final PotionType LUCK = PotionType.getPotionType("luck");
    public static final PotionType TURTLE_MASTER = PotionType.getPotionType("turtle_master");
    public static final PotionType LONG_TURTLE_MASTER = PotionType.getPotionType("long_turtle_master");
    public static final PotionType STRONG_TURTLE_MASTER = PotionType.getPotionType("strong_turtle_master");
    public static final PotionType SLOW_FALLING = PotionType.getPotionType("slow_falling");
    public static final PotionType LONG_SLOW_FALLING = PotionType.getPotionType("long_slow_falling");

    @NotNull
    private static PotionType getPotionType(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        PotionType potionType = Registry.POTION.get(namespacedKey);
        Preconditions.checkNotNull((Object)potionType, (String)"No potion type found for %s. This is a bug.", (Object)namespacedKey);
        return potionType;
    }

    @Deprecated
    @Nullable
    public abstract PotionEffectType getEffectType();

    @NotNull
    public abstract List<PotionEffect> getPotionEffects();

    @Deprecated
    public abstract boolean isInstant();

    public abstract boolean isUpgradeable();

    public abstract boolean isExtendable();

    public abstract int getMaxLevel();

    @Deprecated
    @Nullable
    public static PotionType getByEffect(@Nullable PotionEffectType effectType) {
        if (effectType == null) {
            return WATER;
        }
        PotionType[] potionTypeArray = PotionType.values();
        int n = potionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PotionType type = potionTypeArray[n2];
            if (effectType.equals(type.getEffectType())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static PotionType valueOf(@NotNull String name) {
        PotionType potionType = Registry.POTION.get(NamespacedKey.fromString((name = PotionType.convertLegacy(name)).toLowerCase()));
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0, (String)"No potion type found with the name %s", (Object)name);
        return potionType;
    }

    @Deprecated
    @NotNull
    public static PotionType[] values() {
        return Lists.newArrayList(Registry.POTION).toArray(new PotionType[0]);
    }

    private static String convertLegacy(String from) {
        if (from == null) {
            return null;
        }
        switch (from.toLowerCase()) {
            case "uncraftable": {
                return "empty";
            }
            case "jump": {
                return "leaping";
            }
            case "speed": {
                return "swiftness";
            }
            case "instant_heal": {
                return "healing";
            }
            case "instant_damage": {
                return "harming";
            }
            case "regen": {
                return "regeneration";
            }
        }
        return from;
    }
}

