/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.World;
import org.bukkit.entity.Allay;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityType<E extends Entity>
extends OldEnum<EntityType<E>>
implements Keyed,
Translatable {
    private static final BiMap<Short, EntityType> ID_MAP = HashBiMap.create();
    public static final EntityType<Item> ITEM = EntityType.getEntityType("item", 1);
    public static final EntityType<ExperienceOrb> EXPERIENCE_ORB = EntityType.getEntityType("experience_orb", 2);
    public static final EntityType<AreaEffectCloud> AREA_EFFECT_CLOUD = EntityType.getEntityType("area_effect_cloud", 3);
    public static final EntityType<ElderGuardian> ELDER_GUARDIAN = EntityType.getEntityType("elder_guardian", 4);
    public static final EntityType<WitherSkeleton> WITHER_SKELETON = EntityType.getEntityType("wither_skeleton", 5);
    public static final EntityType<Stray> STRAY = EntityType.getEntityType("stray", 6);
    public static final EntityType<Egg> EGG = EntityType.getEntityType("egg", 7);
    public static final EntityType<LeashHitch> LEASH_KNOT = EntityType.getEntityType("leash_knot", 8);
    public static final EntityType<Painting> PAINTING = EntityType.getEntityType("painting", 9);
    public static final EntityType<Arrow> ARROW = EntityType.getEntityType("arrow", 10);
    public static final EntityType<Snowball> SNOWBALL = EntityType.getEntityType("snowball", 11);
    public static final EntityType<Fireball> FIREBALL = EntityType.getEntityType("fireball", 12);
    public static final EntityType<SmallFireball> SMALL_FIREBALL = EntityType.getEntityType("small_fireball", 13);
    public static final EntityType<EnderPearl> ENDER_PEARL = EntityType.getEntityType("ender_pearl", 14);
    public static final EntityType<EnderSignal> EYE_OF_ENDER = EntityType.getEntityType("eye_of_ender", 15);
    public static final EntityType<ThrownPotion> POTION = EntityType.getEntityType("potion", 16);
    public static final EntityType<ThrownExpBottle> EXPERIENCE_BOTTLE = EntityType.getEntityType("experience_bottle", 17);
    public static final EntityType<ItemFrame> ITEM_FRAME = EntityType.getEntityType("item_frame", 18);
    public static final EntityType<WitherSkull> WITHER_SKULL = EntityType.getEntityType("wither_skull", 19);
    public static final EntityType<TNTPrimed> TNT = EntityType.getEntityType("tnt", 20);
    public static final EntityType<FallingBlock> FALLING_BLOCK = EntityType.getEntityType("falling_block", 21);
    public static final EntityType<Firework> FIREWORK_ROCKET = EntityType.getEntityType("firework_rocket", 22);
    public static final EntityType<Husk> HUSK = EntityType.getEntityType("husk", 23);
    public static final EntityType<SpectralArrow> SPECTRAL_ARROW = EntityType.getEntityType("spectral_arrow", 24);
    public static final EntityType<ShulkerBullet> SHULKER_BULLET = EntityType.getEntityType("shulker_bullet", 25);
    public static final EntityType<DragonFireball> DRAGON_FIREBALL = EntityType.getEntityType("dragon_fireball", 26);
    public static final EntityType<ZombieVillager> ZOMBIE_VILLAGER = EntityType.getEntityType("zombie_villager", 27);
    public static final EntityType<SkeletonHorse> SKELETON_HORSE = EntityType.getEntityType("skeleton_horse", 28);
    public static final EntityType<ZombieHorse> ZOMBIE_HORSE = EntityType.getEntityType("zombie_horse", 29);
    public static final EntityType<ArmorStand> ARMOR_STAND = EntityType.getEntityType("armor_stand", 30);
    public static final EntityType<Donkey> DONKEY = EntityType.getEntityType("donkey", 31);
    public static final EntityType<Mule> MULE = EntityType.getEntityType("mule", 32);
    public static final EntityType<EvokerFangs> EVOKER_FANGS = EntityType.getEntityType("evoker_fangs", 33);
    public static final EntityType<Evoker> EVOKER = EntityType.getEntityType("evoker", 34);
    public static final EntityType<Vex> VEX = EntityType.getEntityType("vex", 35);
    public static final EntityType<Vindicator> VINDICATOR = EntityType.getEntityType("vindicator", 36);
    public static final EntityType<Illusioner> ILLUSIONER = EntityType.getEntityType("illusioner", 37);
    public static final EntityType<CommandMinecart> COMMAND_BLOCK_MINECART = EntityType.getEntityType("command_block_minecart", 40);
    public static final EntityType<Boat> BOAT = EntityType.getEntityType("boat", 41);
    public static final EntityType<RideableMinecart> MINECART = EntityType.getEntityType("minecart", 42);
    public static final EntityType<StorageMinecart> CHEST_MINECART = EntityType.getEntityType("chest_minecart", 43);
    public static final EntityType<PoweredMinecart> FURNACE_MINECART = EntityType.getEntityType("furnace_minecart", 44);
    public static final EntityType<ExplosiveMinecart> TNT_MINECART = EntityType.getEntityType("tnt_minecart", 45);
    public static final EntityType<HopperMinecart> HOPPER_MINECART = EntityType.getEntityType("hopper_minecart", 46);
    public static final EntityType<SpawnerMinecart> SPAWNER_MINECART = EntityType.getEntityType("spawner_minecart", 47);
    public static final EntityType<Creeper> CREEPER = EntityType.getEntityType("creeper", 50);
    public static final EntityType<Skeleton> SKELETON = EntityType.getEntityType("skeleton", 51);
    public static final EntityType<Spider> SPIDER = EntityType.getEntityType("spider", 52);
    public static final EntityType<Giant> GIANT = EntityType.getEntityType("giant", 53);
    public static final EntityType<Zombie> ZOMBIE = EntityType.getEntityType("zombie", 54);
    public static final EntityType<Slime> SLIME = EntityType.getEntityType("slime", 55);
    public static final EntityType<Ghast> GHAST = EntityType.getEntityType("ghast", 56);
    public static final EntityType<PigZombie> ZOMBIFIED_PIGLIN = EntityType.getEntityType("zombified_piglin", 57);
    public static final EntityType<Enderman> ENDERMAN = EntityType.getEntityType("enderman", 58);
    public static final EntityType<CaveSpider> CAVE_SPIDER = EntityType.getEntityType("cave_spider", 59);
    public static final EntityType<Silverfish> SILVERFISH = EntityType.getEntityType("silverfish", 60);
    public static final EntityType<Blaze> BLAZE = EntityType.getEntityType("blaze", 61);
    public static final EntityType<MagmaCube> MAGMA_CUBE = EntityType.getEntityType("magma_cube", 62);
    public static final EntityType<EnderDragon> ENDER_DRAGON = EntityType.getEntityType("ender_dragon", 63);
    public static final EntityType<Wither> WITHER = EntityType.getEntityType("wither", 64);
    public static final EntityType<Bat> BAT = EntityType.getEntityType("bat", 65);
    public static final EntityType<Witch> WITCH = EntityType.getEntityType("witch", 66);
    public static final EntityType<Endermite> ENDERMITE = EntityType.getEntityType("endermite", 67);
    public static final EntityType<Guardian> GUARDIAN = EntityType.getEntityType("guardian", 68);
    public static final EntityType<Shulker> SHULKER = EntityType.getEntityType("shulker", 69);
    public static final EntityType<Pig> PIG = EntityType.getEntityType("pig", 90);
    public static final EntityType<Sheep> SHEEP = EntityType.getEntityType("sheep", 91);
    public static final EntityType<Cow> COW = EntityType.getEntityType("cow", 92);
    public static final EntityType<Chicken> CHICKEN = EntityType.getEntityType("chicken", 93);
    public static final EntityType<Squid> SQUID = EntityType.getEntityType("squid", 94);
    public static final EntityType<Wolf> WOLF = EntityType.getEntityType("wolf", 95);
    public static final EntityType<MushroomCow> MOOSHROOM = EntityType.getEntityType("mooshroom", 96);
    public static final EntityType<Snowman> SNOW_GOLEM = EntityType.getEntityType("snow_golem", 97);
    public static final EntityType<Ocelot> OCELOT = EntityType.getEntityType("ocelot", 98);
    public static final EntityType<IronGolem> IRON_GOLEM = EntityType.getEntityType("iron_golem", 99);
    public static final EntityType<Horse> HORSE = EntityType.getEntityType("horse", 100);
    public static final EntityType<Rabbit> RABBIT = EntityType.getEntityType("rabbit", 101);
    public static final EntityType<PolarBear> POLAR_BEAR = EntityType.getEntityType("polar_bear", 102);
    public static final EntityType<Llama> LLAMA = EntityType.getEntityType("llama", 103);
    public static final EntityType<LlamaSpit> LLAMA_SPIT = EntityType.getEntityType("llama_spit", 104);
    public static final EntityType<Parrot> PARROT = EntityType.getEntityType("parrot", 105);
    public static final EntityType<Villager> VILLAGER = EntityType.getEntityType("villager", 120);
    public static final EntityType<EnderCrystal> END_CRYSTAL = EntityType.getEntityType("end_crystal", 200);
    public static final EntityType<Turtle> TURTLE = EntityType.getEntityType("turtle");
    public static final EntityType<Phantom> PHANTOM = EntityType.getEntityType("phantom");
    public static final EntityType<Trident> TRIDENT = EntityType.getEntityType("trident");
    public static final EntityType<Cod> COD = EntityType.getEntityType("cod");
    public static final EntityType<Salmon> SALMON = EntityType.getEntityType("salmon");
    public static final EntityType<PufferFish> PUFFERFISH = EntityType.getEntityType("pufferfish");
    public static final EntityType<TropicalFish> TROPICAL_FISH = EntityType.getEntityType("tropical_fish");
    public static final EntityType<Drowned> DROWNED = EntityType.getEntityType("drowned");
    public static final EntityType<Dolphin> DOLPHIN = EntityType.getEntityType("dolphin");
    public static final EntityType<Cat> CAT = EntityType.getEntityType("cat");
    public static final EntityType<Panda> PANDA = EntityType.getEntityType("panda");
    public static final EntityType<Pillager> PILLAGER = EntityType.getEntityType("pillager");
    public static final EntityType<Ravager> RAVAGER = EntityType.getEntityType("ravager");
    public static final EntityType<TraderLlama> TRADER_LLAMA = EntityType.getEntityType("trader_llama");
    public static final EntityType<WanderingTrader> WANDERING_TRADER = EntityType.getEntityType("wandering_trader");
    public static final EntityType<Fox> FOX = EntityType.getEntityType("fox");
    public static final EntityType<Bee> BEE = EntityType.getEntityType("bee");
    public static final EntityType<Hoglin> HOGLIN = EntityType.getEntityType("hoglin");
    public static final EntityType<Piglin> PIGLIN = EntityType.getEntityType("piglin");
    public static final EntityType<Strider> STRIDER = EntityType.getEntityType("strider");
    public static final EntityType<Zoglin> ZOGLIN = EntityType.getEntityType("zoglin");
    public static final EntityType<PiglinBrute> PIGLIN_BRUTE = EntityType.getEntityType("piglin_brute");
    public static final EntityType<Axolotl> AXOLOTL = EntityType.getEntityType("axolotl");
    public static final EntityType<GlowItemFrame> GLOW_ITEM_FRAME = EntityType.getEntityType("glow_item_frame");
    public static final EntityType<GlowSquid> GLOW_SQUID = EntityType.getEntityType("glow_squid");
    public static final EntityType<Goat> GOAT = EntityType.getEntityType("goat");
    public static final EntityType<Marker> MARKER = EntityType.getEntityType("marker");
    public static final EntityType<Allay> ALLAY = EntityType.getEntityType("allay");
    public static final EntityType<ChestBoat> CHEST_BOAT = EntityType.getEntityType("chest_boat");
    public static final EntityType<Frog> FROG = EntityType.getEntityType("frog");
    public static final EntityType<Tadpole> TADPOLE = EntityType.getEntityType("tadpole");
    public static final EntityType<Warden> WARDEN = EntityType.getEntityType("warden");
    public static final EntityType<Camel> CAMEL = EntityType.getEntityType("camel");
    public static final EntityType<BlockDisplay> BLOCK_DISPLAY = EntityType.getEntityType("block_display");
    public static final EntityType<Interaction> INTERACTION = EntityType.getEntityType("interaction");
    public static final EntityType<ItemDisplay> ITEM_DISPLAY = EntityType.getEntityType("item_display");
    public static final EntityType<Sniffer> SNIFFER = EntityType.getEntityType("sniffer");
    public static final EntityType<TextDisplay> TEXT_DISPLAY = EntityType.getEntityType("text_display");
    public static final EntityType<FishHook> FISHING_BOBBER = EntityType.getEntityType("fishing_bobber");
    public static final EntityType<LightningStrike> LIGHTNING_BOLT = EntityType.getEntityType("lightning_bolt");
    public static final EntityType<Player> PLAYER = EntityType.getEntityType("player");
    @Deprecated
    public static final EntityType<Entity> UNKNOWN = Bukkit.getUnsafe().getUnkownEntityType();

    @NotNull
    private static <E extends Entity> EntityType<E> getEntityType(@NotNull String key) {
        return EntityType.getEntityType(key, -1);
    }

    @NotNull
    private static <E extends Entity> EntityType<E> getEntityType(@NotNull String key, int typeId) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        EntityType entityType = Registry.ENTITY_TYPE.get(namespacedKey);
        Preconditions.checkNotNull((Object)entityType, (String)"No EntityType found for %s. This is a bug.", (Object)namespacedKey);
        if (typeId > 0) {
            ID_MAP.put((Object)((short)typeId), (Object)entityType);
        }
        return entityType;
    }

    public abstract boolean isSpawnable();

    public abstract boolean isAlive();

    @Nullable
    public abstract Class<E> getEntityClass();

    @Deprecated
    @Nullable
    public abstract String getName();

    @Deprecated
    public short getTypeId() {
        return (Short)ID_MAP.inverse().getOrDefault((Object)this, (Object)-1);
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static EntityType<?> fromName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        name = EntityType.convertLegacy(name);
        return Registry.ENTITY_TYPE.get(NamespacedKey.fromString(name.toLowerCase(Locale.ENGLISH)));
    }

    @Deprecated
    @Nullable
    public static EntityType<?> fromId(int id) {
        if (id > Short.MAX_VALUE) {
            return null;
        }
        return (EntityType)ID_MAP.get((Object)((short)id));
    }

    @Deprecated
    @NotNull
    public static EntityType<?> valueOf(@NotNull String name) {
        EntityType entityType = Registry.ENTITY_TYPE.get(NamespacedKey.fromString((name = EntityType.convertLegacy(name)).toLowerCase()));
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (String)"No EntityType found with the name %s", (Object)name);
        return entityType;
    }

    @Deprecated
    @NotNull
    public static EntityType<?>[] values() {
        return Lists.newArrayList(Registry.ENTITY_TYPE).toArray(new EntityType[0]);
    }

    private static String convertLegacy(String from) {
        if (from == null) {
            return null;
        }
        switch (from.toLowerCase()) {
            case "xp_orb": {
                return "experience_orb";
            }
            case "ender_signal": 
            case "eye_of_ender_signal": {
                return "eye_of_ender";
            }
            case "xp_boottle": 
            case "thrown_exp_bottle": {
                return "experience_bottle";
            }
            case "firework": 
            case "fireworks_rocket": {
                return "firework_rocket";
            }
            case "evocation_fangs": {
                return "evoker_fangs";
            }
            case "evocation_illager": {
                return "evoker";
            }
            case "vindication_illager": {
                return "vindicator";
            }
            case "illusion_illager": {
                return "illusioner";
            }
            case "commandblock_minecart": 
            case "minecart_command": {
                return "command_block_minecart";
            }
            case "snowman": {
                return "snow_golem";
            }
            case "villager_golem": {
                return "iron_golem";
            }
            case "ender_crystal": {
                return "end_crystal";
            }
            case "dropped_item": {
                return "item";
            }
            case "leash_hitch": {
                return "leash_knot";
            }
            case "splash_potion": {
                return "potion";
            }
            case "primed_tnt": {
                return "tnt";
            }
            case "minecart_chest": {
                return "chest_minecart";
            }
            case "minecart_furnace": {
                return "furnace_minecart";
            }
            case "minecart_tnt": {
                return "tnt_minecart";
            }
            case "minecart_hopper": {
                return "hopper_minecart";
            }
            case "minecart_mob_spawner": {
                return "spawner_minecart";
            }
            case "mushroom_cow": {
                return "mooshroom";
            }
            case "fishing_hook": {
                return "fishing_bobber";
            }
            case "lightning": {
                return "lightning_bolt";
            }
        }
        return from;
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        return Bukkit.getDataPackManager().isEnabledByFeature(this, world);
    }
}

