/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.loot.LootTables;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Registry<T extends Keyed>
extends Iterable<T> {
    public static final Registry<Advancement> ADVANCEMENT = new Registry<Advancement>(){

        @Override
        @Nullable
        public Advancement get(@NotNull NamespacedKey key) {
            return Bukkit.getAdvancement(key);
        }

        @Override
        @NotNull
        public Iterator<Advancement> iterator() {
            return Bukkit.advancementIterator();
        }
    };
    public static final Registry<Art> ART = Objects.requireNonNull(Bukkit.getRegistry(Art.class), "No registry present for Art. This is a bug.");
    public static final Registry<Attribute> ATTRIBUTE = Objects.requireNonNull(Bukkit.getRegistry(Attribute.class), "No registry present for Attribute. This is a bug.");
    public static final Registry<Biome> BIOME = Objects.requireNonNull(Bukkit.getRegistry(Biome.class), "No registry present for Biome. This is a bug.");
    public static final Registry<BlockType> BLOCK = Objects.requireNonNull(Bukkit.getRegistry(BlockType.class), "No registry present for BlockType. This is a bug.");
    public static final Registry<PatternType> BANNER_PATTERN = Objects.requireNonNull(Bukkit.getRegistry(PatternType.class), "No registry present for PatternType. This is a bug.");
    public static final Registry<KeyedBossBar> BOSS_BARS = new Registry<KeyedBossBar>(){

        @Override
        @Nullable
        public KeyedBossBar get(@NotNull NamespacedKey key) {
            return Bukkit.getBossBar(key);
        }

        @Override
        @NotNull
        public Iterator<KeyedBossBar> iterator() {
            return Bukkit.getBossBars();
        }
    };
    public static final Registry<Cat.Type> CAT_TYPE = Objects.requireNonNull(Bukkit.getRegistry(Cat.Type.class), "No registry present for Cat Type. This is a bug.");
    public static final Registry<Enchantment> ENCHANTMENT = Objects.requireNonNull(Bukkit.getRegistry(Enchantment.class), "No registry present for Enchantment. This is a bug.");
    public static final Registry<EntityType> ENTITY_TYPE = Objects.requireNonNull(Bukkit.getRegistry(EntityType.class), "No registry present for EntityType. This is a bug.");
    public static final Registry<MusicInstrument> INSTRUMENT = Objects.requireNonNull(Bukkit.getRegistry(MusicInstrument.class), "No registry present for MusicInstrument. This is a bug.");
    public static final Registry<ItemType> ITEM = Objects.requireNonNull(Bukkit.getRegistry(ItemType.class), "No registry present for ItemType. This is a bug.");
    public static final Registry<LootTables> LOOT_TABLES = new SimpleRegistry<LootTables>(LootTables.class);
    @Deprecated
    public static final Registry<Material> MATERIAL = new SimpleRegistry<Material>(Material.class, mat -> !mat.isLegacy());
    public static final Registry<Particle> PARTICLE_TYPE = Objects.requireNonNull(Bukkit.getRegistry(Particle.class), "No registry present for Particle. This is a bug.");
    public static final Registry<PotionType> POTION = Objects.requireNonNull(Bukkit.getRegistry(PotionType.class), "No registry present for PotionType. This is a bug.");
    public static final Registry<Statistic> STATISTIC = Objects.requireNonNull(Bukkit.getRegistry(Statistic.class), "No registry present for Statistic. This is a bug.");
    public static final Registry<Structure> STRUCTURE = Objects.requireNonNull(Bukkit.getRegistry(Structure.class), "No registry present for Structure. This is a bug.");
    public static final Registry<StructureType> STRUCTURE_TYPE = Objects.requireNonNull(Bukkit.getRegistry(StructureType.class), "No registry present for StructureType. This is a bug.");
    public static final Registry<Sound> SOUNDS = Objects.requireNonNull(Bukkit.getRegistry(Sound.class), "No registry present for Sound. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<TrimMaterial> TRIM_MATERIAL = Objects.requireNonNull(Bukkit.getRegistry(TrimMaterial.class), "No registry present for TrimMaterial. This is a bug.");
    @ApiStatus.Experimental
    public static final Registry<TrimPattern> TRIM_PATTERN = Objects.requireNonNull(Bukkit.getRegistry(TrimPattern.class), "No registry present for TrimPattern. This is a bug.");
    public static final Registry<Villager.Profession> VILLAGER_PROFESSION = Objects.requireNonNull(Bukkit.getRegistry(Villager.Profession.class), "No registry present for Villager Profession. This is a bug.");
    public static final Registry<Villager.Type> VILLAGER_TYPE = Objects.requireNonNull(Bukkit.getRegistry(Villager.Type.class), "No registry present for Villager Type. This is a bug.");
    public static final Registry<MemoryKey> MEMORY_MODULE_TYPE = new Registry<MemoryKey>(){

        @Override
        @NotNull
        public Iterator iterator() {
            return MemoryKey.values().iterator();
        }

        @Override
        @Nullable
        public MemoryKey get(@NotNull NamespacedKey key) {
            return MemoryKey.getByKey(key);
        }
    };
    public static final Registry<Fluid> FLUID = Objects.requireNonNull(Bukkit.getRegistry(Fluid.class), "No registry present for Fluid. This is a bug.");
    public static final Registry<Frog.Variant> FROG_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Frog.Variant.class), "No registry present for Frog Variant. This is a bug.");
    public static final Registry<GameEvent> GAME_EVENT = Objects.requireNonNull(Bukkit.getRegistry(GameEvent.class), "No registry present for GameEvent. This is a bug.");
    public static final Registry<PotionEffectType> POTION_EFFECT_TYPE = Objects.requireNonNull(Bukkit.getRegistry(PotionEffectType.class), "No registry present for Potion Effect Type. This is a bug.");

    @Nullable
    public T get(@NotNull NamespacedKey var1);

    @Nullable
    default public T match(@NotNull String input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"input must not be null");
        String filtered = input.toLowerCase().replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString(filtered);
        return namespacedKey != null ? (T)this.get(namespacedKey) : null;
    }

    public static final class SimpleRegistry<T extends Enum<T>>
    implements Registry<T> {
        private final Map<NamespacedKey, T> map;

        protected SimpleRegistry(@NotNull Class<T> type) {
            this(type, (Predicate<T>)Predicates.alwaysTrue());
        }

        protected SimpleRegistry(@NotNull Class<T> type, @NotNull Predicate<T> predicate) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum entry = enumArray[n2];
                if (predicate.test(entry)) {
                    builder.put((Object)((Keyed)((Object)entry)).getKey(), (Object)entry);
                }
                ++n2;
            }
            this.map = builder.build();
        }

        @Override
        @Nullable
        public T get(@NotNull NamespacedKey key) {
            return (T)((Enum)this.map.get(key));
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }
    }
}

