/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public abstract class Particle<D>
extends OldEnum<Particle<D>>
implements Keyed {
    public static final Particle<Void> POOF = Particle.getParticle("poof");
    public static final Particle<Void> EXPLOSION = Particle.getParticle("explosion");
    public static final Particle<Void> EXPLOSION_EMITTER = Particle.getParticle("explosion_emitter");
    public static final Particle<Void> FIREWORK = Particle.getParticle("firework");
    public static final Particle<Void> BUBBLE = Particle.getParticle("bubble");
    public static final Particle<Void> SPLASH = Particle.getParticle("splash");
    public static final Particle<Void> FISHING = Particle.getParticle("fishing");
    public static final Particle<Void> UNDERWATER = Particle.getParticle("underwater");
    public static final Particle<Void> CRIT = Particle.getParticle("crit");
    public static final Particle<Void> ENCHANTED_HIT = Particle.getParticle("enchanted_hit");
    public static final Particle<Void> SMOKE = Particle.getParticle("smoke");
    public static final Particle<Void> LARGE_SMOKE = Particle.getParticle("large_smoke");
    public static final Particle<Void> EFFECT = Particle.getParticle("effect");
    public static final Particle<Void> INSTANT_EFFECT = Particle.getParticle("instant_effect");
    public static final Particle<Void> ENTITY_EFFECT = Particle.getParticle("entity_effect");
    public static final Particle<Void> AMBIENT_ENTITY_EFFECT = Particle.getParticle("ambient_entity_effect");
    public static final Particle<Void> WITCH = Particle.getParticle("witch");
    public static final Particle<Void> DRIPPING_WATER = Particle.getParticle("dripping_water");
    public static final Particle<Void> DRIPPING_LAVA = Particle.getParticle("dripping_lava");
    public static final Particle<Void> ANGRY_VILLAGER = Particle.getParticle("angry_villager");
    public static final Particle<Void> HAPPY_VILLAGER = Particle.getParticle("happy_villager");
    public static final Particle<Void> MYCELIUM = Particle.getParticle("mycelium");
    public static final Particle<Void> NOTE = Particle.getParticle("note");
    public static final Particle<Void> PORTAL = Particle.getParticle("portal");
    public static final Particle<Void> ENCHANT = Particle.getParticle("enchant");
    public static final Particle<Void> FLAME = Particle.getParticle("flame");
    public static final Particle<Void> LAVA = Particle.getParticle("lava");
    public static final Particle<Void> CLOUD = Particle.getParticle("cloud");
    public static final Particle<DustOptions> DUST = Particle.getParticle("dust");
    public static final Particle<Void> ITEM_SNOWBALL = Particle.getParticle("item_snowball");
    public static final Particle<Void> ITEM_SLIME = Particle.getParticle("item_slime");
    public static final Particle<Void> HEART = Particle.getParticle("heart");
    public static final Particle<ItemStack> ITEM = Particle.getParticle("item");
    public static final Particle<BlockData> BLOCK = Particle.getParticle("block");
    public static final Particle<Void> RAIN = Particle.getParticle("rain");
    public static final Particle<Void> ELDER_GUARDIAN = Particle.getParticle("elder_guardian");
    public static final Particle<Void> DRAGON_BREATH = Particle.getParticle("dragon_breath");
    public static final Particle<Void> END_ROD = Particle.getParticle("end_rod");
    public static final Particle<Void> DAMAGE_INDICATOR = Particle.getParticle("damage_indicator");
    public static final Particle<Void> SWEEP_ATTACK = Particle.getParticle("sweep_attack");
    public static final Particle<BlockData> FALLING_DUST = Particle.getParticle("falling_dust");
    public static final Particle<Void> TOTEM_OF_UNDYING = Particle.getParticle("totem_of_undying");
    public static final Particle<Void> SPIT = Particle.getParticle("spit");
    public static final Particle<Void> SQUID_INK = Particle.getParticle("squid_ink");
    public static final Particle<Void> BUBBLE_POP = Particle.getParticle("bubble_pop");
    public static final Particle<Void> CURRENT_DOWN = Particle.getParticle("current_down");
    public static final Particle<Void> BUBBLE_COLUMN_UP = Particle.getParticle("bubble_column_up");
    public static final Particle<Void> NAUTILUS = Particle.getParticle("nautilus");
    public static final Particle<Void> DOLPHIN = Particle.getParticle("dolphin");
    public static final Particle<Void> SNEEZE = Particle.getParticle("sneeze");
    public static final Particle<Void> CAMPFIRE_COSY_SMOKE = Particle.getParticle("campfire_cosy_smoke");
    public static final Particle<Void> CAMPFIRE_SIGNAL_SMOKE = Particle.getParticle("campfire_signal_smoke");
    public static final Particle<Void> COMPOSTER = Particle.getParticle("composter");
    public static final Particle<Void> FLASH = Particle.getParticle("flash");
    public static final Particle<Void> FALLING_LAVA = Particle.getParticle("falling_lava");
    public static final Particle<Void> LANDING_LAVA = Particle.getParticle("landing_lava");
    public static final Particle<Void> FALLING_WATER = Particle.getParticle("falling_water");
    public static final Particle<Void> DRIPPING_HONEY = Particle.getParticle("dripping_honey");
    public static final Particle<Void> FALLING_HONEY = Particle.getParticle("falling_honey");
    public static final Particle<Void> LANDING_HONEY = Particle.getParticle("landing_honey");
    public static final Particle<Void> FALLING_NECTAR = Particle.getParticle("falling_nectar");
    public static final Particle<Void> SOUL_FIRE_FLAME = Particle.getParticle("soul_fire_flame");
    public static final Particle<Void> ASH = Particle.getParticle("ash");
    public static final Particle<Void> CRIMSON_SPORE = Particle.getParticle("crimson_spore");
    public static final Particle<Void> WARPED_SPORE = Particle.getParticle("warped_spore");
    public static final Particle<Void> SOUL = Particle.getParticle("soul");
    public static final Particle<Void> DRIPPING_OBSIDIAN_TEAR = Particle.getParticle("dripping_obsidian_tear");
    public static final Particle<Void> FALLING_OBSIDIAN_TEAR = Particle.getParticle("falling_obsidian_tear");
    public static final Particle<Void> LANDING_OBSIDIAN_TEAR = Particle.getParticle("landing_obsidian_tear");
    public static final Particle<Void> REVERSE_PORTAL = Particle.getParticle("reverse_portal");
    public static final Particle<Void> WHITE_ASH = Particle.getParticle("white_ash");
    public static final Particle<DustTransition> DUST_COLOR_TRANSITION = Particle.getParticle("dust_color_transition");
    public static final Particle<Vibration> VIBRATION = Particle.getParticle("vibration");
    public static final Particle<Void> FALLING_SPORE_BLOSSOM = Particle.getParticle("falling_spore_blossom");
    public static final Particle<Void> SPORE_BLOSSOM_AIR = Particle.getParticle("spore_blossom_air");
    public static final Particle<Void> SMALL_FLAME = Particle.getParticle("small_flame");
    public static final Particle<Void> SNOWFLAKE = Particle.getParticle("snowflake");
    public static final Particle<Void> DRIPPING_DRIPSTONE_LAVA = Particle.getParticle("dripping_dripstone_lava");
    public static final Particle<Void> FALLING_DRIPSTONE_LAVA = Particle.getParticle("falling_dripstone_lava");
    public static final Particle<Void> DRIPPING_DRIPSTONE_WATER = Particle.getParticle("dripping_dripstone_water");
    public static final Particle<Void> FALLING_DRIPSTONE_WATER = Particle.getParticle("falling_dripstone_water");
    public static final Particle<Void> GLOW_SQUID_INK = Particle.getParticle("glow_squid_ink");
    public static final Particle<Void> GLOW = Particle.getParticle("glow");
    public static final Particle<Void> WAX_ON = Particle.getParticle("wax_on");
    public static final Particle<Void> WAX_OFF = Particle.getParticle("wax_off");
    public static final Particle<Void> ELECTRIC_SPARK = Particle.getParticle("electric_spark");
    public static final Particle<Void> SCRAPE = Particle.getParticle("scrape");
    public static final Particle<Void> SONIC_BOOM = Particle.getParticle("sonic_boom");
    public static final Particle<Void> SCULK_SOUL = Particle.getParticle("sculk_soul");
    public static final Particle<Float> SCULK_CHARGE = Particle.getParticle("sculk_charge");
    public static final Particle<Void> SCULK_CHARGE_POP = Particle.getParticle("sculk_charge_pop");
    public static final Particle<Integer> SHRIEK = Particle.getParticle("shriek");
    public static final Particle<Void> CHERRY_LEAVES = Particle.getParticle("cherry_leaves");
    public static final Particle<Void> EGG_CRACK = Particle.getParticle("egg_crack");
    public static final Particle<BlockData> BLOCK_MARKER = Particle.getParticle("block_marker");

    @NotNull
    private static <D> Particle<D> getParticle(@NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        Particle particle = Registry.PARTICLE_TYPE.get(namespacedKey);
        Preconditions.checkNotNull((Object)particle, (String)"No particle found for %s. This is a bug.", (Object)namespacedKey);
        return particle;
    }

    @NotNull
    public abstract Class<D> getDataType();

    @Deprecated
    @NotNull
    public static Particle<?> valueOf(@NotNull String name) {
        Particle particle = Registry.PARTICLE_TYPE.get(NamespacedKey.fromString((name = Particle.convertLegacy(name)).toLowerCase()));
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (String)"No particle found with the name %s", (Object)name);
        return particle;
    }

    @Deprecated
    @NotNull
    public static Particle<?>[] values() {
        return Lists.newArrayList(Registry.PARTICLE_TYPE).toArray(new Particle[0]);
    }

    private static String convertLegacy(String from) {
        if (from == null) {
            return null;
        }
        switch (from.toLowerCase()) {
            case "explosion_normal": {
                return "poof";
            }
            case "explosion_large": {
                return "explosion";
            }
            case "explosion_huge": {
                return "explosion_emitter";
            }
            case "fireworks_spark": {
                return "firework";
            }
            case "water_bubble": {
                return "bubble";
            }
            case "water_splash": {
                return "splash";
            }
            case "water_wake": {
                return "fishing";
            }
            case "suspended": {
                return "underwater";
            }
            case "suspended_depth": {
                return "underwater";
            }
            case "crit_magic": {
                return "enchanted_hit";
            }
            case "smoke_normal": {
                return "smoke";
            }
            case "smoke_large": {
                return "large_smoke";
            }
            case "spell": {
                return "effect";
            }
            case "spell_instant": {
                return "instant_effect";
            }
            case "spell_mob": {
                return "entity_effect";
            }
            case "spell_mob_ambient": {
                return "ambient_entity_effect";
            }
            case "spell_witch": {
                return "witch";
            }
            case "drip_water": {
                return "dripping_water";
            }
            case "drip_lava": {
                return "dripping_lava";
            }
            case "villager_angry": {
                return "angry_villager";
            }
            case "villager_happy": {
                return "happy_villager";
            }
            case "town_aura": {
                return "mycelium";
            }
            case "enchantment_table": {
                return "enchant";
            }
            case "redstone": {
                return "dust";
            }
            case "snowball": {
                return "item_snowball";
            }
            case "snow_shovel": {
                return "item_snowball";
            }
            case "slime": {
                return "item_slime";
            }
            case "item_crack": {
                return "item";
            }
            case "block_crack": {
                return "block";
            }
            case "block_dust": {
                return "block";
            }
            case "water_drop": {
                return "rain";
            }
            case "mob_appearance": {
                return "elder_guardian";
            }
            case "totem": {
                return "totem_of_undying";
            }
        }
        return from;
    }

    public static class DustOptions {
        private final Color color;
        private final float size;

        public DustOptions(@NotNull Color color, float size) {
            Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
            this.color = color;
            this.size = size;
        }

        @NotNull
        public Color getColor() {
            return this.color;
        }

        public float getSize() {
            return this.size;
        }
    }

    public static class DustTransition
    extends DustOptions {
        private final Color toColor;

        public DustTransition(@NotNull Color fromColor, @NotNull Color toColor, float size) {
            super(fromColor, size);
            Preconditions.checkArgument((toColor != null ? 1 : 0) != 0, (Object)"toColor");
            this.toColor = toColor;
        }

        @NotNull
        public Color getToColor() {
            return this.toColor;
        }
    }
}

