/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Registry<T extends Keyed>
extends Iterable<T> {
    public static final Registry<Advancement> ADVANCEMENT = new Registry<Advancement>(){

        @Override
        @Nullable
        public Advancement get(@NotNull NamespacedKey key) {
            return Bukkit.getAdvancement(key);
        }

        @Override
        @NotNull
        public Iterator<Advancement> iterator() {
            return Bukkit.advancementIterator();
        }
    };
    public static final Registry<Art> ART = new SimpleRegistry<Art>(Art.class);
    public static final Registry<Biome> BIOME = new SimpleRegistry<Biome>(Biome.class);
    public static final Registry<KeyedBossBar> BOSS_BARS = new Registry<KeyedBossBar>(){

        @Override
        @Nullable
        public KeyedBossBar get(@NotNull NamespacedKey key) {
            return Bukkit.getBossBar(key);
        }

        @Override
        @NotNull
        public Iterator<KeyedBossBar> iterator() {
            return Bukkit.getBossBars();
        }
    };
    public static final Registry<Enchantment> ENCHANTMENT = new Registry<Enchantment>(){

        @Override
        @Nullable
        public Enchantment get(@NotNull NamespacedKey key) {
            return Enchantment.getByKey(key);
        }

        @Override
        @NotNull
        public Iterator<Enchantment> iterator() {
            return Arrays.asList(Enchantment.values()).iterator();
        }
    };
    public static final Registry<EntityType> ENTITY_TYPE = new SimpleRegistry<EntityType>(EntityType.class);
    public static final Registry<LootTables> LOOT_TABLES = new SimpleRegistry<LootTables>(LootTables.class);
    public static final Registry<Material> MATERIAL = new SimpleRegistry<Material>(Material.class);
    public static final Registry<Statistic> STATISTIC = new SimpleRegistry<Statistic>(Statistic.class);

    @Nullable
    public T get(@NotNull NamespacedKey var1);

    public static final class SimpleRegistry<T extends Enum<T>>
    implements Registry<T> {
        private final Map<NamespacedKey, T> map;

        protected SimpleRegistry(@NotNull Class<T> type) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum entry = enumArray[n2];
                builder.put((Object)((Keyed)((Object)entry)).getKey(), (Object)entry);
                ++n2;
            }
            this.map = builder.build();
        }

        @Override
        @Nullable
        public T get(@NotNull NamespacedKey key) {
            return (T)((Enum)this.map.get(key));
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }
    }
}

