/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;

public class PlayerBedEnterEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Block bed;
    private final BedEnterResult bedEnterResult;
    private Event.Result useBed = Event.Result.DEFAULT;

    public PlayerBedEnterEvent(Player who, Block bed, BedEnterResult bedEnterResult) {
        super(who);
        this.bed = bed;
        this.bedEnterResult = bedEnterResult;
    }

    @Deprecated
    public PlayerBedEnterEvent(Player who, Block bed) {
        this(who, bed, BedEnterResult.OK);
    }

    public BedEnterResult getBedEnterResult() {
        return this.bedEnterResult;
    }

    public Event.Result useBed() {
        return this.useBed;
    }

    public void setUseBed(Event.Result useBed) {
        this.useBed = useBed;
    }

    @Override
    public boolean isCancelled() {
        return this.useBed == Event.Result.DENY || this.useBed == Event.Result.DEFAULT && this.bedEnterResult != BedEnterResult.OK;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.setUseBed(cancel ? Event.Result.DENY : (this.useBed() == Event.Result.DENY ? Event.Result.DEFAULT : this.useBed()));
    }

    public Block getBed() {
        return this.bed;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum BedEnterResult {
        OK,
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW,
        TOO_FAR_AWAY,
        NOT_SAFE,
        OTHER_PROBLEM;

    }
}

