/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.util;

import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class RayTraceResult {
    private final Vector hitPosition;
    private final Block hitBlock;
    private final BlockFace hitBlockFace;
    private final Entity hitEntity;

    private RayTraceResult(Vector hitPosition, Block hitBlock, BlockFace hitBlockFace, Entity hitEntity) {
        Validate.notNull((Object)hitPosition, (String)"Hit position is null!");
        this.hitPosition = hitPosition.clone();
        this.hitBlock = hitBlock;
        this.hitBlockFace = hitBlockFace;
        this.hitEntity = hitEntity;
    }

    public RayTraceResult(Vector hitPosition) {
        this(hitPosition, null, null, null);
    }

    public RayTraceResult(Vector hitPosition, BlockFace hitBlockFace) {
        this(hitPosition, null, hitBlockFace, null);
    }

    public RayTraceResult(Vector hitPosition, Block hitBlock, BlockFace hitBlockFace) {
        this(hitPosition, hitBlock, hitBlockFace, null);
    }

    public RayTraceResult(Vector hitPosition, Entity hitEntity) {
        this(hitPosition, null, null, hitEntity);
    }

    public RayTraceResult(Vector hitPosition, Entity hitEntity, BlockFace hitBlockFace) {
        this(hitPosition, null, hitBlockFace, hitEntity);
    }

    public Vector getHitPosition() {
        return this.hitPosition.clone();
    }

    public Block getHitBlock() {
        return this.hitBlock;
    }

    public BlockFace getHitBlockFace() {
        return this.hitBlockFace;
    }

    public Entity getHitEntity() {
        return this.hitEntity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hitPosition.hashCode();
        result = 31 * result + (this.hitBlock == null ? 0 : this.hitBlock.hashCode());
        result = 31 * result + (this.hitBlockFace == null ? 0 : this.hitBlockFace.hashCode());
        result = 31 * result + (this.hitEntity == null ? 0 : this.hitEntity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RayTraceResult)) {
            return false;
        }
        RayTraceResult other = (RayTraceResult)obj;
        if (!this.hitPosition.equals(other.hitPosition)) {
            return false;
        }
        if (!Objects.equals(this.hitBlock, other.hitBlock)) {
            return false;
        }
        if (!Objects.equals((Object)this.hitBlockFace, (Object)other.hitBlockFace)) {
            return false;
        }
        return Objects.equals(this.hitEntity, other.hitEntity);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RayTraceResult [hitPosition=");
        builder.append(this.hitPosition);
        builder.append(", hitBlock=");
        builder.append(this.hitBlock);
        builder.append(", hitBlockFace=");
        builder.append((Object)this.hitBlockFace);
        builder.append(", hitEntity=");
        builder.append(this.hitEntity);
        builder.append("]");
        return builder.toString();
    }
}

