/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory.meta.tags;

import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagAdapterContext;

public interface ItemTagType<T, Z> {
    public static final ItemTagType<Byte, Byte> BYTE = new PrimitiveTagType<Byte>(Byte.class);
    public static final ItemTagType<Short, Short> SHORT = new PrimitiveTagType<Short>(Short.class);
    public static final ItemTagType<Integer, Integer> INTEGER = new PrimitiveTagType<Integer>(Integer.class);
    public static final ItemTagType<Long, Long> LONG = new PrimitiveTagType<Long>(Long.class);
    public static final ItemTagType<Float, Float> FLOAT = new PrimitiveTagType<Float>(Float.class);
    public static final ItemTagType<Double, Double> DOUBLE = new PrimitiveTagType<Double>(Double.class);
    public static final ItemTagType<String, String> STRING = new PrimitiveTagType<String>(String.class);
    public static final ItemTagType<byte[], byte[]> BYTE_ARRAY = new PrimitiveTagType<byte[]>(byte[].class);
    public static final ItemTagType<int[], int[]> INTEGER_ARRAY = new PrimitiveTagType<int[]>(int[].class);
    public static final ItemTagType<long[], long[]> LONG_ARRAY = new PrimitiveTagType<long[]>(long[].class);
    public static final ItemTagType<CustomItemTagContainer, CustomItemTagContainer> TAG_CONTAINER = new PrimitiveTagType<CustomItemTagContainer>(CustomItemTagContainer.class);

    public Class<T> getPrimitiveType();

    public Class<Z> getComplexType();

    public T toPrimitive(Z var1, ItemTagAdapterContext var2);

    public Z fromPrimitive(T var1, ItemTagAdapterContext var2);

    public static class PrimitiveTagType<T>
    implements ItemTagType<T, T> {
        private final Class<T> primitiveType;

        PrimitiveTagType(Class<T> primitiveType) {
            this.primitiveType = primitiveType;
        }

        @Override
        public Class<T> getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        public Class<T> getComplexType() {
            return this.primitiveType;
        }

        @Override
        public T toPrimitive(T complex, ItemTagAdapterContext context) {
            return complex;
        }

        @Override
        public T fromPrimitive(T primitive, ItemTagAdapterContext context) {
            return primitive;
        }
    }
}

