/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.bukkit.command.CommandExecutor;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.annotation.command.Command;
import org.bukkit.plugin.java.annotation.command.Commands;
import org.bukkit.plugin.java.annotation.dependency.Dependency;
import org.bukkit.plugin.java.annotation.dependency.Library;
import org.bukkit.plugin.java.annotation.dependency.LoadBefore;
import org.bukkit.plugin.java.annotation.dependency.SoftDependency;
import org.bukkit.plugin.java.annotation.permission.ChildPermission;
import org.bukkit.plugin.java.annotation.permission.Permission;
import org.bukkit.plugin.java.annotation.permission.Permissions;
import org.bukkit.plugin.java.annotation.plugin.ApiVersion;
import org.bukkit.plugin.java.annotation.plugin.Description;
import org.bukkit.plugin.java.annotation.plugin.LoadOrder;
import org.bukkit.plugin.java.annotation.plugin.LogPrefix;
import org.bukkit.plugin.java.annotation.plugin.Plugin;
import org.bukkit.plugin.java.annotation.plugin.Website;
import org.bukkit.plugin.java.annotation.plugin.author.Author;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

@SupportedAnnotationTypes(value={"org.bukkit.plugin.java.annotation.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class PluginAnnotationProcessor
extends AbstractProcessor {
    private boolean hasMainBeenFound = false;
    private static final DateTimeFormatter dFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);

    @Override
    public boolean process(Set<? extends TypeElement> annots, RoundEnvironment rEnv) {
        ApiVersion apiVersion;
        boolean validPermissions;
        Permissions permissions;
        Element mainPluginElement = null;
        this.hasMainBeenFound = false;
        Set<? extends Element> elements = rEnv.getElementsAnnotatedWith(Plugin.class);
        if (elements.size() > 1) {
            this.raiseError("Found more than one plugin main class");
            return false;
        }
        if (elements.isEmpty()) {
            return false;
        }
        if (this.hasMainBeenFound) {
            this.raiseError("The plugin class has already been located, aborting!");
            return false;
        }
        mainPluginElement = elements.iterator().next();
        this.hasMainBeenFound = true;
        if (!(mainPluginElement instanceof TypeElement)) {
            this.raiseError("Main plugin class is not a class", mainPluginElement);
            return false;
        }
        TypeElement mainPluginType = (TypeElement)mainPluginElement;
        if (!(mainPluginType.getEnclosingElement() instanceof PackageElement)) {
            this.raiseError("Main plugin class is not a top-level class", mainPluginType);
            return false;
        }
        if (mainPluginType.getModifiers().contains((Object)Modifier.STATIC)) {
            this.raiseError("Main plugin class cannot be static nested", mainPluginType);
            return false;
        }
        if (!this.processingEnv.getTypeUtils().isSubtype(mainPluginType.asType(), this.fromClass(JavaPlugin.class))) {
            this.raiseError("Main plugin class is not an subclass of JavaPlugin!", mainPluginType);
        }
        if (mainPluginType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.raiseError("Main plugin class cannot be abstract", mainPluginType);
            return false;
        }
        this.checkForNoArgsConstructor(mainPluginType);
        LinkedHashMap yml = Maps.newLinkedHashMap();
        String mainName = mainPluginType.getQualifiedName().toString();
        yml.put("main", mainName);
        this.processAndPut(yml, "name", mainPluginType, mainName.substring(mainName.lastIndexOf(46) + 1), Plugin.class, String.class, "name");
        this.processAndPut(yml, "version", mainPluginType, "v0.0", Plugin.class, String.class, "version");
        this.processAndPut(yml, "description", mainPluginType, null, Description.class, String.class);
        this.processAndPut(yml, "load", mainPluginType, null, LoadOrder.class, String.class);
        Author[] authors = (Author[])mainPluginType.getAnnotationsByType(Author.class);
        ArrayList authorMap = Lists.newArrayList();
        Author[] authorArray = authors;
        int n = authors.length;
        int n2 = 0;
        while (n2 < n) {
            Author auth = authorArray[n2];
            authorMap.add(auth.value());
            ++n2;
        }
        if (authorMap.size() > 1) {
            yml.put("authors", authorMap);
        } else if (authorMap.size() == 1) {
            yml.put("author", authorMap.iterator().next());
        }
        this.processAndPut(yml, "website", mainPluginType, null, Website.class, String.class);
        this.processAndPut(yml, "prefix", mainPluginType, null, LogPrefix.class, String.class);
        Library[] libraries = (Library[])mainPluginType.getAnnotationsByType(Library.class);
        ArrayList libraryArr = Lists.newArrayList();
        Library[] libraryArray = libraries;
        int n3 = libraries.length;
        int n4 = 0;
        while (n4 < n3) {
            Library lib = libraryArray[n4];
            libraryArr.add(lib.value());
            ++n4;
        }
        if (!libraryArr.isEmpty()) {
            yml.put("libraries", libraryArr);
        }
        Dependency[] dependencies = (Dependency[])mainPluginType.getAnnotationsByType(Dependency.class);
        ArrayList hardDependencies = Lists.newArrayList();
        Dependency[] dependencyArray = dependencies;
        int n5 = dependencies.length;
        int n6 = 0;
        while (n6 < n5) {
            Dependency dep = dependencyArray[n6];
            hardDependencies.add(dep.value());
            ++n6;
        }
        if (!hardDependencies.isEmpty()) {
            yml.put("depend", hardDependencies);
        }
        SoftDependency[] softDependencies = (SoftDependency[])mainPluginType.getAnnotationsByType(SoftDependency.class);
        String[] softDepArr = new String[softDependencies.length];
        int i = 0;
        while (i < softDependencies.length) {
            softDepArr[i] = softDependencies[i].value();
            ++i;
        }
        if (softDepArr.length > 0) {
            yml.put("softdepend", softDepArr);
        }
        LoadBefore[] loadBefore = (LoadBefore[])mainPluginType.getAnnotationsByType(LoadBefore.class);
        String[] loadBeforeArr = new String[loadBefore.length];
        int i2 = 0;
        while (i2 < loadBefore.length) {
            loadBeforeArr[i2] = loadBefore[i2].value();
            ++i2;
        }
        if (loadBeforeArr.length > 0) {
            yml.put("loadbefore", loadBeforeArr);
        }
        LinkedHashMap commandMap = Maps.newLinkedHashMap();
        boolean validCommandExecutors = this.processExternalCommands(rEnv.getElementsAnnotatedWith(Commands.class), mainPluginType, commandMap);
        if (!validCommandExecutors) {
            return false;
        }
        Commands commands = mainPluginType.getAnnotation(Commands.class);
        if (commands != null) {
            LinkedHashMap merged = Maps.newLinkedHashMap();
            merged.putAll(commandMap);
            merged.putAll(this.processCommands(commands));
            commandMap = merged;
        }
        yml.put("commands", commandMap);
        LinkedHashMap permissionMetadata = Maps.newLinkedHashMap();
        Set<? extends Element> permissionAnnotations = rEnv.getElementsAnnotatedWith(Command.class);
        if (permissionAnnotations.size() > 0) {
            for (Element element : permissionAnnotations) {
                if (element.equals(mainPluginElement) || element.getAnnotation(Permission.class) == null) continue;
                Permission permissionAnnotation = element.getAnnotation(Permission.class);
                permissionMetadata.put(permissionAnnotation.name(), this.processPermission(permissionAnnotation));
            }
        }
        if ((permissions = mainPluginType.getAnnotation(Permissions.class)) != null) {
            LinkedHashMap joined = Maps.newLinkedHashMap();
            joined.putAll(permissionMetadata);
            joined.putAll(this.processPermissions(permissions));
            permissionMetadata = joined;
        }
        if (!(validPermissions = this.processExternalPermissions(rEnv.getElementsAnnotatedWith(Permissions.class), mainPluginType, permissionMetadata))) {
            return false;
        }
        yml.put("permissions", permissionMetadata);
        if (mainPluginType.getAnnotation(ApiVersion.class) != null && (apiVersion = mainPluginType.getAnnotation(ApiVersion.class)).value() != ApiVersion.Target.DEFAULT) {
            yml.put("api-version", apiVersion.value().getVersion());
        }
        try {
            Yaml yaml = new Yaml();
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "plugin.yml", new Element[0]);
            Throwable throwable = null;
            Object throwable2 = null;
            try (Writer w = file.openWriter();){
                w.append("# Auto-generated plugin.yml, generated at ").append(LocalDateTime.now().format(dFormat)).append(" by ").append(this.getClass().getName()).append("\n\n");
                String raw = yaml.dumpAs((Object)yml, Tag.MAP, DumperOptions.FlowStyle.BLOCK);
                w.write(raw);
                w.flush();
                w.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean processExternalPermissions(Set<? extends Element> commandExecutors, TypeElement mainPluginType, Map<String, Map<String, Object>> yml) {
        for (Element element : commandExecutors) {
            if (!(element instanceof TypeElement)) {
                this.raiseError("Specified Command Executor class is not a class.");
                return false;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.equals(mainPluginType)) continue;
            TypeMirror mirror = this.processingEnv.getElementUtils().getTypeElement(CommandExecutor.class.getName()).asType();
            if (!this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), mirror)) {
                this.raiseError("Specified Command Executor class is not assignable from CommandExecutor ");
                return false;
            }
            LinkedHashMap newMap = Maps.newLinkedHashMap();
            Permissions annotation = typeElement.getAnnotation(Permissions.class);
            if (annotation != null && annotation.value().length > 0) {
                newMap.putAll(this.processPermissions(annotation));
            }
            yml.putAll(newMap);
        }
        return true;
    }

    private void checkForNoArgsConstructor(TypeElement mainPluginType) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(mainPluginType.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty()) continue;
            return;
        }
        this.raiseError("Main plugin class must have a no argument constructor.", mainPluginType);
    }

    private void raiseError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private void raiseError(String message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private TypeMirror fromClass(Class<?> clazz) {
        return this.processingEnv.getElementUtils().getTypeElement(clazz.getName()).asType();
    }

    private <A extends Annotation, R> R processAndPut(Map<String, Object> map, String name, Element el, R defaultVal, Class<A> annotationType, Class<R> returnType) {
        return this.processAndPut(map, name, el, defaultVal, annotationType, returnType, "value");
    }

    private <A extends Annotation, R> R processAndPut(Map<String, Object> map, String name, Element el, R defaultVal, Class<A> annotationType, Class<R> returnType, String methodName) {
        R result = this.process(el, defaultVal, annotationType, returnType, methodName);
        if (result != null) {
            map.put(name, result);
        }
        return result;
    }

    private <A extends Annotation, R> R process(Element el, R defaultVal, Class<A> annotationType, Class<R> returnType, String methodName) {
        Object result;
        A ann = el.getAnnotation(annotationType);
        if (ann == null) {
            result = defaultVal;
        } else {
            try {
                Method value = annotationType.getMethod(methodName, new Class[0]);
                Object res = value.invoke(ann, new Object[0]);
                result = returnType == String.class ? res.toString() : returnType.cast(res);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean processExternalCommands(Set<? extends Element> commandExecutors, TypeElement mainPluginType, Map<String, Map<String, Object>> commandMetadata) {
        for (Element element : commandExecutors) {
            if (!(element instanceof TypeElement)) {
                this.raiseError("Specified Command Executor class is not a class.");
                return false;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.equals(mainPluginType)) continue;
            TypeMirror mirror = this.processingEnv.getElementUtils().getTypeElement(CommandExecutor.class.getName()).asType();
            if (!this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), mirror)) {
                this.raiseError("Specified Command Executor class is not assignable from CommandExecutor ");
                return false;
            }
            Commands annotation = typeElement.getAnnotation(Commands.class);
            if (annotation == null || annotation.value().length <= 0) continue;
            commandMetadata.putAll(this.processCommands(annotation));
        }
        return true;
    }

    protected Map<String, Map<String, Object>> processCommands(Commands commands) {
        LinkedHashMap commandList = Maps.newLinkedHashMap();
        Command[] commandArray = commands.value();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            commandList.put(command.name(), this.processCommand(command));
            ++n2;
        }
        return commandList;
    }

    protected Map<String, Object> processCommand(Command commandAnnotation) {
        LinkedHashMap command = Maps.newLinkedHashMap();
        if (commandAnnotation.aliases().length == 1) {
            command.put("aliases", commandAnnotation.aliases()[0]);
        } else if (commandAnnotation.aliases().length > 1) {
            command.put("aliases", commandAnnotation.aliases());
        }
        if (!commandAnnotation.desc().isEmpty()) {
            command.put("description", commandAnnotation.desc());
        }
        if (!commandAnnotation.permission().isEmpty()) {
            command.put("permission", commandAnnotation.permission());
        }
        if (!commandAnnotation.permissionMessage().isEmpty()) {
            command.put("permission-message", commandAnnotation.permissionMessage());
        }
        if (!commandAnnotation.usage().isEmpty()) {
            command.put("usage", commandAnnotation.usage());
        }
        return command;
    }

    protected Map<String, Object> processPermission(Permission permissionAnnotation) {
        LinkedHashMap permission = Maps.newLinkedHashMap();
        if (!"".equals(permissionAnnotation.desc())) {
            permission.put("description", permissionAnnotation.desc());
        }
        if (PermissionDefault.OP != permissionAnnotation.defaultValue()) {
            permission.put("default", permissionAnnotation.defaultValue().toString().toLowerCase());
        }
        if (permissionAnnotation.children().length > 0) {
            LinkedHashMap childrenList = Maps.newLinkedHashMap();
            ChildPermission[] childPermissionArray = permissionAnnotation.children();
            int n = childPermissionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChildPermission childPermission = childPermissionArray[n2];
                childrenList.put(childPermission.name(), childPermission.inherit());
                ++n2;
            }
            permission.put("children", childrenList);
        }
        return permission;
    }

    protected Map<String, Map<String, Object>> processPermissions(Permissions permissions) {
        LinkedHashMap permissionList = Maps.newLinkedHashMap();
        Permission[] permissionArray = permissions.value();
        int n = permissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Permission permission = permissionArray[n2];
            permissionList.put(permission.name(), this.processPermission(permission));
            ++n2;
        }
        return permissionList;
    }
}

