/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.annotation.command.Command;
import org.bukkit.plugin.java.annotation.dependency.Dependency;
import org.bukkit.plugin.java.annotation.dependency.LoadBefore;
import org.bukkit.plugin.java.annotation.dependency.SoftDependency;
import org.bukkit.plugin.java.annotation.permission.ChildPermission;
import org.bukkit.plugin.java.annotation.permission.Permission;
import org.bukkit.plugin.java.annotation.plugin.Description;
import org.bukkit.plugin.java.annotation.plugin.LoadOn;
import org.bukkit.plugin.java.annotation.plugin.LogPrefix;
import org.bukkit.plugin.java.annotation.plugin.Plugin;
import org.bukkit.plugin.java.annotation.plugin.UsesDatabase;
import org.bukkit.plugin.java.annotation.plugin.Website;
import org.bukkit.plugin.java.annotation.plugin.author.Author;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

@SupportedAnnotationTypes(value={"org.bukkit.plugin.java.annotation.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class PluginAnnotationProcessor
extends AbstractProcessor {
    private boolean hasMainBeenFound = false;
    private static final DateTimeFormatter dFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);

    @Override
    public boolean process(Set<? extends TypeElement> annots, RoundEnvironment rEnv) {
        Element main = null;
        this.hasMainBeenFound = false;
        Set<? extends Element> elements = rEnv.getElementsAnnotatedWith(Plugin.class);
        if (elements.size() > 1) {
            this.raiseError("Found more than one plugin main class");
            return false;
        }
        if (elements.isEmpty()) {
            return false;
        }
        if (this.hasMainBeenFound) {
            this.raiseError("The plugin class has already been located, aborting!");
            return false;
        }
        main = elements.iterator().next();
        this.hasMainBeenFound = true;
        if (!(main instanceof TypeElement)) {
            this.raiseError("Element annotated with @Main is not a type!", main);
            return false;
        }
        TypeElement mainType = (TypeElement)main;
        if (!(mainType.getEnclosingElement() instanceof PackageElement) && !mainType.getModifiers().contains((Object)Modifier.STATIC)) {
            this.raiseError("Element annotated with @Main is not top-level or static nested!", mainType);
            return false;
        }
        if (!this.processingEnv.getTypeUtils().isSubtype(mainType.asType(), this.fromClass(JavaPlugin.class))) {
            this.raiseError("Class annotated with @Main is not an subclass of JavaPlugin!", mainType);
        }
        LinkedHashMap yml = Maps.newLinkedHashMap();
        String mainName = mainType.getQualifiedName().toString();
        yml.put("main", mainName);
        this.processAndPut(yml, "name", mainType, mainName.substring(mainName.lastIndexOf(46) + 1), Plugin.class, String.class, "name");
        this.processAndPut(yml, "version", mainType, "v0.0", Plugin.class, String.class, "version");
        this.processAndPut(yml, "description", mainType, null, Description.class, String.class, "desc");
        this.processAndPut(yml, "load", mainType, null, LoadOn.class, String.class, "loadOn");
        Author[] authors = (Author[])mainType.getAnnotationsByType(Author.class);
        ArrayList authorMap = Lists.newArrayList();
        Author[] authorArray = authors;
        int n = authors.length;
        int n2 = 0;
        while (n2 < n) {
            Author auth = authorArray[n2];
            authorMap.add(auth.name());
            ++n2;
        }
        if (authorMap.size() > 1) {
            yml.put("authors", authorMap);
        } else if (authorMap.size() == 1) {
            yml.put("author", authorMap.iterator().next());
        }
        this.processAndPut(yml, "website", mainType, null, Website.class, String.class, "url");
        this.processAndPut(yml, "prefix", mainType, null, LogPrefix.class, String.class, "prefix");
        Dependency[] dependencies = (Dependency[])mainType.getAnnotationsByType(Dependency.class);
        ArrayList hardDependencies = Lists.newArrayList();
        Dependency[] dependencyArray = dependencies;
        int n3 = dependencies.length;
        int n4 = 0;
        while (n4 < n3) {
            Dependency dep = dependencyArray[n4];
            hardDependencies.add(dep.plugin());
            ++n4;
        }
        if (!hardDependencies.isEmpty()) {
            yml.putIfAbsent("depend", hardDependencies);
        }
        SoftDependency[] softDependencies = (SoftDependency[])mainType.getAnnotationsByType(SoftDependency.class);
        String[] softDepArr = new String[softDependencies.length];
        int i = 0;
        while (i < softDependencies.length) {
            softDepArr[i] = softDependencies[i].plugin();
            ++i;
        }
        if (softDepArr.length > 0) {
            yml.putIfAbsent("softdepend", softDepArr);
        }
        LoadBefore[] loadBefore = (LoadBefore[])mainType.getAnnotationsByType(LoadBefore.class);
        String[] loadBeforeArr = new String[loadBefore.length];
        int i2 = 0;
        while (i2 < loadBefore.length) {
            loadBeforeArr[i2] = loadBefore[i2].plugin();
            ++i2;
        }
        if (loadBeforeArr.length > 0) {
            yml.putIfAbsent("loadbefore", loadBeforeArr);
        }
        Command[] commands = (Command[])mainType.getAnnotationsByType(Command.class);
        LinkedHashMap commandMap = Maps.newLinkedHashMap();
        Command[] commandArray = commands;
        int n5 = commands.length;
        int n6 = 0;
        while (n6 < n5) {
            Command command = commandArray[n6];
            LinkedHashMap desc = Maps.newLinkedHashMap();
            String name = command.name();
            if (!command.desc().isEmpty()) {
                desc.put("description", command.desc());
            }
            if (command.aliases().length != 0) {
                desc.put("aliases", command.aliases());
            }
            if (!command.permission().isEmpty()) {
                desc.put("permission", command.permission());
            }
            if (!command.permissionMessage().isEmpty()) {
                desc.put("permission-message", command.permissionMessage());
            }
            if (!command.usage().isEmpty()) {
                desc.put("usage", command.usage());
            }
            commandMap.put(name, desc);
            ++n6;
        }
        if (!commandMap.isEmpty()) {
            yml.putIfAbsent("commands", commandMap);
        }
        Permission[] permissions = (Permission[])mainType.getAnnotationsByType(Permission.class);
        LinkedHashMap permMap = Maps.newLinkedHashMap();
        Permission[] permissionArray = permissions;
        int n7 = permissions.length;
        int n8 = 0;
        while (n8 < n7) {
            Permission perm = permissionArray[n8];
            LinkedHashMap desc = Maps.newLinkedHashMap();
            String name = perm.name();
            if (!perm.desc().isEmpty()) {
                desc.put("description", perm.desc());
            }
            desc.put("default", perm.defaultValue().toString());
            LinkedHashMap children = Maps.newLinkedHashMap();
            ChildPermission[] childPermissionArray = perm.children();
            int n9 = childPermissionArray.length;
            int n10 = 0;
            while (n10 < n9) {
                ChildPermission child = childPermissionArray[n10];
                children.put(child.name(), child.inherit());
                ++n10;
            }
            if (!children.isEmpty()) {
                desc.put("children", children);
            }
            permMap.put(name, desc);
            ++n8;
        }
        if (!permMap.isEmpty()) {
            yml.putIfAbsent("permissions", permMap);
        }
        if (mainType.getAnnotation(UsesDatabase.class) != null) {
            yml.put("database", true);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Database support was dropped in Bukkit in version 1.12.", mainType);
        }
        Yaml yaml = new Yaml();
        try {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "plugin.yml", new Element[0]);
            Throwable throwable = null;
            permissionArray = null;
            try (Writer w = file.openWriter();){
                w.append("# Auto-generated plugin.yml, generated at ").append(LocalDateTime.now().format(dFormat)).append(" by ").append(this.getClass().getName()).append("\n\n");
                String raw = yaml.dumpAs((Object)yml, Tag.MAP, DumperOptions.FlowStyle.BLOCK);
                w.write(raw);
                w.flush();
                w.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "NOTE: You are using org.bukkit.plugin.java.annotation, an experimental API!");
        return true;
    }

    private void raiseError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private void raiseError(String message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private TypeMirror fromClass(Class<?> clazz) {
        return this.processingEnv.getElementUtils().getTypeElement(clazz.getName()).asType();
    }

    private <A extends Annotation, R> R processAndPut(Map<String, Object> map, String name, Element el, R defaultVal, Class<A> annotationType, Class<R> returnType) {
        return this.processAndPut(map, name, el, defaultVal, annotationType, returnType, "value");
    }

    private <A extends Annotation, R> R processAndPut(Map<String, Object> map, String name, Element el, R defaultVal, Class<A> annotationType, Class<R> returnType, String methodName) {
        R result = this.process(el, defaultVal, annotationType, returnType, methodName);
        if (result != null) {
            map.putIfAbsent(name, result);
        }
        return result;
    }

    private <A extends Annotation, R> R process(Element el, R defaultVal, Class<A> annotationType, Class<R> returnType, String methodName) {
        Object result;
        A ann = el.getAnnotation(annotationType);
        if (ann == null) {
            result = defaultVal;
        } else {
            try {
                Method value = annotationType.getMethod(methodName, new Class[0]);
                Object res = value.invoke(ann, new Object[0]);
                result = returnType == String.class ? res.toString() : returnType.cast(res);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

