/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.time.Clock;
import java.time.Duration;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;

public class WebDriverWait
extends FluentWait<WebDriver> {
    private final WebDriver driver;

    @Deprecated
    public WebDriverWait(WebDriver driver, long timeoutInSeconds) {
        this(driver, Duration.ofSeconds(timeoutInSeconds));
    }

    public WebDriverWait(WebDriver driver, Duration timeout) {
        this(driver, timeout, Duration.ofMillis(500L), Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    @Deprecated
    public WebDriverWait(WebDriver driver, long timeoutInSeconds, long sleepInMillis) {
        this(driver, Duration.ofSeconds(timeoutInSeconds), Duration.ofMillis(sleepInMillis));
    }

    public WebDriverWait(WebDriver driver, Duration timeout, Duration sleep) {
        this(driver, timeout, sleep, Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    @Deprecated
    public WebDriverWait(WebDriver driver, Clock clock, Sleeper sleeper, long timeoutInSeconds, long sleepInMillis) {
        this(driver, Duration.ofSeconds(timeoutInSeconds), Duration.ofMillis(sleepInMillis), clock, sleeper);
    }

    public WebDriverWait(WebDriver driver, Duration timeout, Duration sleep, Clock clock, Sleeper sleeper) {
        super(driver, clock, sleeper);
        this.withTimeout(timeout);
        this.pollingEvery(sleep);
        this.ignoring(NotFoundException.class);
        this.driver = driver;
    }

    @Override
    protected RuntimeException timeoutException(String message, Throwable lastException) {
        WebDriver exceptionDriver = this.driver;
        TimeoutException ex = new TimeoutException(message, lastException);
        ex.addInfo("Driver info", exceptionDriver.getClass().getName());
        while (exceptionDriver instanceof WrapsDriver) {
            exceptionDriver = ((WrapsDriver)exceptionDriver).getWrappedDriver();
        }
        if (exceptionDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remote = (RemoteWebDriver)exceptionDriver;
            if (remote.getSessionId() != null) {
                ex.addInfo("Session ID", remote.getSessionId().toString());
            }
            if (remote.getCapabilities() != null) {
                ex.addInfo("Capabilities", remote.getCapabilities().toString());
            }
        }
        throw ex;
    }
}

