/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.firefox.AddHasContext;
import org.openqa.selenium.firefox.AddHasExtensions;
import org.openqa.selenium.firefox.AddHasFullPageScreenshot;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage,
HasExtensions,
HasFullPageScreenshot,
HasContext,
HasDevTools {
    @Deprecated
    public static final String BINARY = "firefox_binary";
    @Deprecated
    public static final String PROFILE = "firefox_profile";
    @Deprecated
    public static final String MARIONETTE = "marionette";
    private final Capabilities capabilities;
    protected FirefoxBinary binary;
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final HasExtensions extensions = new AddHasExtensions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasFullPageScreenshot fullPageScreenshot = new AddHasFullPageScreenshot().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasContext context = new AddHasContext().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final Optional<URI> cdpUri;
    private DevTools devTools;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions((Capabilities)Require.nonNull((String)"Capabilities", (Object)desiredCapabilities)));
    }

    @Deprecated
    public FirefoxDriver(FirefoxDriverService service, Capabilities desiredCapabilities) {
        this((FirefoxDriverService)((Object)Require.nonNull((String)"Driver service", (Object)((Object)service))), new FirefoxOptions(desiredCapabilities));
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(FirefoxDriver.toExecutor(options), options);
    }

    public FirefoxDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options) {
        this(new FirefoxDriverCommandExecutor(service), options);
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options) {
        super((CommandExecutor)executor, FirefoxDriver.dropCapabilities((Capabilities)options));
        Capabilities capabilities = super.getCapabilities();
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        Optional<ImmutableCapabilities> cdpUri = CdpEndpointFinder.getReportedUri((String)"moz:debuggerAddress", (Capabilities)capabilities).flatMap(reported -> CdpEndpointFinder.getCdpEndPoint((HttpClient.Factory)clientFactory, (URI)reported));
        this.cdpUri = cdpUri;
        this.capabilities = (Capabilities)cdpUri.map(uri -> new ImmutableCapabilities((Capabilities)new PersistentCapabilities(capabilities).setCapability("se:cdp", (Object)uri.toString()).setCapability("se:cdpVersion", (Object)"85"))).orElse(new ImmutableCapabilities(capabilities));
    }

    private static FirefoxDriverCommandExecutor toExecutor(FirefoxOptions options) {
        Require.nonNull((String)"Options to construct executor from", (Object)((Object)options));
        String sysProperty = System.getProperty("webdriver.firefox.marionette");
        boolean isLegacy = sysProperty != null && !Boolean.parseBoolean(sysProperty) || options.isLegacy();
        FirefoxDriverService.Builder builder = StreamSupport.stream(ServiceLoader.load(DriverService.Builder.class).spliterator(), false).filter(b -> b instanceof FirefoxDriverService.Builder).map(FirefoxDriverService.Builder.class::cast).filter(b -> b.isLegacy() == isLegacy).findFirst().orElseThrow(WebDriverException::new);
        return new FirefoxDriverCommandExecutor(builder.withOptions(options).build());
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    @Override
    public String installExtension(Path path) {
        Require.nonNull((String)"Path", (Object)path);
        return this.extensions.installExtension(path);
    }

    @Override
    public void uninstallExtension(String extensionId) {
        Require.nonNull((String)"Extension ID", (Object)extensionId);
        this.extensions.uninstallExtension(extensionId);
    }

    @Override
    public <X> X getFullPageScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Require.nonNull((String)"OutputType", outputType);
        return this.fullPageScreenshot.getFullPageScreenshotAs(outputType);
    }

    @Override
    public void setContext(FirefoxCommandContext commandContext) {
        Require.nonNull((String)"Firefox Command Context", (Object)((Object)commandContext));
        this.context.setContext(commandContext);
    }

    @Override
    public FirefoxCommandContext getContext() {
        return this.context.getContext();
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        MutableCapabilities caps;
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet toRemove = Sets.newHashSet((Object[])new String[]{BINARY, PROFILE});
            caps = new MutableCapabilities(Maps.filterKeys((Map)capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new MutableCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public Optional<DevTools> maybeGetDevTools() {
        if (this.devTools != null) {
            return Optional.of(this.devTools);
        }
        if (!this.cdpUri.isPresent()) {
            return Optional.empty();
        }
        URI wsUri = this.cdpUri.orElseThrow(() -> new DevToolsException("This version of Firefox or geckodriver does not support CDP"));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection connection = new Connection(wsClient, wsUri.toString());
        CdpInfo cdpInfo = new CdpVersionFinder().match("85.0").orElseGet(NoOpCdpInfo::new);
        this.devTools = new DevTools(arg_0 -> ((CdpInfo)cdpInfo).getDomains(arg_0), connection);
        return Optional.of(this.devTools);
    }

    public DevTools getDevTools() {
        if (!this.cdpUri.isPresent()) {
            throw new DevToolsException("This version of Firefox or geckodriver does not support CDP");
        }
        return this.maybeGetDevTools().orElseThrow(() -> new DevToolsException("Unable to initialize CDP connection"));
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        public FirefoxDriverCommandExecutor(DriverService service) {
            super(service, FirefoxDriverCommandExecutor.getExtraCommands());
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return ImmutableMap.builder().putAll(new AddHasContext().getAdditionalCommands()).putAll(new AddHasExtensions().getAdditionalCommands()).putAll(new AddHasFullPageScreenshot().getAdditionalCommands()).build();
        }
    }

    public static final class Capability {
        public static final String BINARY = "firefox_binary";
        public static final String PROFILE = "firefox_profile";
        public static final String MARIONETTE = "marionette";
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

