/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v97.media.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class PlayerError {
    private final Type type;
    private final String errorCode;

    public PlayerError(Type type, String errorCode) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is required");
    }

    public Type getType() {
        return this.type;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    private static PlayerError fromJson(JsonInput input) {
        Type type = null;
        String errorCode = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block8;
                }
                case "errorCode": {
                    errorCode = input.nextString();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlayerError(type, errorCode);
    }

    public static enum Type {
        PIPELINE_ERROR("pipeline_error"),
        MEDIA_ERROR("media_error");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

