package org.openqa.selenium.devtools.v96.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class WasmCrossOriginModuleSharingIssueDetails {

    private final java.lang.String wasmModuleUrl;

    private final java.lang.String sourceOrigin;

    private final java.lang.String targetOrigin;

    private final java.lang.Boolean isWarning;

    public WasmCrossOriginModuleSharingIssueDetails(java.lang.String wasmModuleUrl, java.lang.String sourceOrigin, java.lang.String targetOrigin, java.lang.Boolean isWarning) {
        this.wasmModuleUrl = java.util.Objects.requireNonNull(wasmModuleUrl, "wasmModuleUrl is required");
        this.sourceOrigin = java.util.Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.targetOrigin = java.util.Objects.requireNonNull(targetOrigin, "targetOrigin is required");
        this.isWarning = java.util.Objects.requireNonNull(isWarning, "isWarning is required");
    }

    public java.lang.String getWasmModuleUrl() {
        return wasmModuleUrl;
    }

    public java.lang.String getSourceOrigin() {
        return sourceOrigin;
    }

    public java.lang.String getTargetOrigin() {
        return targetOrigin;
    }

    public java.lang.Boolean getIsWarning() {
        return isWarning;
    }

    private static WasmCrossOriginModuleSharingIssueDetails fromJson(JsonInput input) {
        java.lang.String wasmModuleUrl = null;
        java.lang.String sourceOrigin = null;
        java.lang.String targetOrigin = null;
        java.lang.Boolean isWarning = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "wasmModuleUrl":
                    wasmModuleUrl = input.nextString();
                    break;
                case "sourceOrigin":
                    sourceOrigin = input.nextString();
                    break;
                case "targetOrigin":
                    targetOrigin = input.nextString();
                    break;
                case "isWarning":
                    isWarning = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WasmCrossOriginModuleSharingIssueDetails(wasmModuleUrl, sourceOrigin, targetOrigin, isWarning);
    }
}
