package org.openqa.selenium.devtools.v94.performancetimeline.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TimelineEvent {

    private final org.openqa.selenium.devtools.v94.page.model.FrameId frameId;

    private final java.lang.String type;

    private final java.lang.String name;

    private final org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch time;

    private final java.util.Optional<java.lang.Number> duration;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LargestContentfulPaint> lcpDetails;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LayoutShift> layoutShiftDetails;

    public TimelineEvent(org.openqa.selenium.devtools.v94.page.model.FrameId frameId, java.lang.String type, java.lang.String name, org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch time, java.util.Optional<java.lang.Number> duration, java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LargestContentfulPaint> lcpDetails, java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LayoutShift> layoutShiftDetails) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.time = java.util.Objects.requireNonNull(time, "time is required");
        this.duration = duration;
        this.lcpDetails = lcpDetails;
        this.layoutShiftDetails = layoutShiftDetails;
    }

    /**
     * Identifies the frame that this event is related to. Empty for non-frame targets.
     */
    public org.openqa.selenium.devtools.v94.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype
     * This determines which of the optional "details" fiedls is present.
     */
    public java.lang.String getType() {
        return type;
    }

    /**
     * Name may be empty depending on the type.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Time in seconds since Epoch, monotonically increasing within document lifetime.
     */
    public org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch getTime() {
        return time;
    }

    /**
     * Event duration, if applicable.
     */
    public java.util.Optional<java.lang.Number> getDuration() {
        return duration;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LargestContentfulPaint> getLcpDetails() {
        return lcpDetails;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LayoutShift> getLayoutShiftDetails() {
        return layoutShiftDetails;
    }

    private static TimelineEvent fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v94.page.model.FrameId frameId = null;
        java.lang.String type = null;
        java.lang.String name = null;
        org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch time = null;
        java.util.Optional<java.lang.Number> duration = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LargestContentfulPaint> lcpDetails = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v94.performancetimeline.model.LayoutShift> layoutShiftDetails = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v94.page.model.FrameId.class);
                    break;
                case "type":
                    type = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "time":
                    time = input.read(org.openqa.selenium.devtools.v94.network.model.TimeSinceEpoch.class);
                    break;
                case "duration":
                    duration = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "lcpDetails":
                    lcpDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.performancetimeline.model.LargestContentfulPaint.class));
                    break;
                case "layoutShiftDetails":
                    layoutShiftDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.performancetimeline.model.LayoutShift.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TimelineEvent(frameId, type, name, time, duration, lcpDetails, layoutShiftDetails);
    }
}
