package org.openqa.selenium.devtools.v94.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS property declaration data.
 */
public class CSSProperty {

    private final java.lang.String name;

    private final java.lang.String value;

    private final java.util.Optional<java.lang.Boolean> important;

    private final java.util.Optional<java.lang.Boolean> implicit;

    private final java.util.Optional<java.lang.String> text;

    private final java.util.Optional<java.lang.Boolean> parsedOk;

    private final java.util.Optional<java.lang.Boolean> disabled;

    private final java.util.Optional<org.openqa.selenium.devtools.v94.css.model.SourceRange> range;

    public CSSProperty(java.lang.String name, java.lang.String value, java.util.Optional<java.lang.Boolean> important, java.util.Optional<java.lang.Boolean> implicit, java.util.Optional<java.lang.String> text, java.util.Optional<java.lang.Boolean> parsedOk, java.util.Optional<java.lang.Boolean> disabled, java.util.Optional<org.openqa.selenium.devtools.v94.css.model.SourceRange> range) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.important = important;
        this.implicit = implicit;
        this.text = text;
        this.parsedOk = parsedOk;
        this.disabled = disabled;
        this.range = range;
    }

    /**
     * The property name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * The property value.
     */
    public java.lang.String getValue() {
        return value;
    }

    /**
     * Whether the property has "!important" annotation (implies `false` if absent).
     */
    public java.util.Optional<java.lang.Boolean> getImportant() {
        return important;
    }

    /**
     * Whether the property is implicit (implies `false` if absent).
     */
    public java.util.Optional<java.lang.Boolean> getImplicit() {
        return implicit;
    }

    /**
     * The full property text as specified in the style.
     */
    public java.util.Optional<java.lang.String> getText() {
        return text;
    }

    /**
     * Whether the property is understood by the browser (implies `true` if absent).
     */
    public java.util.Optional<java.lang.Boolean> getParsedOk() {
        return parsedOk;
    }

    /**
     * Whether the property is disabled by the user (present for source-based properties only).
     */
    public java.util.Optional<java.lang.Boolean> getDisabled() {
        return disabled;
    }

    /**
     * The entire property range in the enclosing style declaration (if available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v94.css.model.SourceRange> getRange() {
        return range;
    }

    private static CSSProperty fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.String value = null;
        java.util.Optional<java.lang.Boolean> important = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> implicit = java.util.Optional.empty();
        java.util.Optional<java.lang.String> text = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> parsedOk = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> disabled = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v94.css.model.SourceRange> range = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextString();
                    break;
                case "important":
                    important = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "implicit":
                    implicit = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "text":
                    text = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "parsedOk":
                    parsedOk = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "disabled":
                    disabled = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v94.css.model.SourceRange.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSProperty(name, value, important, implicit, text, parsedOk, disabled, range);
    }
}
