package org.openqa.selenium.devtools.v94.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TrustedWebActivityIssueDetails {

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v94.audits.model.TwaQualityEnforcementViolationType violationType;

    private final java.util.Optional<java.lang.Integer> httpStatusCode;

    private final java.util.Optional<java.lang.String> packageName;

    private final java.util.Optional<java.lang.String> signature;

    public TrustedWebActivityIssueDetails(java.lang.String url, org.openqa.selenium.devtools.v94.audits.model.TwaQualityEnforcementViolationType violationType, java.util.Optional<java.lang.Integer> httpStatusCode, java.util.Optional<java.lang.String> packageName, java.util.Optional<java.lang.String> signature) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.violationType = java.util.Objects.requireNonNull(violationType, "violationType is required");
        this.httpStatusCode = httpStatusCode;
        this.packageName = packageName;
        this.signature = signature;
    }

    /**
     * The url that triggers the violation.
     */
    public java.lang.String getUrl() {
        return url;
    }

    public org.openqa.selenium.devtools.v94.audits.model.TwaQualityEnforcementViolationType getViolationType() {
        return violationType;
    }

    public java.util.Optional<java.lang.Integer> getHttpStatusCode() {
        return httpStatusCode;
    }

    /**
     * The package name of the Trusted Web Activity client app. This field is
     * only used when violation type is kDigitalAssetLinks.
     */
    public java.util.Optional<java.lang.String> getPackageName() {
        return packageName;
    }

    /**
     * The signature of the Trusted Web Activity client app. This field is only
     * used when violation type is kDigitalAssetLinks.
     */
    public java.util.Optional<java.lang.String> getSignature() {
        return signature;
    }

    private static TrustedWebActivityIssueDetails fromJson(JsonInput input) {
        java.lang.String url = null;
        org.openqa.selenium.devtools.v94.audits.model.TwaQualityEnforcementViolationType violationType = null;
        java.util.Optional<java.lang.Integer> httpStatusCode = java.util.Optional.empty();
        java.util.Optional<java.lang.String> packageName = java.util.Optional.empty();
        java.util.Optional<java.lang.String> signature = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "violationType":
                    violationType = input.read(org.openqa.selenium.devtools.v94.audits.model.TwaQualityEnforcementViolationType.class);
                    break;
                case "httpStatusCode":
                    httpStatusCode = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "packageName":
                    packageName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "signature":
                    signature = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TrustedWebActivityIssueDetails(url, violationType, httpStatusCode, packageName, signature);
    }
}
