/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v111.network.model.Initiator;
import org.openqa.selenium.devtools.v111.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v111.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebTransportCreated {
    private final RequestId transportId;
    private final String url;
    private final MonotonicTime timestamp;
    private final Optional<Initiator> initiator;

    public WebTransportCreated(RequestId transportId, String url, MonotonicTime timestamp, Optional<Initiator> initiator) {
        this.transportId = Objects.requireNonNull(transportId, "transportId is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    public RequestId getTransportId() {
        return this.transportId;
    }

    public String getUrl() {
        return this.url;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Optional<Initiator> getInitiator() {
        return this.initiator;
    }

    private static WebTransportCreated fromJson(JsonInput input) {
        RequestId transportId = null;
        String url = null;
        MonotonicTime timestamp = null;
        Optional<Initiator> initiator = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "transportId": {
                    transportId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block12;
                }
                case "initiator": {
                    initiator = Optional.ofNullable((Initiator)input.read(Initiator.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebTransportCreated(transportId, url, timestamp, initiator);
    }
}

