/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ResourceType {
    DOCUMENT("Document"),
    STYLESHEET("Stylesheet"),
    IMAGE("Image"),
    MEDIA("Media"),
    FONT("Font"),
    SCRIPT("Script"),
    TEXTTRACK("TextTrack"),
    XHR("XHR"),
    FETCH("Fetch"),
    PREFETCH("Prefetch"),
    EVENTSOURCE("EventSource"),
    WEBSOCKET("WebSocket"),
    MANIFEST("Manifest"),
    SIGNEDEXCHANGE("SignedExchange"),
    PING("Ping"),
    CSPVIOLATIONREPORT("CSPViolationReport"),
    PREFLIGHT("Preflight"),
    OTHER("Other");

    private String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType fromString(String s) {
        return Arrays.stream(ResourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ResourceType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ResourceType fromJson(JsonInput input) {
        return ResourceType.fromString(input.nextString());
    }
}

