/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.debugger.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScriptPosition {
    private final Integer lineNumber;
    private final Integer columnNumber;

    public ScriptPosition(Integer lineNumber, Integer columnNumber) {
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static ScriptPosition fromJson(JsonInput input) {
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block8;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScriptPosition(lineNumber, columnNumber);
    }
}

