/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v100.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v100.css.model.SourceRange;
import org.openqa.selenium.json.JsonInput;

public class Value {
    private final String text;
    private final Optional<SourceRange> range;

    public Value(String text, Optional<SourceRange> range) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    private static Value fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block8;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Value(text, range);
    }
}

