/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SharedCapabilitiesMethods;
import org.openqa.selenium.internal.Require;

public class MutableCapabilities
implements Capabilities {
    private static final Set<String> OPTION_KEYS;
    private final Map<String, Object> caps = new TreeMap<String, Object>();

    public MutableCapabilities() {
    }

    public MutableCapabilities(Capabilities other) {
        this(other.asMap());
    }

    public MutableCapabilities(Map<String, ?> capabilities) {
        capabilities.forEach((key, value) -> {
            if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    @Override
    public MutableCapabilities merge(Capabilities other) {
        MutableCapabilities newInstance = new MutableCapabilities(this);
        if (other != null) {
            other.asMap().forEach(newInstance::setCapability);
        }
        return newInstance;
    }

    public void setCapability(String capabilityName, boolean value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, String value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String capabilityName, Platform value) {
        this.setCapability(capabilityName, (Object)value);
    }

    public void setCapability(String key, Object value) {
        Require.nonNull("Capability name", key);
        if (OPTION_KEYS.contains(key) && value instanceof Capabilities) {
            ((Capabilities)value).asMap().forEach(this::setCapability);
            return;
        }
        if (value == null) {
            this.caps.remove(key);
            return;
        }
        SharedCapabilitiesMethods.setCapability(this.caps, key, value);
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.caps);
    }

    @Override
    public Object getCapability(String capabilityName) {
        return this.caps.get(capabilityName);
    }

    @Override
    public Set<String> getCapabilityNames() {
        return Collections.unmodifiableSet(this.caps.keySet());
    }

    public Map<String, Object> toJson() {
        return this.asMap();
    }

    public int hashCode() {
        return SharedCapabilitiesMethods.hashCode(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Capabilities)) {
            return false;
        }
        return SharedCapabilitiesMethods.equals(this, (Capabilities)o);
    }

    public String toString() {
        return SharedCapabilitiesMethods.toString(this);
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add("goog:chromeOptions");
        keys.add("moz:firefoxOptions");
        keys.add("se:ieOptions");
        OPTION_KEYS = Collections.unmodifiableSet(keys);
    }
}

