/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards.util;

import java.util.Collection;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ModelSet;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.intList;
import org.sdmlib.storyboards.Storyboard;
import org.sdmlib.storyboards.StoryboardStep;
import org.sdmlib.storyboards.StoryboardWall;
import org.sdmlib.storyboards.util.StoryboardPO;
import org.sdmlib.storyboards.util.StoryboardStepSet;
import org.sdmlib.storyboards.util.StoryboardWallSet;

public class StoryboardSet
extends SDMSet<Storyboard>
implements ModelSet {
    private static final long serialVersionUID = 1L;
    public static final StoryboardSet EMPTY_SET = (StoryboardSet)new StoryboardSet().withReadOnly(true);

    @Override
    public String toString() {
        StringList stringList = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard elem = (Storyboard)iterator.next();
            stringList.add(elem.toString());
        }
        return "(" + stringList.concat(", ") + ")";
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.storyboards.Storyboard";
    }

    public StoryboardSet with(Storyboard value) {
        this.add(value);
        return this;
    }

    public StoryboardSet without(Storyboard value) {
        this.remove(value);
        return this;
    }

    public StoryboardStepSet getStoryboardSteps() {
        StoryboardStepSet result = new StoryboardStepSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            result.with(obj.getStoryboardSteps());
        }
        return result;
    }

    public StoryboardSet withStoryboardSteps(StoryboardStep value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.withStoryboardSteps(value);
        }
        return this;
    }

    public StoryboardSet withoutStoryboardSteps(StoryboardStep value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.withoutStoryboardSteps(value);
        }
        return this;
    }

    public StringList getRootDir() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            result.add(obj.getRootDir());
        }
        return result;
    }

    public StoryboardSet withRootDir(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.setRootDir(value);
        }
        return this;
    }

    public intList getStepCounter() {
        intList result = new intList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            result.add(obj.getStepCounter());
        }
        return result;
    }

    public StoryboardSet withStepCounter(int value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.setStepCounter(value);
        }
        return this;
    }

    public intList getStepDoneCounter() {
        intList result = new intList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            result.add(obj.getStepDoneCounter());
        }
        return result;
    }

    public StoryboardSet withStepDoneCounter(int value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.setStepDoneCounter(value);
        }
        return this;
    }

    public StoryboardPO startModelPattern() {
        return new StoryboardPO((Storyboard[])this.toArray(new Storyboard[this.size()]));
    }

    public StoryboardSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((Storyboard)value);
        }
        return this;
    }

    public StoryboardPO hasStoryboardPO() {
        return new StoryboardPO((Storyboard[])this.toArray(new Storyboard[this.size()]));
    }

    public StoryboardWallSet getWall() {
        StoryboardWallSet result = new StoryboardWallSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            result.add(obj.getWall());
        }
        return result;
    }

    public StoryboardSet hasWall(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        StoryboardSet answer = new StoryboardSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            if (!neighbors.contains(obj.getWall())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public StoryboardSet withWall(StoryboardWall value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Storyboard obj = (Storyboard)iterator.next();
            obj.withWall(value);
        }
        return this;
    }
}

