/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards.util;

import java.util.Collection;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ModelSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.intList;
import org.sdmlib.storyboards.KanbanEntry;
import org.sdmlib.storyboards.LogEntryStoryBoard;
import org.sdmlib.storyboards.util.KanbanEntryPO;
import org.sdmlib.storyboards.util.LogEntryStoryBoardSet;

public class KanbanEntrySet
extends SDMSet<KanbanEntry>
implements ModelSet {
    private static final long serialVersionUID = 1L;
    public static final KanbanEntrySet EMPTY_SET = (KanbanEntrySet)new KanbanEntrySet().withReadOnly(true);

    public LogEntryStoryBoardSet getLogEntries() {
        LogEntryStoryBoardSet result = new LogEntryStoryBoardSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            result.with(obj.getLogEntries());
        }
        return result;
    }

    public KanbanEntrySet withLogEntries(LogEntryStoryBoard value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            obj.withLogEntries(value);
        }
        return this;
    }

    public KanbanEntrySet withoutLogEntries(LogEntryStoryBoard value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            obj.withoutLogEntries(value);
        }
        return this;
    }

    @Override
    public String toString() {
        StringList stringList = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry elem = (KanbanEntry)iterator.next();
            stringList.add(elem.toString());
        }
        return "(" + stringList.concat(", ") + ")";
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.storyboards.KanbanEntry";
    }

    public intList getOldNoOfLogEntries() {
        intList result = new intList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            result.add(obj.getOldNoOfLogEntries());
        }
        return result;
    }

    public KanbanEntrySet withOldNoOfLogEntries(int value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            obj.setOldNoOfLogEntries(value);
        }
        return this;
    }

    public KanbanEntryPO startModelPattern() {
        return new KanbanEntryPO((KanbanEntry[])this.toArray(new KanbanEntry[this.size()]));
    }

    public KanbanEntrySet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((KanbanEntry)value);
        }
        return this;
    }

    public KanbanEntrySet without(KanbanEntry value) {
        this.remove(value);
        return this;
    }

    public StringList getPhases() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            result.add(obj.getPhases());
        }
        return result;
    }

    public KanbanEntrySet hasPhases(String value) {
        KanbanEntrySet result = new KanbanEntrySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            if (!value.equals(obj.getPhases())) continue;
            result.add(obj);
        }
        return result;
    }

    public KanbanEntrySet hasPhases(String lower, String upper) {
        KanbanEntrySet result = new KanbanEntrySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            if (lower.compareTo(obj.getPhases()) > 0 || obj.getPhases().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public KanbanEntrySet withPhases(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            KanbanEntry obj = (KanbanEntry)iterator.next();
            obj.setPhases(value);
        }
        return this;
    }

    public KanbanEntryPO hasKanbanEntryPO() {
        return new KanbanEntryPO((KanbanEntry[])this.toArray(new KanbanEntry[this.size()]));
    }
}

