/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards.util;

import de.uniks.networkparser.json.JsonIdMap;
import org.sdmlib.serialization.EntityFactory;
import org.sdmlib.storyboards.KanbanEntry;
import org.sdmlib.storyboards.LogEntryStoryBoard;
import org.sdmlib.storyboards.util.CreatorCreator;

public class KanbanEntryCreator
extends EntityFactory {
    private final String[] properties = new String[]{"name", "phase", "lastDeveloper", "hoursRemaining", "hoursSpend", "parent", "subentries", "logEntries", "files", "oldNoOfLogEntries", "phases"};

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getSendableInstance(boolean reference) {
        return new KanbanEntry();
    }

    @Override
    public Object getValue(Object target, String attrName) {
        int pos = attrName.indexOf(".");
        String attribute = attrName;
        if (pos > 0) {
            attribute = attrName.substring(0, pos);
        }
        if ("name".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getName();
        }
        if ("logEntries".equalsIgnoreCase(attrName)) {
            return ((KanbanEntry)target).getLogEntries();
        }
        if ("oldNoOfLogEntries".equalsIgnoreCase(attrName)) {
            return ((KanbanEntry)target).getOldNoOfLogEntries();
        }
        if ("phases".equalsIgnoreCase(attrName)) {
            return ((KanbanEntry)target).getPhases();
        }
        if ("phase".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getPhase();
        }
        if ("lastDeveloper".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getLastDeveloper();
        }
        if ("hoursRemaining".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getHoursRemaining();
        }
        if ("hoursSpend".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getHoursSpend();
        }
        if ("parent".equalsIgnoreCase(attribute)) {
            if (pos > 0) {
                return this.getValue(((KanbanEntry)target).getParent(), attrName.substring(pos + 1));
            }
            return ((KanbanEntry)target).getParent();
        }
        if ("subentries".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getSubentries();
        }
        if ("files".equalsIgnoreCase(attribute)) {
            return ((KanbanEntry)target).getFiles();
        }
        return super.getValue(target, attrName);
    }

    @Override
    public boolean setValue(Object target, String attrName, Object value, String type) {
        if ("rem".equals(type) && value != null) {
            attrName = attrName + type;
        }
        if ("name".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setName((String)value);
            return true;
        }
        if ("logEntries".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).addToLogEntries((LogEntryStoryBoard)value);
            return true;
        }
        if ("logEntriesrem".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).removeFromLogEntries((LogEntryStoryBoard)value);
            return true;
        }
        if ("oldNoOfLogEntries".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setOldNoOfLogEntries(Integer.parseInt(value.toString()));
            return true;
        }
        if ("phases".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setPhases((String)value);
            return true;
        }
        if ("phase".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setPhase((String)value);
            return true;
        }
        if ("lastDeveloper".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setLastDeveloper((String)value);
            return true;
        }
        if ("hoursRemaining".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setHoursRemaining(Double.parseDouble(value.toString()));
            return true;
        }
        if ("hoursSpend".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setHoursSpend(Double.parseDouble(value.toString()));
            return true;
        }
        if ("parent".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setParent((KanbanEntry)value);
            return true;
        }
        if ("subentries".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).addToSubentries((KanbanEntry)value);
            return true;
        }
        if ("files".equalsIgnoreCase(attrName)) {
            ((KanbanEntry)target).setFiles((String)value);
            return true;
        }
        return super.setValue(target, attrName, value, type);
    }

    public static JsonIdMap createIdMap(String sessionID) {
        return CreatorCreator.createIdMap(sessionID);
    }

    @Override
    public void removeObject(Object entity) {
        ((KanbanEntry)entity).removeYou();
    }
}

