/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.sdmlib.StrUtil;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.Storyboard;
import org.sdmlib.storyboards.util.StoryboardStepSet;

public class StoryboardStep
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_TEXT = "text";
    private String text;
    public static final StoryboardStepSet EMPTY_SET = new StoryboardStepSet();
    public static final String PROPERTY_STORYBOARD = "storyboard";
    private Storyboard storyboard = null;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        this.setStoryboard(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        if (!StrUtil.stringEquals(this.text, value)) {
            String oldValue = this.text;
            this.text = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TEXT, oldValue, value);
        }
    }

    public StoryboardStep withText(String value) {
        this.setText(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getText());
        return s.substring(1);
    }

    public Storyboard getStoryboard() {
        return this.storyboard;
    }

    public boolean setStoryboard(Storyboard value) {
        boolean changed = false;
        if (this.storyboard != value) {
            Storyboard oldValue = this.storyboard;
            if (this.storyboard != null) {
                this.storyboard = null;
                oldValue.withoutStoryboardSteps(this);
            }
            this.storyboard = value;
            if (value != null) {
                value.withStoryboardSteps(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STORYBOARD, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public StoryboardStep withStoryboard(Storyboard value) {
        this.setStoryboard(value);
        return this;
    }

    public Storyboard createStoryboard() {
        Storyboard value = new Storyboard();
        this.withStoryboard(value);
        return value;
    }
}

