/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.sdmlib.CGUtil;
import org.sdmlib.doc.DocEnvironment;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.serialization.JsonIdComparator;
import org.sdmlib.storyboards.KanbanEntry;
import org.sdmlib.storyboards.LogEntryStoryBoard;
import org.sdmlib.storyboards.Storyboard;
import org.sdmlib.storyboards.util.KanbanEntryCreator;

public class StoryboardManager {
    public static final String MODELING = "modeling";
    public static final String ACTIVE = "active";
    public static final String DONE = "done";
    public static final String IMPLEMENTATION = "implementation";
    public static final String BACKLOG = "backlog";
    private static final String DOC_KANBAN_ENTRIES_JSON = "doc/kanbanEntries.json";
    private static StoryboardManager theCatalog = null;
    public Vector<Storyboard> storyboards = new Vector();
    public TreeMap<String, TreeSet<String>> msgUsages = new TreeMap();
    private KanbanEntry kanbanBoard;
    private JsonIdMap kanbanIdMap;
    private static LinkedHashSet<String> phases = new LinkedHashSet();
    private LinkedHashSet<KanbanEntry> newEntries = new LinkedHashSet();
    private StringBuffer refColumnBody;
    public DateFormat dateParser = DateFormat.getInstance();
    Storyboard toBeRemoved = null;

    public static StoryboardManager get() {
        if (theCatalog == null) {
            theCatalog = new StoryboardManager();
            theCatalog.getPhases().add(ACTIVE);
            theCatalog.getPhases().add(BACKLOG);
            theCatalog.getPhases().add(IMPLEMENTATION);
            theCatalog.getPhases().add(DONE);
        }
        return theCatalog;
    }

    public void addToMsgUsages(String type, String pathname) {
        TreeSet<String> treeSet = this.msgUsages.get(type);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.msgUsages.put(type, treeSet);
        }
        treeSet.add(pathname);
    }

    public LinkedHashSet<String> getPhases() {
        return phases;
    }

    public void dumpHTML() {
        this.loadOldKanbanEntries();
        if (this.toBeRemoved != null) {
            KanbanEntry oldEntry = this.kanbanBoard.findOldEntry(this.toBeRemoved.getName());
            if (oldEntry != null) {
                oldEntry.removeYou();
            }
            this.toBeRemoved = null;
        }
        new DocEnvironment().copyJS("doc");
        this.dumpKanban();
    }

    public void dumpKanban() {
        TreeSet<String> fileSet = new TreeSet<String>();
        for (Storyboard storyboard : this.storyboards) {
            storyboard.dumpHTML(this.kanbanBoard);
            String filename = storyboard.getName();
            fileSet.add(filename);
        }
        this.refColumnBody = new StringBuffer();
        this.dumpKanbanBoard();
        this.dumpIndexHtml();
        this.refColumnBody.append("<br>");
        TreeSet<KanbanEntry> allEntries = new TreeSet<KanbanEntry>(this.collectEntriesFromTree(this.kanbanBoard));
        for (KanbanEntry entry : allEntries) {
            File htmlFile = new File("doc/" + entry.getName() + ".html");
            if (!htmlFile.exists()) continue;
            this.refColumnBody.append(this.refForFile(entry.getName()));
        }
        String string2 = "<html>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=9\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">\n<body>\nbodytext\n</body>\n</html>\n";
        string2 = string2.replaceFirst("bodytext", this.refColumnBody.toString());
        File file = new File("doc/refs.html");
        try {
            PrintStream out = new PrintStream(file);
            out.println(string2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.dumpKanbanEntriesToJson();
    }

    private void dumpIndexHtml() {
        File file;
        new File("doc").mkdirs();
        File styleFile = new File("doc/style.css");
        if (!styleFile.exists()) {
            String text = "BODY {color:#000000;background-color:#ffffff;font-family:Arial,Helvetica,Geneva,Sans-Serif}\nB {font-weight:bold;}\n\nH1 {font-family:Arial,Helvetica,Geneva,Sans-Serif;text-align:left;}\nH2 {color:#000000;font-family:Arial,Helvetica,Geneva,Sans-Serif;text-align:left;}\nH3 {color:#000000;font-family:Arial,Helvetica,Geneva,Sans-Serif;text-align:left;}\n\nP {font-family:Arial,Helvetica,Geneva,Sans-Serif;text-align:left;}\nPRE {font-family:Courier;text-align:left;font-size:12pt}\n\nTD {font-family:Arial,Helvetica,Geneva,Sans-Serif;}\nTH {font-family:Arial,Helvetica,Geneva,Sans-Serif;}\n\nDD {font-family:Arial,Helvetica,Geneva,Sans-Serif;}\n";
            StoryboardManager.printFile(styleFile, text);
        }
        if (!(file = new File("doc/index.html")).exists()) {
            String text = "<html>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=9\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\"><frameset cols='250,*'>\n<frame src='refs.html' name='Index'>\n<frame name='Main'>a</frame>\n<noframes>\n  <body>\n     <h2><projectTitle></h2>\n        <p><a href='refs.html'>Index</a> <a href='refs.html'>Main</a></p>\n  </body>\n</noframes>\n</frameset>\n</html>\n";
            text = text.replaceFirst("<projectTitle>", this.kanbanBoard.getName());
            StoryboardManager.printFile(file, text);
        }
    }

    private void dumpKanbanEntriesToJson() {
        JsonArray jsonArray = (JsonArray)new JsonArray().withComparator((Comparator)new JsonIdComparator());
        this.kanbanIdMap.toJsonArray((Object)this.kanbanBoard, jsonArray, null);
        String jsonString = jsonArray.toString(2);
        StoryboardManager.printFile(new File(DOC_KANBAN_ENTRIES_JSON), jsonString);
        String htmlTableText = "<html>\n<body>\n</body>\n</html>\n";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.getJSONObject(i);
            String objectLine = "<a name='objectId'><p></p></a>\n";
            objectLine = objectLine.replaceFirst("objectId", jsonObject.getString((Object)"id"));
            Iterator iter = jsonObject.keyIterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String cellString = key + ": ";
                Object object = jsonObject.get((Object)key);
                if (object.toString().startsWith("KE.")) {
                    cellString = cellString + "<a href='#" + object.toString() + "'>" + object.toString() + "</a> ";
                } else if (object instanceof JsonArray) {
                    cellString = cellString + "";
                    for (int j = 0; j < ((JsonArray)object).size(); ++j) {
                        String ref = ((JsonArray)object).getString(j);
                        cellString = cellString + "<a href='#" + ref + "'>" + ref + "</a> ";
                    }
                } else {
                    cellString = cellString + object.toString() + " ";
                }
                objectLine = objectLine.replaceFirst("</p>", cellString + "<br/></p>");
            }
            buf.append(objectLine);
        }
        htmlTableText = htmlTableText.replaceFirst("</body>", buf.toString() + "</body>");
        StoryboardManager.printFile(new File("doc/objectData.html"), htmlTableText);
    }

    public KanbanEntry loadOldKanbanEntries() {
        File file = new File(DOC_KANBAN_ENTRIES_JSON);
        this.kanbanIdMap = KanbanEntryCreator.createIdMap("KE");
        try {
            String readLine;
            URL catalogURL = file.toURI().toURL();
            StringBuffer buf = new StringBuffer();
            InputStream in = catalogURL.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((readLine = reader.readLine()) != null) {
                buf.append(readLine + '\n');
            }
            JsonArray jsonObject = new JsonArray().withValue(buf.toString());
            this.kanbanBoard = (KanbanEntry)this.kanbanIdMap.decode(jsonObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.kanbanBoard == null) {
            this.kanbanBoard = new KanbanEntry().withName("Project").withPhase(ACTIVE);
        }
        return this.kanbanBoard;
    }

    private void dumpKanbanBoard() {
        String userName = System.getProperty("user.name");
        this.collectHours(this.kanbanBoard);
        JsonArray jsonArray = new JsonArray();
        jsonArray.withComparator("id");
        this.kanbanIdMap.toJsonArray((Object)this.kanbanBoard, jsonArray, null);
        String text = jsonArray.toString(2);
        File file = new File(DOC_KANBAN_ENTRIES_JSON);
        StoryboardManager.printFile(file, text);
        LinkedHashSet<KanbanEntry> allEntries = this.collectEntriesFromTree(this.kanbanBoard);
        this.dumpTimeLinesFor(allEntries);
        this.dumpBoardForKanbanEntry(this.kanbanBoard, this.kanbanBoard.getName() + "kanban");
    }

    private void dumpTimeLinesFor(LinkedHashSet<KanbanEntry> allEntries) {
        for (KanbanEntry kanbanEntry : allEntries) {
            StringBuilder htmlText = new StringBuilder("<html>\r\n<head>\r\n<meta charset=\"utf-8\">\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=9\">\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">\r\n<link href=\"includes/nv.d3.css\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n<script src=\"includes/d3.v3.js\"></script>\r\n<script src=\"includes/nv.d3.js\"></script>\r\n\r\n<script>\r\ndata = [{ \"key\" : \"hours done\",\r\n   \"values\" : [\r\n        hoursSpendData\r\n      ]\r\n},{ \"key\" : \"hours planned\",\r\n   \"values\" : [\r\n        hoursRemainingData\r\n      ]\r\n}\r\n]\r\n\r\nnv.addGraph(function() {\r\n        var chart = nv.models.lineWithFocusChart();\r\n      chart.yAxis.axisLabel(\"Hours\");\r\n        chart.yAxis.tickFormat(d3.format(',.2f'));\r\n        chart.y2Axis.tickFormat(d3.format(',.2f'));\r\n        chart.xAxis.tickFormat(function(d) { return d3.time.format('%d %b %y')(new Date(d)) });\r\n        chart.x2Axis.tickFormat(function(d) { return d3.time.format('%d %b %y')(new Date(d)) });\r\n        \r\n      d3.select('#lineWithFocusChart svg')\r\n         .datum(data)\r\n         .call(chart);\r\n    return chart;\r\n});\r\n</script>\r\n</head>\r\n<body>\r\n<p>Burn Down and Time Line for <a href='entryNameKanbanSuffix.html' type='text/x-java'>entryName</a></p>\r\n\r\n<div id=\"lineWithFocusChart\" class='with-3d-shadow with-transitions'>\r\n    <svg style=\"height: 700px;\"></svg>\r\n</div>\r\ntimelineentries\r\n</body>\r\n</html>");
            ArrayList<LogEntryStoryBoard> allLogEntries = kanbanEntry.getAllLogEntries();
            Collections.sort(allLogEntries);
            StringBuilder timeLogText = new StringBuilder();
            StringList hoursSpendData = new StringList();
            StringList hoursRemaingData = new StringList();
            double hoursSpend = 0.0;
            LinkedHashMap<KanbanEntry, Double> hoursRemainingMap = new LinkedHashMap<KanbanEntry, Double>();
            for (LogEntryStoryBoard logEntry : allLogEntries) {
                String logLine = "<p>time entry: developer hours spend: hoursspend hours remaining: hoursremaining comment</p>\n";
                logLine = CGUtil.replaceAll(logLine, "time", "" + logEntry.getDate(), "entry", "" + logEntry.getKanbanEntry().getName(), "developer", "" + logEntry.getDeveloper(), "hoursspend", "" + logEntry.getHoursSpend(), "hoursremaining", "" + logEntry.getHoursRemainingInTotal(), "comment", "" + logEntry.getComment());
                timeLogText.insert(0, logLine);
                String dataLine = CGUtil.replaceAll("{ \"x\" : millis, \"y\" : value}", "millis", logEntry.getParsedDate().getTime(), "value", hoursSpend += logEntry.getHoursSpend());
                hoursSpendData.add(dataLine);
                hoursRemainingMap.put(logEntry.getKanbanEntry(), logEntry.getHoursRemainingInTotal());
                double sumOfHoursRemaining = 0.0;
                for (Double d : hoursRemainingMap.values()) {
                    sumOfHoursRemaining += d.doubleValue();
                }
                dataLine = CGUtil.replaceAll("{ \"x\" : millis, \"y\" : value}", "millis", logEntry.getParsedDate().getTime(), "value", hoursSpend + sumOfHoursRemaining);
                hoursRemaingData.add(dataLine);
            }
            String kanbanSuffix = "";
            if (!kanbanEntry.getSubentries().isEmpty()) {
                kanbanSuffix = "kanban";
            }
            CGUtil.replaceAll(htmlText, "entryName", kanbanEntry.getName(), "KanbanSuffix", kanbanSuffix, "hoursSpendData", hoursSpendData.concat(",\n               "), "hoursRemainingData", hoursRemaingData.concat(",\n               "), "timelineentries", timeLogText.toString());
            StoryboardManager.printFile(new File("doc/" + kanbanEntry.getName() + "TimeLine.html"), htmlText.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dumpBoardForKanbanEntry(KanbanEntry rootEntry, String boardName) {
        LinkedHashSet<KanbanEntry> allEntries = this.collectEntriesFromTree(rootEntry);
        String buf = "<html>\n<body>\n<table border='3' frame='box'>\n<headerRow>\n<tableBody></table>\n</body>\n</html>";
        String headerRow = "<tr> </tr>";
        String tableBody = "<tr> </tr>\n";
        String[] split = rootEntry.getPhases().split(", ");
        for (String string : split) {
            headerRow = headerRow.replaceFirst("</tr>", "<th>" + string + "</th> </tr>");
            tableBody = tableBody.replaceFirst("</tr>", "<td valign='top'><table border ='0'>" + string + "</table></td>\n </tr>");
        }
        buf = buf.replaceFirst("<headerRow>", headerRow);
        for (KanbanEntry entry : allEntries) {
            void var11_20;
            String phaseName = entry.getPhase();
            String string = "<tr><td><table border='1' rules='none' bgcolor='#fafad2'></table><tr><td>\n";
            if (!entry.getSubentries().isEmpty()) {
                String string2 = string.replaceFirst("</table>", "<tr><td><a href='" + entry.getName() + "kanban.html'>" + entry.getName() + "</a></td></tr>\n</table>");
            } else {
                String string3 = string.replaceFirst("</table>", "<tr><td><a href='" + entry.getName() + ".html'>" + entry.getName() + "</a></td></tr>\n</table>");
            }
            if (entry.getParent() != null) {
                void var11_18;
                String string4 = var11_18.replaceFirst("</table>", "<tr><td><a href='" + entry.getParent().getName() + "kanban.html'>" + entry.getParent().getName() + "</a></td></tr>\n</table>");
            }
            String string8 = var11_20.replaceFirst("</table>", "<tr><td>developer = " + entry.getLastDeveloper() + "</td></tr>\n</table>");
            string8 = string8.replaceFirst("</table>", "<tr><td>hours spend = " + entry.getHoursSpend() + "</td></tr>\n</table>");
            string8 = string8.replaceFirst("</table>", "<tr><td>hours remaining = " + entry.getHoursRemaining() + "</td></tr>\n</table>");
            string8 = string8.replaceFirst("</table>", "<tr><td><a href='" + entry.getName() + "TimeLine.html'>burn down</a></td></tr>\n</table>");
            tableBody = tableBody.replaceFirst(phaseName + "</table>", string8 + phaseName + "</table>");
            if (entry == rootEntry || entry.getSubentries().isEmpty()) continue;
            this.dumpBoardForKanbanEntry(entry, entry.getName() + "kanban");
        }
        for (String string : split) {
            tableBody = tableBody.replaceFirst((String)string + "</table>", "</table>");
        }
        buf = buf.replaceFirst("<tableBody>", tableBody);
        File kanbanFile = new File("doc/" + boardName + ".html");
        StoryboardManager.printFile(kanbanFile, buf);
        this.refColumnBody.insert(0, this.refForFile(boardName));
    }

    private void collectHours(KanbanEntry rootEntry) {
        double hoursSpendSum = 0.0;
        double hoursRemainingSum = 0.0;
        if (rootEntry.getPhases() == null) {
            rootEntry.setPhases("active, backlog, implementation, done");
        }
        if (!rootEntry.getSubentries().isEmpty()) {
            Iterator iterator = rootEntry.getSubentries().iterator();
            while (iterator.hasNext()) {
                KanbanEntry subentry = (KanbanEntry)iterator.next();
                this.collectHours(subentry);
                hoursSpendSum += subentry.getHoursSpend();
                hoursRemainingSum += subentry.getHoursRemaining();
                this.learnKidPhases(rootEntry, subentry);
            }
        }
        double logHoursSpend = 0.0;
        double logHoursRemaining = 0.0;
        Date latestLogEntryDate = null;
        Iterator iterator = rootEntry.getLogEntries().iterator();
        while (iterator.hasNext()) {
            LogEntryStoryBoard logEntry = (LogEntryStoryBoard)iterator.next();
            logHoursSpend += logEntry.getHoursSpend();
            if (latestLogEntryDate == null || latestLogEntryDate.compareTo(logEntry.getParsedDate()) <= 0) {
                latestLogEntryDate = logEntry.getParsedDate();
                logHoursRemaining = logEntry.getHoursRemainingInTotal();
                rootEntry.setPhase(logEntry.getPhase());
            }
            if (rootEntry.getPhases().indexOf(logEntry.getPhase()) >= 0) continue;
            rootEntry.setPhases(rootEntry.getPhases() + ", " + logEntry.getPhase());
        }
        rootEntry.setHoursSpend(hoursSpendSum += logHoursSpend);
        rootEntry.setHoursRemaining(hoursRemainingSum += logHoursRemaining);
    }

    private void learnKidPhases(KanbanEntry rootEntry, KanbanEntry subentry) {
        String[] split;
        for (String phase : split = subentry.getPhases().split(", ")) {
            if (rootEntry.getPhases().indexOf(phase) >= 0) continue;
            rootEntry.setPhases(rootEntry.getPhases() + ", " + phase);
        }
    }

    private void repairDate(LogEntryStoryBoard logEntry) {
        String dateText = logEntry.getDate();
        if (dateText == null) {
            dateText = this.dateParser.format(new Date(System.currentTimeMillis()));
            logEntry.setDate(dateText);
        } else if (dateText.indexOf(58) < 0) {
            dateText = dateText + " 12:00:00";
            logEntry.setDate(dateText);
        }
    }

    private LinkedHashSet<KanbanEntry> collectEntriesFromTree(KanbanEntry rootEntry) {
        LinkedHashSet<KanbanEntry> allEntries = new LinkedHashSet<KanbanEntry>();
        LinkedList<KanbanEntry> todo = new LinkedList<KanbanEntry>();
        todo.add(rootEntry);
        while (!todo.isEmpty()) {
            KanbanEntry pop = (KanbanEntry)todo.pop();
            allEntries.add(pop);
            if (pop.getSubentries().isEmpty()) continue;
            todo.addAll((Collection<KanbanEntry>)((Object)pop.getSubentries()));
        }
        return allEntries;
    }

    public String refForFile(String filename) {
        String ref = "<a href=\"filename.html\" target=\"Main\">filename</a><br>\n ";
        ref = ref.replaceAll("filename", filename);
        return ref;
    }

    protected String dumpMessagePage(Map.Entry<String, TreeSet<String>> entry) {
        String fileName = "Message_" + entry.getKey() + ".html";
        String page = "<html>\n<body>\ntext\n</body>\n</html>\n";
        StringBuffer text = new StringBuffer();
        String header = "<h2>Messages of type name are used by components: </h2>\n";
        header = header.replaceAll("name", entry.getKey());
        text.append(header);
        for (String file : entry.getValue()) {
            String refForFile = StoryboardManager.get().refForFile(file);
            text.append(refForFile);
        }
        page = page.replaceAll("text", text.toString());
        File file = new File("src/smartiocatalog/" + fileName);
        StoryboardManager.printFile(file, page);
        return fileName;
    }

    public static void printFile(File file, String text) {
        try {
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            PrintStream out = new PrintStream(file);
            out.print(text);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String readFile(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            while (line != null) {
                result.append(line).append('\n');
                line = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public StoryboardManager add(Storyboard storyboard) {
        this.storyboards.add(storyboard);
        return this;
    }

    public void addEntry(KanbanEntry sprint1) {
        this.newEntries.add(sprint1);
    }

    public StoryboardManager remove(Storyboard storyboard) {
        this.toBeRemoved = storyboard;
        return this;
    }
}

