/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.logic.Condition;
import de.uniks.networkparser.logic.ConditionMap;
import de.uniks.networkparser.logic.ValuesMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.junit.Assert;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.doc.GraphFactory;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Clazz;
import org.sdmlib.models.classes.logic.GenClass;
import org.sdmlib.models.modelsets.ModelSet;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.GenericObject;
import org.sdmlib.models.objects.util.GenericObjectSet;
import org.sdmlib.models.pattern.Pattern;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.serialization.EntityFactory;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.GenericCreator;
import org.sdmlib.storyboards.GenericIdMap;
import org.sdmlib.storyboards.KanbanEntry;
import org.sdmlib.storyboards.LogEntryStoryBoard;
import org.sdmlib.storyboards.StoryboardManager;
import org.sdmlib.storyboards.StoryboardStep;
import org.sdmlib.storyboards.StoryboardWall;
import org.sdmlib.storyboards.util.StoryboardStepSet;

public class Storyboard
implements PropertyChangeInterface {
    public static final String PROPERTY_STEPDONECOUNTER = "stepDoneCounter";
    public static final String PROPERTY_STEPCOUNTER = "stepCounter";
    public static final String PROPERTY_MODELROOTDIR = "modelRootDir";
    public static final String PROPERTY_ROOTDIR = "rootDir";
    public static final String PROPERTY_WALL = "wall";
    public static final String PROPERTY_STORYBOARDSTEPS = "storyboardSteps";
    public static final String MODELING = "modeling";
    public static final String ACTIVE = "active";
    public static final String DONE = "done";
    public static final String IMPLEMENTATION = "implementation";
    public static final String BACKLOG = "backlog";
    private String name = "";
    private GuiAdapter adapter;
    private String javaTestFileName = "";
    private JsonArray largestJsonArray = null;
    private Object largestRoot = null;
    private String kanbanWorkFlow = null;
    private String projectName = null;
    private int stepDoneCounter;
    private String sprintName = null;
    private int stepCounter;
    private String modelRootDir = null;
    private String rootDir = null;
    private StoryboardStepSet storyboardSteps = null;
    private int codeStartLineNumber = -1;
    private ByteArrayOutputStream systemOutRecorder;
    private JsonIdMap jsonIdMap = null;
    private LinkedHashMap<String, String> iconMap = new LinkedHashMap();
    private LinkedHashMap<String, LogEntryStoryBoard> newLogEntries = new LinkedHashMap();
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private StoryboardWall wall = null;

    public Storyboard withJsonIdMap(JsonIdMap jsonIdMap) {
        this.jsonIdMap = jsonIdMap;
        return this;
    }

    public GuiAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = GraphFactory.getAdapter();
        }
        return this.adapter;
    }

    public Storyboard withAdapter(GuiAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Storyboard withName(String name) {
        this.setName(name);
        return this;
    }

    public String findRootDir() {
        if (this.rootDir == null) {
            this.rootDir = "src";
            RuntimeException e = new RuntimeException();
            StackTraceElement[] stackTrace = e.getStackTrace();
            StackTraceElement callEntry = stackTrace[1];
            int i = 1;
            while ((callEntry = stackTrace[i]).getClassName().equals(Storyboard.class.getName())) {
                ++i;
            }
            this.javaTestFileName = callEntry.getClassName().replaceAll("\\.", "/") + ".java";
            File projectDir = new File(".");
            this.searchDirectoryTree(projectDir);
        }
        return this.rootDir;
    }

    private boolean searchDirectoryTree(File projectDir) {
        for (File subDir : projectDir.listFiles()) {
            if (!subDir.isDirectory()) continue;
            String subPath = subDir.getPath();
            if (new File(subPath + "/" + this.javaTestFileName).exists()) {
                this.rootDir = subDir.getPath().replaceAll("\\\\", "/");
                this.javaTestFileName = "../" + this.rootDir + "/" + this.javaTestFileName;
                return true;
            }
            boolean done = this.searchDirectoryTree(subDir);
            if (!done) continue;
            return true;
        }
        return false;
    }

    public Storyboard() {
        this.findRootDir();
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement callEntry = stackTrace[1];
        String methodName = stackTrace[1].getMethodName();
        if (methodName.startsWith("test")) {
            methodName = methodName.substring(4);
        }
        this.setName(methodName);
        this.addToSteps(this.name);
    }

    private void addToSteps(String text) {
        StoryboardStep storyStep = new StoryboardStep().withText(text);
        this.addToStoryboardSteps(storyStep);
    }

    public Storyboard(String rootDir) {
        if (rootDir == null) {
            return;
        }
        this.rootDir = rootDir;
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement callEntry = stackTrace[1];
        this.javaTestFileName = "../" + rootDir + "/" + callEntry.getClassName().replaceAll("\\.", "/") + ".java";
        String methodName = stackTrace[1].getMethodName();
        if (methodName.startsWith("test")) {
            methodName = methodName.substring(4);
        }
        this.setName(methodName);
        this.addToSteps(this.name);
    }

    public Storyboard(String rootDir, String name) {
        this.rootDir = rootDir;
        this.setName(name);
        this.addToSteps(name);
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement callEntry = stackTrace[1];
        this.javaTestFileName = "../" + rootDir + "/" + callEntry.getClassName().replaceAll("\\.", "/") + ".java";
    }

    public void dumpHTML(KanbanEntry kanbanBoard) {
        KanbanEntry kanbanEntry = kanbanBoard.findOldEntry(this.getName());
        if (kanbanEntry == null) {
            Date today = new Date(System.currentTimeMillis());
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            String todayString = dateFormat.format(today);
            kanbanEntry = new KanbanEntry().withName(this.getName()).withPhase(BACKLOG).withParent(kanbanBoard).withLogEntries(new LogEntryStoryBoard().withDate(todayString).withPhase(BACKLOG).withDeveloper(System.getProperty("user.name")).withHoursRemainingInTotal(0.0));
        }
        if (kanbanEntry.getPhase() == null) {
            kanbanEntry.setPhase(BACKLOG);
        }
        if (this.kanbanWorkFlow != null) {
            kanbanEntry.setPhases(this.kanbanWorkFlow);
            for (KanbanEntry parent = kanbanEntry.getParent(); parent != null; parent = parent.getParent()) {
                parent.setPhases(this.kanbanWorkFlow);
            }
        }
        if (this.projectName != null) {
            kanbanBoard.setName(this.projectName);
        }
        if (this.sprintName != null) {
            KanbanEntry sprintEntry = kanbanBoard.findOrCreate(this.sprintName);
            kanbanEntry.setParent(sprintEntry);
            if (sprintEntry.getParent() == null) {
                sprintEntry.setParent(kanbanBoard);
            }
            if (sprintEntry.getPhase() == null) {
                sprintEntry.setPhase(ACTIVE);
            }
        }
        double remainingTime = 0.0;
        double hoursSpend = 0.0;
        Iterator oldLogEntriesIter = kanbanEntry.getLogEntries().clone().iterator();
        Date latestEntryTime = null;
        for (LogEntryStoryBoard newEntry : this.newLogEntries.values()) {
            if (latestEntryTime == null) {
                latestEntryTime = newEntry.getParsedDate();
                remainingTime = newEntry.getHoursRemainingInTotal();
            } else if (latestEntryTime.compareTo(newEntry.getParsedDate()) < 0) {
                latestEntryTime = newEntry.getParsedDate();
                remainingTime = newEntry.getHoursRemainingInTotal();
            }
            hoursSpend += newEntry.getHoursSpend();
            if (oldLogEntriesIter.hasNext()) {
                LogEntryStoryBoard oldEntry = (LogEntryStoryBoard)oldLogEntriesIter.next();
                oldEntry.withDeveloper(newEntry.getDeveloper()).withDate(newEntry.getDate()).withHoursRemainingInTotal(newEntry.getHoursRemainingInTotal()).withHoursSpend(newEntry.getHoursSpend()).withPhase(newEntry.getPhase());
                continue;
            }
            kanbanEntry.addToLogEntries(newEntry);
        }
        kanbanEntry.setHoursRemaining(remainingTime);
        while (oldLogEntriesIter.hasNext()) {
            LogEntryStoryBoard oldEntry = (LogEntryStoryBoard)oldLogEntriesIter.next();
            kanbanEntry.removeFromLogEntries(oldEntry);
        }
        String htmlText = "<!DOCTYPE html>\n<html>\n<head><meta charset=\"utf-8\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">\n<link href=\"includes/diagramstyle.css\" rel=\"stylesheet\" type=\"text/css\">\n\n<script src=\"includes/dagre.min.js\"></script>\n<script src=\"includes/drawer.js\"></script>\n<script src=\"includes/graph.js\"></script>\n</head><body>\n<p>Storyboard <a href='testfilename' type='text/x-java'>storyboardName</a></p>\n$text\n</body>\n</html>\n";
        String storyboardName = this.getName();
        htmlText = htmlText.replaceFirst("storyboardName", storyboardName);
        htmlText = htmlText.replaceFirst("testfilename", this.javaTestFileName);
        kanbanEntry.setName(storyboardName);
        String shortFileName = "" + storyboardName + ".html";
        String pathname = "doc/" + shortFileName;
        StringBuffer text = new StringBuffer();
        Iterator iterator = this.getStoryboardSteps().iterator();
        while (iterator.hasNext()) {
            StoryboardStep step = (StoryboardStep)iterator.next();
            String content = step.getText();
            if (content.startsWith("<")) {
                text.append(content);
                continue;
            }
            if (content.startsWith("screendump=")) {
                String[] split = content.split("=");
                content = ((String[])split.clone())[1];
                String imgText = "<img src='" + content + "' />\n";
                text.append(imgText);
                continue;
            }
            text.append("<p>" + content + "</p>\n");
        }
        int pos = htmlText.indexOf("$text");
        htmlText = htmlText.substring(0, pos) + text.toString() + htmlText.substring(pos + "$text".length());
        this.writeToFile(shortFileName, htmlText);
        this.coverage4GeneratedModelCode(this.largestRoot);
    }

    private void writeToFile(String imgName, String fileText) {
        try {
            if (imgName.startsWith("<")) {
                System.out.println("Ups, invalid file name: " + imgName);
                return;
            }
            File oldFile = new File("doc/" + imgName);
            if (oldFile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(oldFile));
                StringBuilder oldFileText = new StringBuilder();
                String line = in.readLine();
                while (line != null) {
                    oldFileText.append(line).append("\n");
                    line = in.readLine();
                }
                String oldFileString = oldFileText.toString().trim();
                fileText = fileText.replaceAll("\\r", "");
                int oldStringLength = oldFileString.length();
                int newStringLength = fileText.length();
                if (oldFileString.equals(fileText.trim())) {
                    return;
                }
            }
            BufferedWriter out = new BufferedWriter(new FileWriter("doc/" + imgName));
            out.write(fileText);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Storyboard addStep(String txt) {
        if (this.stepCounter == 0) {
            this.add("Start: " + txt);
            this.setStepCounter(this.getStepCounter() + 1);
        } else {
            StringBuilder buf = new StringBuilder("<p><a name = 'step_stepCounter'>Step stepCounter: text</a></p>");
            CGUtil.replaceAll(buf, PROPERTY_STEPCOUNTER, "" + this.stepCounter, "text", txt);
            this.add(buf.toString());
            this.setStepCounter(this.getStepCounter() + 1);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string) {
        this.addToSteps(string);
        Storyboard storyboard = this;
        synchronized (storyboard) {
            this.notifyAll();
        }
    }

    public void addText(String string) {
        this.add(string);
    }

    public Storyboard withMap(JsonIdMap map) {
        this.jsonIdMap = map;
        return this;
    }

    public void coverage4GeneratedModelCode(Object root) {
        if (root == null) {
            return;
        }
        String className = root.getClass().getName();
        String packageName = CGUtil.packageName(className) + ".util";
        className = packageName + ".CreatorCreator";
        Object idMap = null;
        try {
            if (this.jsonIdMap == null) {
                Class<?> creatorClass = Class.forName(className);
                Method method = creatorClass.getDeclaredMethod("createIdMap", String.class);
                idMap = method.invoke(null, "debug");
                this.jsonIdMap = (JsonIdMap)idMap;
            }
            if (this.largestJsonArray == null) {
                this.largestJsonArray = this.jsonIdMap.toJsonArray(root);
            }
            JsonIdMap copyMap = (JsonIdMap)new JsonIdMap().withCreator((Iterable)this.jsonIdMap);
            copyMap.decode(this.largestJsonArray);
            this.coverSetAndPOClasses(copyMap);
            this.coverSeldomModelMethods(copyMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void coverSeldomModelMethods(JsonIdMap copyMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        LinkedHashSet<String> handledClassesNames = new LinkedHashSet<String>();
        LinkedHashSet keySet = new LinkedHashSet();
        keySet.addAll(copyMap.keySet());
        for (String key : keySet) {
            try {
                LinkedHashSet object = keySet;
                String className = object.getClass().getName();
                if (handledClassesNames.contains(className)) continue;
                handledClassesNames.add(className);
                ((Object)object).toString();
                Class<?> objectClass = object.getClass();
                try {
                    Method addPropertyChangeListenerMetod = objectClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    addPropertyChangeListenerMetod.invoke(object, new Object[]{null});
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (Method m : objectClass.getMethods()) {
                    String methodName = m.getName();
                    if (methodName.startsWith("create") && m.getParameterTypes().length == 0) {
                        try {
                            m.invoke(object, new Object[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!methodName.startsWith("get") || !methodName.endsWith("Transitive")) continue;
                    try {
                        m.invoke(object, new Object[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Method removeMethod = objectClass.getMethod("removeYou", new Class[0]);
                removeMethod.invoke(object, new Object[0]);
            }
            catch (Exception x) {}
        }
    }

    public void coverSetAndPOClasses(JsonIdMap copyMap) {
        LinkedHashSet keySet = new LinkedHashSet();
        keySet.addAll(copyMap.keySet());
        for (String key : keySet) {
            Object object = copyMap.getObject(key);
            SendableEntityCreator creatorClass = copyMap.getCreatorClass(object);
            String className = object.getClass().getName();
            String packageName = CGUtil.packageName(className) + ".util";
            String setClassName = packageName + "." + CGUtil.shortClassName(className) + "Set";
            try {
                Class<?> setClass = Class.forName(setClassName);
                Object setObject = setClass.newInstance();
                if (setObject instanceof ModelSet) {
                    String entryType = ((ModelSet)setObject).getEntryType();
                }
                Method withMethod = setClass.getMethod("with", Object.class);
                withMethod.invoke(setObject, object);
                withMethod.invoke(setObject, setObject);
                PatternObject patternObject = null;
                Class<?> patternObjectClass = null;
                Method hasPOMethod = null;
                try {
                    hasPOMethod = setClass.getMethod("has" + CGUtil.shortClassName(className) + "PO", new Class[0]);
                    patternObject = (PatternObject)hasPOMethod.invoke(setObject, new Object[0]);
                    patternObjectClass = patternObject.getClass();
                    Method allMatchesMethod = patternObjectClass.getMethod("allMatches", new Class[0]);
                    allMatchesMethod.invoke((Object)patternObject, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String text = setObject.toString();
                for (String attrName : creatorClass.getProperties()) {
                    try {
                        Method hasMethod;
                        Method getMethod = setClass.getMethod("get" + StrUtil.upFirstChar(attrName), new Class[0]);
                        Object value = getMethod.invoke(setObject, new Object[0]);
                        Object setValue = null;
                        if (value instanceof Collection) {
                            setValue = value;
                            value = ((Collection)value).iterator().next();
                        }
                        Class<Object> valueClass = value.getClass();
                        if (value instanceof Integer) {
                            valueClass = Integer.TYPE;
                        } else if (value instanceof Double) {
                            valueClass = Double.TYPE;
                        } else if (value instanceof Long) {
                            valueClass = Long.TYPE;
                        } else if (value instanceof Float) {
                            valueClass = Float.TYPE;
                        } else if (value instanceof Boolean) {
                            valueClass = Boolean.TYPE;
                        }
                        Method setMethod = setClass.getMethod("with" + StrUtil.upFirstChar(attrName), valueClass);
                        setMethod.invoke(setObject, value);
                        try {
                            Method unsetMethod = setClass.getMethod("without" + StrUtil.upFirstChar(attrName), valueClass);
                            unsetMethod.invoke(setObject, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            hasMethod = setClass.getMethod("has" + StrUtil.upFirstChar(attrName), valueClass);
                            hasMethod.invoke(setObject, value);
                            hasMethod = setClass.getMethod("has" + StrUtil.upFirstChar(attrName), valueClass, valueClass);
                            hasMethod.invoke(setObject, value, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            hasMethod = setClass.getMethod("has" + StrUtil.upFirstChar(attrName), Object.class);
                            hasMethod.invoke(setObject, value);
                            if (setValue != null) {
                                hasMethod.invoke(setObject, setValue);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        creatorClass.setValue(object, attrName, value, "");
                        creatorClass.setValue(object, attrName, value, "rem");
                        patternObject = (PatternObject)hasPOMethod.invoke(setObject, new Object[0]);
                        if (patternObject == null) continue;
                        try {
                            getMethod = patternObjectClass.getMethod("get" + StrUtil.upFirstChar(attrName), new Class[0]);
                            getMethod.invoke((Object)patternObject, new Object[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            withMethod = patternObjectClass.getMethod("with" + StrUtil.upFirstChar(attrName), valueClass);
                            withMethod.invoke((Object)patternObject, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method createMethod = patternObjectClass.getMethod("create" + StrUtil.upFirstChar(attrName), valueClass);
                            createMethod.invoke((Object)patternObject, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            hasMethod = patternObjectClass.getMethod("has" + StrUtil.upFirstChar(attrName), valueClass);
                            hasMethod.invoke((Object)patternObject, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            hasMethod = patternObjectClass.getMethod("has" + StrUtil.upFirstChar(attrName), valueClass, valueClass);
                            hasMethod.invoke((Object)patternObject, value, value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            hasMethod = patternObjectClass.getMethod("has" + StrUtil.upFirstChar(attrName), new Class[0]);
                            hasMethod.invoke((Object)patternObject, new Object[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method method = patternObjectClass.getMethod("create" + StrUtil.upFirstChar(attrName), new Class[0]);
                            method.invoke((Object)patternObject, new Object[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method method;
                            String poClassName = CGUtil.helperClassName(valueClass.getName(), "PO");
                            SendableEntityCreator poCreator = copyMap.getCreator(poClassName, true);
                            Object po = poCreator.getSendableInstance(false);
                            try {
                                method = patternObjectClass.getMethod("has" + StrUtil.upFirstChar(attrName), po.getClass());
                                method.invoke((Object)patternObject, po);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                method = patternObjectClass.getMethod("with" + StrUtil.upFirstChar(attrName), po.getClass());
                                method.invoke((Object)patternObject, po);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                method = patternObjectClass.getMethod("without" + StrUtil.upFirstChar(attrName), po.getClass());
                                method.invoke((Object)patternObject, po);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                method = patternObjectClass.getMethod("create" + StrUtil.upFirstChar(attrName), po.getClass());
                                method.invoke((Object)patternObject, po);
                            }
                            catch (Exception e) {
                            }
                        }
                        catch (Exception e) {}
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Method withoutMethod = setClass.getMethod("without", object.getClass());
                withoutMethod.invoke(setObject, object);
                creatorClass.getValue(object, "foo.bar");
                ((EntityFactory)creatorClass).removeObject(object);
            }
            catch (Exception e) {}
        }
    }

    public void addClassDiagram(ClassModel model) {
        String diagName = this.getName() + "ClassDiagram" + this.getStoryboardSteps().size();
        diagName = model.dumpClassDiagram(diagName);
        this.add(diagName);
    }

    public void addClassDiagram(ClassModel model, String rootDir) {
        String diagName = this.getName() + "ClassDiagram" + this.getStoryboardSteps().size();
        diagName = model.dumpClassDiagram(diagName);
        this.addSVGImage(diagName);
    }

    public void addObjectDiagramWith(Object ... elems) {
        ArrayList<Object> tempElems = new ArrayList<Object>(Arrays.asList(elems));
        tempElems.add(true);
        Object[] moreElems = tempElems.toArray();
        this.addObjectDiagram(moreElems);
    }

    public void addObjectDiagram(Object ... elems) {
        Object root = null;
        LinkedHashSet<Object> explicitElems = new LinkedHashSet<Object>();
        boolean restrictToExplicitElems = false;
        int i = 0;
        while (i < elems.length) {
            SendableEntityCreator objectCreator;
            String objectName = null;
            String objectIcon = null;
            Object object = null;
            while (i < elems.length && elems[i] instanceof String) {
                String txt = (String)elems[i];
                String suffix = CGUtil.shortClassName(txt);
                if (txt.indexOf(46) >= 0 && "png gif tif".indexOf(suffix) >= 0) {
                    objectIcon = txt;
                } else {
                    objectName = (String)elems[i];
                }
                ++i;
            }
            if (i >= elems.length) break;
            object = elems[i];
            ++i;
            if (object == null) continue;
            if (object.equals(true)) {
                restrictToExplicitElems = true;
                continue;
            }
            if (object.getClass().isPrimitive()) continue;
            if (object instanceof Collection) {
                explicitElems.addAll((Collection)object);
                Collection coll = (Collection)object;
                if (coll.isEmpty()) continue;
                object = coll.iterator().next();
            } else {
                explicitElems.add(object);
            }
            if (root == null) {
                root = object;
            }
            if (this.jsonIdMap == null) {
                this.jsonIdMap = (JsonIdMap)new GenericIdMap().withSessionId(null);
                this.jsonIdMap.getLogger().withError(false);
                String className = object.getClass().getName();
                String creatorClassName = CGUtil.helperClassName(className, "Creator");
                try {
                    Class<?> creatorClass = this.getClass().getClassLoader().loadClass(creatorClassName);
                    Method createIdMapMethod = creatorClass.getDeclaredMethod("createIdMap", String.class);
                    this.jsonIdMap = (JsonIdMap)createIdMapMethod.invoke(null, new Object[0]);
                    this.jsonIdMap.getLogger().withError(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((objectCreator = this.jsonIdMap.getCreatorClass(object)) == null || objectCreator instanceof GenericCreator) {
                String className = object.getClass().getName();
                String packageName = CGUtil.packageName(className) + ".util";
                className = CGUtil.helperClassName(className, "Creator");
                Object idMap = null;
                try {
                    Class<?> creatorClass = Class.forName(className);
                    Method method = creatorClass.getDeclaredMethod("createIdMap", String.class);
                    idMap = method.invoke(null, "debug");
                    this.jsonIdMap.withCreator((Iterable)((JsonIdMap)idMap));
                }
                catch (Exception e) {
                    System.out.println("Could not find creator class for " + className);
                    e.printStackTrace();
                }
            }
            if (objectName != null) {
                this.jsonIdMap.put(objectName, object);
            } else {
                objectName = this.jsonIdMap.getId(object);
            }
            if (objectIcon == null) continue;
            this.iconMap.put(objectName, objectIcon);
        }
        if (restrictToExplicitElems) {
            RestrictToFilter jsonFilter = new RestrictToFilter(explicitElems);
            this.addObjectDiagram(this.jsonIdMap, (Object)explicitElems, jsonFilter);
        } else {
            AlwaysTrueCondition conditionMap = new AlwaysTrueCondition();
            this.addObjectDiagram(this.jsonIdMap, (Object)explicitElems, conditionMap);
        }
    }

    public void addObjectDiagram(JsonIdMap jsonIdMap, Object root, ConditionMap filter) {
        JsonArray jsonArray = jsonIdMap.toJsonArray(root, new Filter().withFull(true).withPropertyRegard((Condition)filter));
        if (this.largestJsonArray == null || this.largestJsonArray.size() <= jsonArray.size()) {
            this.largestJsonArray = jsonArray;
            this.largestRoot = root;
        }
        String imgLink = this.getAdapter().withRootDir(this.getModelRootDir()).withIconMap(this.iconMap).toImg(this.getName() + (this.getStoryboardSteps().size() + 1), jsonArray);
        this.addToSteps(imgLink);
    }

    public void setKanbanPhase(String string) {
    }

    public LinkedHashMap<String, LogEntryStoryBoard> getNewLogEntries() {
        return this.newLogEntries;
    }

    public void addLogEntry(String phase, String developer, String date, double hoursSpend, double hoursRemaining, String comment) {
        LogEntryStoryBoard logEntry = new LogEntryStoryBoard().withDate(date).withPhase(phase).withDeveloper(developer).withHoursSpend(hoursSpend).withHoursRemainingInTotal(hoursRemaining).withComment(comment);
        this.addLogEntry(logEntry);
    }

    public void addLogEntry(LogEntryStoryBoard entry) {
        this.newLogEntries.put(entry.getDate(), entry);
    }

    void addSVGImage(String imageFile) {
        this.addToSteps("<embed type=\"image/svg+xml\" src='" + imageFile + "'>");
    }

    public void addImage(String imageFile) {
        this.addToSteps("<img src='" + imageFile + "'>");
    }

    public void add(String string, String phase, String developer, String date, double hoursSpend, double hoursRemaining) {
        this.add(string);
        this.addLogEntry(new LogEntryStoryBoard().withDate(date).withPhase(phase).withDeveloper(developer).withHoursSpend(hoursSpend).withHoursRemainingInTotal(hoursRemaining).withComment("Achieved: " + string));
    }

    public KanbanEntry addToDo(String entryName, String phase, String developer, String date, double hoursSpend, double hoursRemaining) {
        StoryboardManager man = StoryboardManager.get();
        KanbanEntry kanbanBoard = man.loadOldKanbanEntries();
        KanbanEntry todoEntry = kanbanBoard.findOrCreate(entryName).withLastDeveloper(developer).withPhase(phase).withParent(kanbanBoard);
        LogEntryStoryBoard logEntry = todoEntry.findOrCreateLogEntry(date, phase).withPhase(phase).withHoursRemainingInTotal(hoursRemaining).withHoursSpend(hoursSpend);
        man.dumpKanban();
        return todoEntry;
    }

    public ByteArrayOutputStream getSystemOut() {
        return this.systemOutRecorder;
    }

    public void markCodeStart() {
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement callEntry = stackTrace[1];
        this.codeStartLineNumber = callEntry.getLineNumber();
    }

    public void addCode() {
        this.addCode(this.getRootDir());
    }

    public void addCode(String rootDir) {
        String className = "";
        int codeEndLineNumber = -1;
        RuntimeException e = new RuntimeException();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement callEntry = stackTrace[1];
        if (callEntry.getMethodName().startsWith("addCode")) {
            callEntry = stackTrace[2];
        }
        codeEndLineNumber = callEntry.getLineNumber();
        className = callEntry.getClassName();
        String fileName = rootDir + "/" + className.replaceAll("\\.", "/") + ".java";
        File file = new File(fileName);
        if (file.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                String line = "";
                int lineNo = 0;
                StringBuilder buf = new StringBuilder();
                while (true) {
                    if ((line = in.readLine()) == null) {
                        continue;
                    }
                    if (++lineNo > this.codeStartLineNumber && lineNo < codeEndLineNumber) {
                        buf.append(line).append('\n');
                    }
                    if (lineNo >= codeEndLineNumber) break;
                }
                this.add("<pre>" + StrUtil.htmlEncode(buf.toString()) + "</pre>");
                in.close();
                return;
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void recordSystemOut() {
        this.systemOutRecorder = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.systemOutRecorder));
    }

    public String getMethodText(String rootDir, String className, String methodSignature) {
        ClassModel model = new ClassModel();
        Clazz clazz = model.createClazz(className);
        GenClass generator = clazz.getClassModel().getGenerator().getOrCreate(clazz);
        Parser parser = generator.getOrCreateParser(rootDir);
        int pos = parser.indexOf("method:" + methodSignature);
        if (pos < 0) {
            return "did not find method " + methodSignature + " in class " + className;
        }
        SymTabEntry symTabEntry = (SymTabEntry)parser.getSymTab().get((Object)("method:" + methodSignature));
        String methodText = "<pre>   " + StrUtil.htmlEncode(parser.getText().substring(symTabEntry.getStartPos(), symTabEntry.getEndPos() + 1)) + "</pre>";
        return methodText;
    }

    public void addGenericObjectDiag(GenericGraph graph) {
        this.addGenericObjectDiag(graph, GenericObject.EMPTY_SET);
    }

    public void addGenericObjectDiag(GenericGraph graph, GenericObjectSet hiddenObjects) {
        this.addGenericObjectDiag(this.getName() + "GenObjDiagStep" + this.getStoryboardSteps().size(), graph, hiddenObjects);
    }

    public void addGenericObjectDiag(String diagramName, GenericGraph graph) {
        this.addGenericObjectDiag(diagramName, graph, GenericObject.EMPTY_SET);
    }

    public void addGenericObjectDiag(String diagramName, GenericGraph graph, GenericObjectSet hiddenObjects) {
        String link = this.getAdapter().addGenericObjectDiag(diagramName, graph, hiddenObjects);
        this.addToSteps(link);
    }

    public Storyboard with(String string) {
        this.add(string);
        return this;
    }

    public void dumpHTML() {
        StoryboardManager.get().add(this).dumpHTML();
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        this.add("Check: " + message + " " + expected + " actual " + actual);
        if (Math.abs(expected - actual) > delta) {
            this.dumpHTML();
        }
        Assert.assertEquals((String)("FAILED: " + message), (double)expected, (double)actual, (double)delta);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        this.add("Check: " + message + " " + expected + " actual " + actual);
        if (expected != actual) {
            this.dumpHTML();
        }
        Assert.assertEquals((String)("FAILED: " + message), (Object)expected, (Object)actual);
    }

    public void assertTrue(String message, boolean condition) {
        this.add("Check: " + message + " " + condition);
        if (!condition) {
            this.dumpHTML();
        }
        Assert.assertTrue((String)("FAILED: " + message), (boolean)condition);
    }

    public void assertFalse(String message, boolean condition) {
        this.add("Check: " + message + " " + condition);
        if (condition) {
            this.dumpHTML();
        }
        Assert.assertFalse((String)("FAILED: " + message), (boolean)condition);
    }

    public void assertEquals(String message, int expected, int actual) {
        this.add("Check: " + message + " " + expected + " actual " + actual);
        if (expected != actual) {
            this.dumpHTML();
        }
        Assert.assertEquals((String)("FAILED: " + message), (long)expected, (long)actual);
    }

    public void assertNotNull(String message, Object obj) {
        this.add("Check: " + message + " " + obj);
        if (obj == null) {
            this.dumpHTML();
        }
        Assert.assertNotNull((String)("FAILED: " + message), (Object)obj);
    }

    public void assertNull(String message, Object obj) {
        this.add("Check: " + message + obj);
        if (obj != null) {
            this.dumpHTML();
        }
        Assert.assertNull((String)("FAILED: " + message), (Object)obj);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        this.removeAllFromStoryboardSteps();
        this.withoutStoryboardSteps((StoryboardStep[])this.getStoryboardSteps().toArray(new StoryboardStep[this.getStoryboardSteps().size()]));
        this.setWall(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append("Storyboard" + this.getStoryboardSteps().getFirst());
        s.append(" ").append(this.getRootDir());
        s.append(" ").append(this.getStepCounter());
        s.append(" ").append(this.getStepDoneCounter());
        return s.substring(1);
    }

    public StoryboardStepSet getStoryboardSteps() {
        if (this.storyboardSteps == null) {
            return StoryboardStep.EMPTY_SET;
        }
        return this.storyboardSteps;
    }

    public boolean addToStoryboardSteps(StoryboardStep value) {
        boolean changed = false;
        if (value != null) {
            if (this.storyboardSteps == null) {
                this.storyboardSteps = new StoryboardStepSet();
            }
            if (changed = this.storyboardSteps.add(value)) {
                value.withStoryboard(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STORYBOARDSTEPS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromStoryboardSteps(StoryboardStep value) {
        boolean changed = false;
        if (this.storyboardSteps != null && value != null && (changed = this.storyboardSteps.remove(value))) {
            value.setStoryboard(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STORYBOARDSTEPS, value, null);
        }
        return changed;
    }

    public Storyboard withStoryboardSteps(StoryboardStep ... value) {
        for (StoryboardStep item : value) {
            this.addToStoryboardSteps(item);
        }
        return this;
    }

    public Storyboard withoutStoryboardSteps(StoryboardStep ... value) {
        for (StoryboardStep item : value) {
            this.removeFromStoryboardSteps(item);
        }
        return this;
    }

    public void removeAllFromStoryboardSteps() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getStoryboardSteps());
        for (StoryboardStep value : tmpSet) {
            this.removeFromStoryboardSteps(value);
        }
    }

    public StoryboardStep createStoryboardSteps() {
        StoryboardStep value = new StoryboardStep();
        this.withStoryboardSteps(value);
        return value;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String value) {
        if (!StrUtil.stringEquals(this.rootDir, value)) {
            String oldValue = this.rootDir;
            this.rootDir = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ROOTDIR, oldValue, value);
        }
    }

    public Storyboard withRootDir(String value) {
        this.setRootDir(value);
        return this;
    }

    public String getModelRootDir() {
        if (this.modelRootDir == null) {
            return this.rootDir;
        }
        return this.modelRootDir;
    }

    public void setModelRootDir(String value) {
        if (!StrUtil.stringEquals(this.modelRootDir, value)) {
            String oldValue = this.modelRootDir;
            this.modelRootDir = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MODELROOTDIR, oldValue, value);
        }
    }

    public Storyboard withModelRootDir(String value) {
        this.setModelRootDir(value);
        return this;
    }

    public int getStepCounter() {
        return this.stepCounter;
    }

    public void setStepCounter(int value) {
        if (this.stepCounter != value) {
            int oldValue = this.stepCounter;
            this.stepCounter = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STEPCOUNTER, oldValue, value);
        }
    }

    public Storyboard withStepCounter(int value) {
        this.setStepCounter(value);
        return this;
    }

    public int getStepDoneCounter() {
        return this.stepDoneCounter;
    }

    public void setStepDoneCounter(int value) {
        if (this.stepDoneCounter != value) {
            int oldValue = this.stepDoneCounter;
            this.stepDoneCounter = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STEPDONECOUNTER, oldValue, value);
        }
    }

    public Storyboard withStepDoneCounter(int value) {
        this.setStepDoneCounter(value);
        return this;
    }

    public void addPreformatted(String expandedText) {
        expandedText = StrUtil.htmlEncode(expandedText);
        this.add("<pre>" + expandedText + "</pre>");
    }

    public void addPattern(PatternObject patternObject, boolean b) {
        this.addPattern(patternObject.getPattern(), b);
    }

    public void addPattern(Pattern pattern, boolean b) {
        String diagName = "" + this.getName() + "PatternDiagram" + this.getStoryboardSteps().size();
        String link = pattern.dumpDiagram(diagName, b);
        this.add(link);
    }

    public void setSprint(String string) {
        this.sprintName = string;
    }

    public void removeFromProject() {
        StoryboardManager.get().remove(this).dumpHTML();
    }

    public void setKanbanWorkFlow(String string) {
        this.kanbanWorkFlow = string;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public void dumpDiagram(PatternObject<?, ?> po, String name) {
        this.add(po.getPattern().dumpDiagram(name));
    }

    public StoryboardWall getWall() {
        return this.wall;
    }

    public boolean setWall(StoryboardWall value) {
        boolean changed = false;
        if (this.wall != value) {
            StoryboardWall oldValue = this.wall;
            if (this.wall != null) {
                this.wall = null;
                oldValue.setStoryboard(null);
            }
            this.wall = value;
            if (value != null) {
                value.withStoryboard(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_WALL, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Storyboard withWall(StoryboardWall value) {
        this.setWall(value);
        return this;
    }

    public StoryboardWall createWall() {
        StoryboardWall value = new StoryboardWall();
        this.withWall(value);
        return value;
    }

    public static class RestrictToFilter
    extends ConditionMap {
        private LinkedHashSet<Object> explicitElems;

        public RestrictToFilter(LinkedHashSet<Object> explicitElems) {
            this.explicitElems = explicitElems;
        }

        public boolean check(ValuesMap values) {
            if (values.value != null && "Integer Float Double Long Boolean String".indexOf(values.value.getClass().getSimpleName()) >= 0) {
                return true;
            }
            return this.explicitElems.contains(values.value);
        }
    }

    private class AlwaysTrueCondition
    extends ConditionMap {
        private AlwaysTrueCondition() {
        }

        public boolean check(ValuesMap values) {
            return true;
        }
    }
}

