/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sdmlib.StrUtil;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.KanbanEntry;
import org.sdmlib.storyboards.util.LogEntryStoryBoardSet;

public class LogEntryStoryBoard
implements PropertyChangeInterface,
Comparable<LogEntryStoryBoard> {
    public static final LogEntryStoryBoardSet EMPTY_SET = new LogEntryStoryBoardSet();
    public static final String PROPERTY_DATE = "date";
    private String date;
    private Date parsedDate = null;
    public static final String PROPERTY_HOURS_SPEND = "hoursSpend";
    private double hoursSpend;
    public static final String PROPERTY_HOURS_REMAINING_IN_TOTAL = "hoursRemainingInTotal";
    private double hoursRemainingInTotal;
    public static final String PROPERTY_DEVELOPER = "developer";
    private String developer;
    public static final String PROPERTY_PHASE = "phase";
    private String phase;
    public static final String PROPERTY_COMMENT = "comment";
    private String comment;
    protected final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_KANBANENTRY = "kanbanEntry";
    private KanbanEntry kanbanEntry = null;

    public LogEntryStoryBoard() {
        int i = 0;
        ++i;
    }

    public Date getParsedDate() {
        return this.parsedDate;
    }

    public void setDate(String value) {
        if (StrUtil.stringCompare(this.date, value) != 0) {
            String oldValue = this.date;
            this.date = value;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            try {
                this.parsedDate = dateFormat.parse(this.date);
            }
            catch (ParseException e) {
                dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                try {
                    this.parsedDate = dateFormat.parse(this.date);
                }
                catch (ParseException e2) {
                    e2.printStackTrace();
                }
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DATE, oldValue, value);
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setHoursSpend(double value) {
        if (this.hoursSpend != value) {
            double oldValue = this.hoursSpend;
            this.hoursSpend = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOURS_SPEND, oldValue, value);
        }
    }

    public double getHoursSpend() {
        return this.hoursSpend;
    }

    public void setHoursRemainingInTotal(double value) {
        if (this.hoursRemainingInTotal != value) {
            double oldValue = this.hoursRemainingInTotal;
            this.hoursRemainingInTotal = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOURS_REMAINING_IN_TOTAL, oldValue, value);
        }
    }

    public double getHoursRemainingInTotal() {
        return this.hoursRemainingInTotal;
    }

    public void setDeveloper(String value) {
        if (StrUtil.stringCompare(this.developer, value) != 0) {
            String oldValue = this.developer;
            this.developer = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DEVELOPER, oldValue, value);
        }
    }

    public String getDeveloper() {
        return this.developer;
    }

    public void setPhase(String value) {
        if (StrUtil.stringCompare(this.phase, value) != 0) {
            String oldValue = this.phase;
            this.phase = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PHASE, oldValue, value);
        }
    }

    public String getPhase() {
        return this.phase;
    }

    public void setComment(String value) {
        if (StrUtil.stringCompare(this.comment, value) != 0) {
            String oldValue = this.comment;
            this.comment = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_COMMENT, oldValue, value);
        }
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public LogEntryStoryBoard withDate(String newValue) {
        this.setDate(newValue);
        return this;
    }

    public LogEntryStoryBoard withHoursSpend(double newValue) {
        this.setHoursSpend(newValue);
        return this;
    }

    public LogEntryStoryBoard withHoursRemainingInTotal(double newValue) {
        this.setHoursRemainingInTotal(newValue);
        return this;
    }

    public LogEntryStoryBoard withDeveloper(String newValue) {
        this.setDeveloper(newValue);
        return this;
    }

    public LogEntryStoryBoard withPhase(String newValue) {
        this.setPhase(newValue);
        return this;
    }

    public LogEntryStoryBoard withComment(String newValue) {
        this.setComment(newValue);
        return this;
    }

    public KanbanEntry getKanbanEntry() {
        return this.kanbanEntry;
    }

    public boolean setKanbanEntry(KanbanEntry value) {
        boolean changed = false;
        if (this.kanbanEntry != value) {
            KanbanEntry oldValue = this.kanbanEntry;
            if (this.kanbanEntry != null) {
                this.kanbanEntry = null;
                oldValue.withoutLogEntries(this);
            }
            this.kanbanEntry = value;
            if (value != null) {
                value.withLogEntries(this);
            }
            changed = true;
        }
        return changed;
    }

    public LogEntryStoryBoard withKanbanEntry(KanbanEntry value) {
        this.setKanbanEntry(value);
        return this;
    }

    public void removeYou() {
        this.setKanbanEntry(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public int compareTo(LogEntryStoryBoard o) {
        return this.getParsedDate().compareTo(o.getParsedDate());
    }

    public KanbanEntry createKanbanEntry() {
        KanbanEntry value = new KanbanEntry();
        this.withKanbanEntry(value);
        return value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" ").append(this.getDate());
        buf.append(" ").append(this.getPhase());
        buf.append(" ").append(this.getDeveloper());
        buf.append(" ").append(this.getHoursSpend());
        buf.append(" ").append(this.getHoursRemainingInTotal());
        return buf.substring(1);
    }
}

