/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.LogEntryStoryBoard;
import org.sdmlib.storyboards.StoryboardManager;
import org.sdmlib.storyboards.util.KanbanEntrySet;
import org.sdmlib.storyboards.util.LogEntryStoryBoardSet;

public class KanbanEntry
implements PropertyChangeInterface,
Comparable<KanbanEntry> {
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final String PROPERTY_PHASE = "phase";
    private String phase;
    public static final String PROPERTY_LAST_DEVELOPER = "lastDeveloper";
    private String lastDeveloper;
    public static final String PROPERTY_HOURS_REMAINING = "hoursRemaining";
    private double hoursRemaining;
    public static final String PROPERTY_HOURS_SPEND = "hoursSpend";
    private double hoursSpend;
    public static final String PROPERTY_PARENT = "parent";
    private KanbanEntry parent;
    public static final String PROPERTY_SUBENTRIES = "subentries";
    private KanbanEntrySet subentries;
    public static final String PROPERTY_FILES = "files";
    public static final KanbanEntrySet EMPTY_SET = new KanbanEntrySet();
    private String files;
    protected final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_LOGENTRIES = "logEntries";
    private LogEntryStoryBoardSet logEntries = null;
    public static final String PROPERTY_OLDNOOFLOGENTRIES = "oldNoOfLogEntries";
    private int oldNoOfLogEntries;
    public static final String PROPERTY_PHASES = "phases";
    private String phases;

    public void setName(String value) {
        if (StrUtil.stringCompare(this.name, value) != 0) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setPhase(String value) {
        if (StrUtil.stringCompare(this.phase, value) != 0) {
            String oldValue = this.phase;
            this.phase = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PHASE, oldValue, value);
        }
    }

    public String getPhase() {
        return this.phase;
    }

    public void setLastDeveloper(String value) {
        if (StrUtil.stringCompare(this.lastDeveloper, value) != 0) {
            String oldValue = this.lastDeveloper;
            this.lastDeveloper = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LAST_DEVELOPER, oldValue, value);
        }
    }

    public String getLastDeveloper() {
        return this.lastDeveloper;
    }

    public void setHoursRemaining(double value) {
        if (this.hoursRemaining != value) {
            double oldValue = this.hoursRemaining;
            this.hoursRemaining = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOURS_REMAINING, oldValue, value);
        }
    }

    public double getHoursRemaining() {
        return this.hoursRemaining;
    }

    public void setHoursSpend(double value) {
        if (this.hoursSpend != value) {
            double oldValue = this.hoursSpend;
            this.hoursSpend = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOURS_SPEND, oldValue, value);
        }
    }

    public double getHoursSpend() {
        return this.hoursSpend;
    }

    public boolean setParent(KanbanEntry value) {
        boolean changed = false;
        if (this.parent != value) {
            KanbanEntry oldValue = this.parent;
            if (this.parent != null) {
                this.parent = null;
                oldValue.removeFromSubentries(this);
            }
            this.parent = value;
            if (value != null) {
                value.addToSubentries(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENT, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public KanbanEntry getParent() {
        return this.parent;
    }

    public boolean addToSubentries(KanbanEntry value) {
        boolean changed = false;
        if (value != null) {
            if (this.subentries == null) {
                this.subentries = new KanbanEntrySet();
            }
            if (changed = this.subentries.add(value)) {
                value.setParent(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUBENTRIES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromSubentries(KanbanEntry value) {
        boolean changed = false;
        if (this.subentries != null && value != null && (changed = this.subentries.remove(value))) {
            value.setParent(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUBENTRIES, value, null);
        }
        return changed;
    }

    public void removeAllFromSubentries() {
        Iterator iter = this.getSubentries().iterator();
        while (iter.hasNext()) {
            KanbanEntry tmpValue = (KanbanEntry)iter.next();
            this.removeFromSubentries(tmpValue);
        }
    }

    public void setFiles(String value) {
        if (StrUtil.stringCompare(this.files, value) != 0) {
            String oldValue = this.files;
            this.files = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FILES, oldValue, value);
        }
    }

    public String getFiles() {
        return this.files;
    }

    public LogEntryStoryBoard findOrCreateLogEntry(String date, String phase) {
        LogEntryStoryBoard result = null;
        Iterator iterator = this.getLogEntries().iterator();
        while (iterator.hasNext()) {
            LogEntryStoryBoard logEntry = (LogEntryStoryBoard)iterator.next();
            if (logEntry.getDate() == null || !logEntry.getDate().equals(date)) continue;
            return logEntry;
        }
        result = new LogEntryStoryBoard().withDate(date).withDeveloper(System.getProperty("user.name")).withHoursSpend(0.0).withHoursRemainingInTotal(0.0).withPhase(phase).withKanbanEntry(this);
        return result;
    }

    public KanbanEntry findOldEntry(String name) {
        KanbanEntry result = null;
        if (StrUtil.stringEquals(this.getName(), name)) {
            return this;
        }
        Iterator iterator = this.getSubentries().iterator();
        while (iterator.hasNext()) {
            KanbanEntry subEntry = (KanbanEntry)iterator.next();
            result = subEntry.findOldEntry(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public KanbanEntry findOrCreate(String name) {
        KanbanEntry result = this.findOldEntry(name);
        if (result == null) {
            result = new KanbanEntry().withName(name);
        }
        return result;
    }

    public KanbanEntry linkToTest(String rootDir, String className) {
        return this.linkToTest(rootDir, className, this.getName());
    }

    public KanbanEntry linkToTest(String rootDir, String className, String testName) {
        CharSequence fileBody;
        int lastDotPos = className.lastIndexOf(46);
        String packageName = className.substring(0, lastDotPos);
        String fileName = rootDir + "." + className;
        className = className.substring(lastDotPos + 1);
        fileName = fileName.replaceAll("\\.", "/");
        fileName = fileName + ".java";
        File javaFile = new File(fileName);
        this.setFiles(fileName);
        if (!javaFile.exists()) {
            fileBody = new StringBuilder("/*\n   Copyright (c) <year> <developer> \n   \n   Permission is hereby granted, free of charge, to any person obtaining a copy of this software \n   and associated documentation files (the \"Software\"), to deal in the Software without restriction, \n   including without limitation the rights to use, copy, modify, merge, publish, distribute, \n   sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is \n   furnished to do so, subject to the following conditions: \n   \n   The above copyright notice and this permission notice shall be included in all copies or \n   substantial portions of the Software. \n   \n   The Software shall be used for Good, not Evil. \n   \n   THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING \n   BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND \n   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, \n   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, \n   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. \n */\n   \npackage " + packageName + ";\n" + "   \n" + "import org.junit.Test;\n" + "import org.sdmlib.storyboards.LogEntry;\n" + "import org.sdmlib.storyboards.Storyboard;\n" + "import org.sdmlib.storyboards.StoryboardManager;\n" + "   \n" + "public class " + className + " \n" + "{\n" + "   private static final String MODELING = \"modeling\";\n" + "   private static final String ACTIVE = \"active\";\n" + "   private static final String DONE = \"done\";\n" + "   private static final String IMPLEMENTATION = \"implementation\";\n" + "   private static final String BACKLOG = \"backlog\";\n" + "   private static final String BUG = \"bug\";\n" + "}\n");
            String year = new SimpleDateFormat("yyyy").format(new Date(System.currentTimeMillis()));
            CGUtil.replace((StringBuilder)fileBody, "<year>", year);
            CGUtil.replace((StringBuilder)fileBody, "<developer>", System.getProperty("user.name"));
            StoryboardManager.get();
            StoryboardManager.printFile(javaFile, ((StringBuilder)fileBody).toString());
        }
        StoryboardManager.get();
        fileBody = StoryboardManager.readFile(javaFile);
        String methodName = "test" + testName;
        lastDotPos = ((String)fileBody).indexOf("public void " + methodName);
        if (lastDotPos < 0) {
            String testBody = "   @Test\n   public void " + methodName + "()\n" + "   {\n" + "      Storyboard storyboard = new Storyboard(\"" + rootDir + "\", \"" + testName + "\");\n" + "      \n" + "      storyboard.add(\"Start situation: \",\n" + "         BACKLOG, " + "\"" + System.getProperty("user.name") + "\", " + "\"" + StoryboardManager.get().dateParser.format(new Date(System.currentTimeMillis())) + "\", " + "0, 0);\n" + "      \n" + "      storyboard.dumpHTML();\n" + "   }\n\n";
            lastDotPos = ((String)fileBody).indexOf(123);
            fileBody = ((String)fileBody).substring(0, lastDotPos + 2) + testBody + ((String)fileBody).substring(lastDotPos + 2);
            StoryboardManager.get();
            StoryboardManager.printFile(javaFile, (String)fileBody);
        }
        return this;
    }

    public KanbanEntry withParent(KanbanEntry newValue) {
        this.setParent(newValue);
        return this;
    }

    public KanbanEntrySet getSubentries() {
        if (this.subentries == null) {
            return EMPTY_SET;
        }
        return this.subentries;
    }

    public KanbanEntry withSubentries(KanbanEntry newValue) {
        this.addToSubentries(newValue);
        return this;
    }

    public KanbanEntry withoutSubentries(KanbanEntry newValue) {
        this.removeFromSubentries(newValue);
        return this;
    }

    public KanbanEntry withName(String newValue) {
        this.setName(newValue);
        return this;
    }

    public KanbanEntry withPhase(String newValue) {
        this.setPhase(newValue);
        return this;
    }

    public KanbanEntry withLastDeveloper(String newValue) {
        this.setLastDeveloper(newValue);
        return this;
    }

    public KanbanEntry withHoursRemaining(double newValue) {
        this.setHoursRemaining(newValue);
        return this;
    }

    public KanbanEntry withHoursSpend(double newValue) {
        this.setHoursSpend(newValue);
        return this;
    }

    public KanbanEntry withFiles(String newValue) {
        this.setFiles(newValue);
        return this;
    }

    public void removeYou() {
        this.setParent(null);
        this.withoutLogEntries((LogEntryStoryBoard[])this.getLogEntries().toArray(new LogEntryStoryBoard[this.getLogEntries().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public LogEntryStoryBoardSet getLogEntries() {
        if (this.logEntries == null) {
            return LogEntryStoryBoard.EMPTY_SET;
        }
        return this.logEntries;
    }

    public boolean addToLogEntries(LogEntryStoryBoard value) {
        boolean changed = false;
        if (value != null) {
            if (this.logEntries == null) {
                this.logEntries = new LogEntryStoryBoardSet();
            }
            if (changed = this.logEntries.add(value)) {
                value.withKanbanEntry(this);
            }
        }
        return changed;
    }

    public boolean removeFromLogEntries(LogEntryStoryBoard value) {
        boolean changed = false;
        if (this.logEntries != null && value != null && (changed = this.logEntries.remove(value))) {
            value.setKanbanEntry(null);
        }
        return changed;
    }

    public KanbanEntry withLogEntries(LogEntryStoryBoard value) {
        this.addToLogEntries(value);
        return this;
    }

    public KanbanEntry withoutLogEntries(LogEntryStoryBoard value) {
        this.removeFromLogEntries(value);
        return this;
    }

    public void removeAllFromLogEntries() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getLogEntries());
        for (LogEntryStoryBoard value : tmpSet) {
            this.removeFromLogEntries(value);
        }
    }

    @Override
    public int compareTo(KanbanEntry o) {
        if (this.getName() != null) {
            return this.getName().compareTo(o.getName());
        }
        return 0;
    }

    public int getOldNoOfLogEntries() {
        return this.oldNoOfLogEntries;
    }

    public void setOldNoOfLogEntries(int value) {
        if (this.oldNoOfLogEntries != value) {
            int oldValue = this.oldNoOfLogEntries;
            this.oldNoOfLogEntries = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OLDNOOFLOGENTRIES, oldValue, value);
        }
    }

    public KanbanEntry withOldNoOfLogEntries(int value) {
        this.setOldNoOfLogEntries(value);
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" ").append(this.getName());
        buf.append(" ").append(this.getPhase());
        buf.append(" ").append(this.getOldNoOfLogEntries());
        return buf.substring(1);
    }

    public ArrayList<LogEntryStoryBoard> getAllLogEntries() {
        ArrayList<LogEntryStoryBoard> allLogEntries = new ArrayList<LogEntryStoryBoard>();
        allLogEntries.addAll((Collection<LogEntryStoryBoard>)((Object)this.getLogEntries()));
        Iterator iterator = this.getSubentries().iterator();
        while (iterator.hasNext()) {
            KanbanEntry subEntry = (KanbanEntry)iterator.next();
            allLogEntries.addAll(subEntry.getAllLogEntries());
        }
        return allLogEntries;
    }

    public String getPhases() {
        return this.phases;
    }

    public void setPhases(String value) {
        if (!StrUtil.stringEquals(this.phases, value)) {
            String oldValue = this.phases;
            this.phases = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PHASES, oldValue, value);
        }
    }

    public KanbanEntry withPhases(String value) {
        this.setPhases(value);
        return this;
    }

    public KanbanEntry withLogEntries(LogEntryStoryBoard ... value) {
        for (LogEntryStoryBoard item : value) {
            this.addToLogEntries(item);
        }
        return this;
    }

    public KanbanEntry withoutLogEntries(LogEntryStoryBoard ... value) {
        for (LogEntryStoryBoard item : value) {
            this.removeFromLogEntries(item);
        }
        return this;
    }

    public LogEntryStoryBoard createLogEntries() {
        LogEntryStoryBoard value = new LogEntryStoryBoard();
        this.withLogEntries(value);
        return value;
    }
}

