/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.storyboards;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.serialization.EntityFactory;

public class GenericCreator
extends EntityFactory {
    private String className = "";
    private String[] properties = null;
    private Object protoType = null;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public GenericCreator withClassName(String className) {
        this.setClassName(className);
        return this;
    }

    @Override
    public void removeObject(Object entity) {
        super.removeObject(entity);
    }

    @Override
    public Object call(Object entity, String method, Object ... args) {
        return super.call(entity, method, args);
    }

    @Override
    public String[] getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        try {
            Class<?> clazz = Class.forName(this.className);
            Method[] methods = clazz.getMethods();
            LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
            for (Method method : methods) {
                String methodName = method.getName();
                if (!methodName.startsWith("get") || methodName.equals("getClass") || methodName.equals("getPropertyChangeSupport")) continue;
                methodName = methodName.substring(3);
                if ("".equals((methodName = StrUtil.downFirstChar(methodName)).trim())) continue;
                fieldNames.add(methodName);
            }
            this.properties = fieldNames.toArray(new String[0]);
            return this.properties;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return super.getProperties();
        }
    }

    @Override
    public Object getSendableInstance(boolean usePrototype) {
        if (this.protoType == null || !usePrototype) {
            try {
                Class<?> clazz = Class.forName(this.className);
                this.protoType = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.protoType;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (entity == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.className);
            Method method = clazz.getMethod("get" + StrUtil.upFirstChar(attribute), new Class[0]);
            Object invoke = method.invoke(entity, new Object[0]);
            return invoke;
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Class.forName(this.className);
                Method method = clazz.getMethod(attribute, new Class[0]);
                Object invoke = method.invoke(entity, new Object[0]);
                return invoke;
            }
            catch (Exception e2) {
                return super.getValue(entity, attribute);
            }
        }
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (entity == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(this.className);
            Method method = clazz.getMethod("set", String.class, Object.class);
            method.invoke(entity, attribute, value);
            return true;
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Class.forName(this.className);
                Method method = clazz.getMethod("set" + StrUtil.upFirstChar(attribute), value.getClass());
                method.invoke(entity, value);
                return true;
            }
            catch (Exception e2) {
                try {
                    int intValue = Integer.parseInt((String)value);
                    Class<?> clazz = Class.forName(this.className);
                    Method method = clazz.getMethod("set" + StrUtil.upFirstChar(attribute), Integer.TYPE);
                    method.invoke(entity, intValue);
                    return true;
                }
                catch (Exception e3) {
                    try {
                        double doubleValue = Double.parseDouble((String)value);
                        Class<?> clazz = Class.forName(this.className);
                        Method method = clazz.getMethod("set" + StrUtil.upFirstChar(attribute), Double.TYPE);
                        method.invoke(entity, doubleValue);
                        return true;
                    }
                    catch (Exception e4) {
                        try {
                            float floatValue = Float.parseFloat((String)value);
                            Class<?> clazz = Class.forName(this.className);
                            Method method = clazz.getMethod("set" + StrUtil.upFirstChar(attribute), Float.TYPE);
                            method.invoke(entity, Float.valueOf(floatValue));
                            return true;
                        }
                        catch (Exception e5) {
                            try {
                                Class<?> clazz = Class.forName(this.className);
                                Method method = clazz.getMethod("with" + StrUtil.upFirstChar(attribute), value.getClass());
                                method.invoke(entity, value);
                                return true;
                            }
                            catch (Exception e6) {
                                try {
                                    Method[] methods;
                                    Class<?> clazz = Class.forName(this.className);
                                    for (Method method : methods = clazz.getMethods()) {
                                        String name = method.getName();
                                        if (!name.startsWith("with" + StrUtil.upFirstChar(attribute))) continue;
                                        Object param = Array.newInstance(value.getClass(), 1);
                                        Array.set(param, 0, value);
                                        method.invoke(entity, param);
                                        return true;
                                    }
                                    return true;
                                }
                                catch (Exception e7) {
                                    return super.setValue(entity, attribute, value, type);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

